/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.CloudUrlWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;

public class ManageCloudDialog
extends Dialog {
    private final String serverTypeId;
    private List<AbstractCloudFoundryUrl> cloudUrls;
    private Set<String> urlsToDelete;
    private Set<CloudFoundryServer> serversToDelete;
    private AbstractCloudFoundryUrl lastAddedEditedURL;
    private IRunnableContext runnableContext;

    protected ManageCloudDialog(Shell parentShell, String serverTypeId) {
        this(parentShell, serverTypeId, null);
    }

    protected ManageCloudDialog(Shell parentShell, String serverTypeId, IRunnableContext runnableContext) {
        super(parentShell);
        this.serverTypeId = serverTypeId;
        this.serversToDelete = new HashSet<CloudFoundryServer>();
        this.urlsToDelete = new HashSet<String>();
        this.runnableContext = runnableContext;
    }

    private TableViewer createTableViewer(Composite parent, String[] columnNames, int[] columnWeights) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 200).applyTo((Control)container);
        TableColumnLayout layout = new TableColumnLayout();
        container.setLayout((Layout)layout);
        Table table = new Table(container, 67586);
        table.setHeaderVisible(true);
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnNames[i]);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        TableViewer tableViewer = new TableViewer(table);
        tableViewer.setColumnProperties(columnNames);
        return tableViewer;
    }

    protected CloudFoundryBrandingExtensionPoint.CloudServerURL promptForCloudURL(String serverID, Shell shell, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allURLs, String existingURL, String existingName) {
        boolean selfSigned = existingURL != null && CloudFoundryServer.isSelfSigned((String)existingURL);
        CloudUrlWizard wizard = new CloudUrlWizard(serverID, allURLs, existingURL, existingName, selfSigned);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getCloudUrl();
        }
        return null;
    }

    protected AbstractCloudFoundryUrl promptForCloudFoundryUrl(String serverID, Shell shell, List<AbstractCloudFoundryUrl> allURLs, String existingURL, String existingName) {
        boolean selfSigned = existingURL != null && CloudFoundryServer.isSelfSigned((String)existingURL);
        CloudUrlWizard wizard = new CloudUrlWizard(serverID, existingURL, existingName, selfSigned, allURLs);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getCloudFoundryUrl();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.ManageCloudDialog_TEXT_MANAGE_CLOUD_URL);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(2).equalWidth(false).applyTo(composite);
        final TableViewer viewer = this.createTableViewer(composite, new String[]{Messages.ManageCloudDialog_TEXT_SERVER_TYPE, Messages.ManageCloudDialog_TEXT_URL}, new int[]{35, 55});
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Collections.sort(ManageCloudDialog.this.cloudUrls, new Comparator<AbstractCloudFoundryUrl>(){

                    @Override
                    public int compare(AbstractCloudFoundryUrl o1, AbstractCloudFoundryUrl o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                return ManageCloudDialog.this.cloudUrls.toArray();
            }
        });
        try {
            this.cloudUrls = CloudServerUIUtil.getAllUrls(this.serverTypeId, this.runnableContext, true);
            viewer.setInput((Object)this.cloudUrls.toArray());
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
        }
        viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof AbstractCloudFoundryUrl) {
                    AbstractCloudFoundryUrl cloudUrl = (AbstractCloudFoundryUrl)element;
                    if (columnIndex == 0) {
                        return cloudUrl.getName();
                    }
                    if (columnIndex == 1) {
                        return cloudUrl.getUrl();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(buttonComposite);
        Button addButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)addButton);
        addButton.setText(Messages.COMMONTXT_ADD);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCloudFoundryUrl cloudURL = ManageCloudDialog.this.promptForCloudFoundryUrl(ManageCloudDialog.this.serverTypeId, e.display.getActiveShell(), ManageCloudDialog.this.cloudUrls, null, null);
                if (cloudURL != null) {
                    ManageCloudDialog.this.addURL(cloudURL);
                    viewer.refresh(true);
                }
            }
        });
        final Button editButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)editButton);
        editButton.setText(Messages.COMMONTXT_EDIT);
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sSelection;
                Object element;
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection && (element = (sSelection = (IStructuredSelection)selection).getFirstElement()) instanceof AbstractCloudFoundryUrl) {
                    AbstractCloudFoundryUrl cloudUrl = (AbstractCloudFoundryUrl)element;
                    if (cloudUrl.getUserDefined()) {
                        ManageCloudDialog.this.cloudUrls.remove(cloudUrl);
                        AbstractCloudFoundryUrl newUrl = ManageCloudDialog.this.promptForCloudFoundryUrl(ManageCloudDialog.this.serverTypeId, e.display.getActiveShell(), ManageCloudDialog.this.cloudUrls, cloudUrl.getUrl(), cloudUrl.getName());
                        if (newUrl != null) {
                            if (cloudUrl.getUrl().equals(newUrl.getUrl()) || ManageCloudDialog.this.canUpdateUrl(cloudUrl, newUrl)) {
                                ManageCloudDialog.this.addURL(newUrl);
                            } else {
                                ManageCloudDialog.this.addURL(cloudUrl);
                            }
                        } else {
                            ManageCloudDialog.this.addURL(cloudUrl);
                        }
                    } else {
                        AbstractCloudFoundryUrl url = CloudServerUIUtil.getWildcardUrl(cloudUrl, ManageCloudDialog.this.cloudUrls, ManageCloudDialog.this.getShell());
                        if (url != null) {
                            ManageCloudDialog.this.addURL(url);
                        }
                    }
                    viewer.refresh(true);
                }
            }
        });
        final Button removeButton = new Button(buttonComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)removeButton);
        removeButton.setText(Messages.COMMONTXT_REMOVE);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object[] selectedItems;
                    IStructuredSelection sSelection = (IStructuredSelection)selection;
                    Object[] objectArray = selectedItems = sSelection.toArray();
                    int n = selectedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selectedItem = objectArray[n2];
                        if (selectedItem instanceof AbstractCloudFoundryUrl) {
                            AbstractCloudFoundryUrl cloudUrl = (AbstractCloudFoundryUrl)selectedItem;
                            ManageCloudDialog.this.removeCloudUrl(cloudUrl);
                        }
                        ++n2;
                    }
                }
                viewer.refresh(true);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object[] selectedItems;
                    boolean editEnabled = true;
                    boolean removeEnabled = true;
                    IStructuredSelection sSelection = (IStructuredSelection)selection;
                    Object[] objectArray = selectedItems = sSelection.toArray();
                    int n = selectedItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AbstractCloudFoundryUrl cloudUrl;
                        Object selectedItem = objectArray[n2];
                        if (selectedItem instanceof AbstractCloudFoundryUrl && !(cloudUrl = (AbstractCloudFoundryUrl)selectedItem).getUserDefined()) {
                            String url = cloudUrl.getUrl();
                            if (!url.contains("{")) {
                                editEnabled = false;
                            }
                            removeEnabled = false;
                        }
                        ++n2;
                    }
                    editButton.setEnabled(selectedItems.length == 1 && editEnabled);
                    removeButton.setEnabled(selectedItems.length > 0 && removeEnabled);
                }
            }
        });
        return composite;
    }

    protected void addURL(AbstractCloudFoundryUrl urlToAdd) {
        if (this.cloudUrls != null) {
            this.cloudUrls.add(urlToAdd);
            if (this.urlsToDelete != null) {
                this.urlsToDelete.remove(urlToAdd.getUrl());
            }
            this.lastAddedEditedURL = urlToAdd;
        }
    }

    protected void removeCloudUrl(AbstractCloudFoundryUrl cloudUrl) {
        if (cloudUrl != null && cloudUrl.getUserDefined() && this.canUpdateUrl(cloudUrl, null)) {
            this.cloudUrls.remove(cloudUrl);
            if (this.urlsToDelete != null) {
                this.urlsToDelete.add(cloudUrl.getUrl());
            }
        }
    }

    public CloudFoundryBrandingExtensionPoint.CloudServerURL getLastAddedOrEditedURL() {
        if (this.lastAddedEditedURL instanceof CloudFoundryBrandingExtensionPoint.CloudServerURL) {
            return (CloudFoundryBrandingExtensionPoint.CloudServerURL)this.lastAddedEditedURL;
        }
        return null;
    }

    public AbstractCloudFoundryUrl getLastAddedOrEditedCloudFoundryUrl() {
        return this.lastAddedEditedURL;
    }

    private boolean canUpdateUrl(AbstractCloudFoundryUrl url, AbstractCloudFoundryUrl newUrl) {
        IServer[] servers = ServerCore.getServers();
        HashSet<CloudFoundryServer> matchedServers = new HashSet<CloudFoundryServer>();
        IServer[] iServerArray = servers;
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            CloudFoundryServer cfServer = (CloudFoundryServer)server.loadAdapter(CloudFoundryServer.class, null);
            if (cfServer != null && cfServer.getUrl().equals(url.getUrl())) {
                matchedServers.add(cfServer);
            }
            ++n2;
        }
        if (matchedServers.isEmpty()) {
            return true;
        }
        if (newUrl == null) {
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ManageCloudDialog_TEXT_URL_USED_TITLE, (String)Messages.ManageCloudDialog_TEXT_URL_USED_BODY_1)) {
                for (CloudFoundryServer matchedServer : matchedServers) {
                    this.serversToDelete.add(matchedServer);
                }
                return true;
            }
        } else {
            EditUrlConfirmationDialog dialog = new EditUrlConfirmationDialog(this.getShell());
            int answer = dialog.open();
            if (answer == 0) {
                if (dialog.getAction() == EditUrlConfirmationDialog.Action.REMOVE_SERVER) {
                    for (CloudFoundryServer matchedServer : matchedServers) {
                        this.serversToDelete.add(matchedServer);
                    }
                    return true;
                }
                this.addURL(newUrl);
            }
        }
        return false;
    }

    protected void okPressed() {
        CloudServerUIUtil.storeUserDefinedUrls(this.serverTypeId, this.cloudUrls);
        for (CloudFoundryServer server : this.serversToDelete) {
            try {
                IServer serverOriginal = server.getServerOriginal();
                serverOriginal.delete();
            }
            catch (CoreException e) {
                CloudFoundryPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.core", "Unable to delete server", (Throwable)e));
            }
        }
        if (this.urlsToDelete != null) {
            for (String url : this.urlsToDelete) {
                CloudFoundryServer.setSelfSigned((boolean)false, (String)url);
            }
        }
        super.okPressed();
    }

    private static class EditUrlConfirmationDialog
    extends MessageDialog {
        private Action action;

        public EditUrlConfirmationDialog(Shell parentShell) {
            super(parentShell, Messages.ManageCloudDialog_TEXT_URL_USED_TITLE, null, Messages.ManageCloudDialog_TEXT_URL_MOD_USED, 3, new String[]{Messages.COMMONTXT_OK, Messages.ManageCloudDialog_TEXT_CANCEL}, 0);
        }

        protected Control createMessageArea(Composite composite) {
            Control control = super.createMessageArea(composite);
            new Label(composite, 0);
            final Button removeServerButton = new Button(composite, 16);
            removeServerButton.setText(Messages.ManageCloudDialog_TEXT_REMOVE_SERVER);
            removeServerButton.setSelection(true);
            this.action = Action.REMOVE_SERVER;
            removeServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (removeServerButton.getSelection()) {
                        EditUrlConfirmationDialog.this.action = Action.REMOVE_SERVER;
                    }
                }
            });
            new Label(composite, 0);
            final Button addUrlButton = new Button(composite, 16);
            addUrlButton.setText(Messages.ManageCloudDialog_TEXT_KEEP_OLD_URL);
            removeServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (addUrlButton.getSelection()) {
                        EditUrlConfirmationDialog.this.action = Action.ADD_URL;
                    }
                }
            });
            return control;
        }

        public Action getAction() {
            return this.action;
        }

        public static enum Action {
            REMOVE_SERVER,
            ADD_URL;

        }
    }
}

