/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;

public class PartnerLinkValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_PARTNER_LINKS);
    INode fPartnerLinkType;
    INode fPartnerLink;
    String ncName;
    String fMyRole;
    String fPartnerRole;
    protected String fInitializePartnerRole;
    List<INode> fRoles = Collections.emptyList();

    @Override
    protected void start() {
        super.start();
        this.fPartnerLink = this.mNode;
        this.fPartnerLinkType = this.mModelQuery.lookup(this.mNode, 10, this.mNode.getAttributeAsQName(AT_PARTNER_LINK_TYPE));
        if (this.fPartnerLinkType != null) {
            this.fRoles = this.fPartnerLinkType.children();
        }
        this.ncName = this.mNode.getAttribute(AT_NAME);
    }

    @ARule(sa=0, desc="Check the NCName of the partner link.", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        this.checkNCName(this.mNode, this.ncName, AT_NAME);
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Checks partner link type", date="01/15/2007", sa=32, errors="BPELC__UNSET_ATTRIBUTE,BPELC__UNRESOLVED_ATTRIBUTE")
    public void rule_CheckPartnerLinkType_2() {
        if (!this.checkAttributeNode(this.mNode, this.fPartnerLinkType, AT_PARTNER_LINK_TYPE, 0)) {
            this.fPartnerLinkType = null;
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="myRole or partnerRole (or both) must be set", date="09/19/2006", sa=16, errors="BPELC_PARTNER_LINK__NO_ROLES_SET")
    public void rule_CheckForUndefinedPartnerLinkRoles_4() {
        this.fMyRole = this.fPartnerLink.getAttribute(AT_MY_ROLE);
        this.fPartnerRole = this.fPartnerLink.getAttribute(AT_PARTNER_ROLE);
        if (this.fMyRole == null && this.fPartnerRole == null) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PARTNER_LINK__NO_ROLES_SET", this.fPartnerLink.nodeName(), this.ncName, AT_MY_ROLE, AT_PARTNER_ROLE);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Check if initializePartnerRole is set on the partnerLink if partnerRole is set (or not).", date="09/19/2006", sa=17, errors="BPELC_PARTNER_LINK__INIT_PARTNER_ROLE,BPELC__UNRESOLVED_ATTRIBUTE,BPELC__INVALID_ATTRIBUTE_VALUE")
    public void rule_CheckInitializePartnerRole_8() {
        this.fInitializePartnerRole = this.getAttribute(this.fPartnerLink, AT_INITIALIZE_PARTNER_ROLE, 1, Filters.BOOLEAN_FILTER, false);
        if (this.fPartnerRole != null) {
            if (PartnerLinkValidator.isEmpty(this.fPartnerRole)) {
                this.fInitializePartnerRole = "no";
            }
            return;
        }
        if (this.fInitializePartnerRole != null) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PARTNER_LINK__INIT_PARTNER_ROLE", this.toString(this.mNode.nodeName()), AT_INITIALIZE_PARTNER_ROLE, AT_PARTNER_ROLE);
        }
    }

    @ARule(desc="Check if partner link role exists", author="michal.chmielewski@oracle.com", date="03/15/2007", errors="BPELC_PARTNER_LINK_TYPE__NO_SUCH_ROLE")
    public void rule_CheckPartnerLinkRoles_10() {
        if (this.fPartnerLinkType == null) {
            return;
        }
        if (this.fMyRole != null) {
            this.checkRole(this.fMyRole);
        }
        if (this.fPartnerRole != null) {
            this.checkRole(this.fPartnerRole);
        }
    }

    public void rule_CheckRolesOnPartnerLinkType_17() {
        IProblem problem;
        if (this.fPartnerLinkType == null) {
            return;
        }
        if (this.fRoles.size() == 0) {
            problem = this.createWarning(this.mNode);
            problem.fill("BPELC_PARTNER_LINK_TYPE__NO_ROLES_DEFINED", AT_PARTNER_LINK_TYPE, AT_PARTNER_LINK);
        }
        if (this.fRoles.size() > 2) {
            problem = this.createWarning(this.mNode);
            problem.fill("BPELC_PARTNER_LINK_TYPE__TWO_MANY_ROLES_DEFINED", AT_PARTNER_LINK_TYPE, AT_PARTNER_LINK);
        }
    }

    @ARule(author="michal.chmielewski@oracle.com", desc="Check if port type is set on the partnerLink", date="09/19/2006", sa=17, errors="BPELC_PLT__NO_PORT_TYPE")
    public void rule_CheckPortTypes_18() {
        if (this.fPartnerLinkType == null) {
            return;
        }
        for (INode role : this.fRoles) {
            INode portType = this.mModelQuery.lookup(role, 12, role.getAttribute(AT_PORT_TYPE));
            if (this.isUndefined(portType)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_PLT__NO_PORT_TYPE", role.getAttribute(AT_NAME), role.getAttribute(AT_PORT_TYPE), AT_PARTNER_LINK_TYPE, AT_PORT_TYPE);
                continue;
            }
            this.runRules("direct", portType);
        }
    }

    @ARule(sa=1, desc="Check solicit-response or notification port types", date="02/16/2007", author="michal.chmielewski@oracle.com", tag="direct", errors="BPELC_PL__NOTIFICATION,BPELC_PL__SOLICIT_RESPONSE")
    public void checkSolicitResponseAndNotification(INode portType) {
        for (INode op : portType.getNodeList(WSDL_ND_OPERATION)) {
            IProblem problem;
            List<INode> children = op.children();
            if (children.size() == 1) {
                if (!WSDL_ND_OUTPUT.equals(children.get(0).nodeName())) continue;
                problem = this.createError();
                problem.fill("BPELC_PL__NOTIFICATION", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.mNode.getAttributeAsQName(AT_PARTNER_LINK_TYPE), portType.getAttribute(AT_NAME), op.getAttribute(AT_NAME));
                continue;
            }
            if (children.size() <= 1 || !WSDL_ND_OUTPUT.equals(children.get(0).nodeName()) || !WSDL_ND_INPUT.equals(children.get(1).nodeName())) continue;
            problem = this.createError();
            problem.fill("BPELC_PL__SOLICIT_RESPONSE", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.mNode.getAttributeAsQName(AT_PARTNER_LINK_TYPE), portType.getAttribute(AT_NAME), op.getAttribute(AT_NAME));
        }
    }

    @ARule(sa=2, desc="Check for overloaded operation names in port types", date="02/16/2007", author="michal.chmielewski@oracle.com", tag="direct", errors="BPELC_PL__OVERLOADED")
    public void checkOverloadedOperationNames(INode portType) {
        HashSet<String> names = new HashSet<String>();
        for (INode op : portType.getNodeList(WSDL_ND_OPERATION)) {
            String name = op.getAttribute(AT_NAME);
            if (name == null) continue;
            if (names.contains(name)) {
                IProblem problem = this.createError();
                problem.fill("BPELC_PL__OVERLOADED", this.toString(this.mNode.nodeName()), this.mNode.getAttribute(AT_NAME), this.mNode.getAttributeAsQName(AT_PARTNER_LINK_TYPE), portType.getAttribute(AT_NAME), name);
            }
            names.add(name);
        }
    }

    void checkRole(final String roleName) {
        INode roleNode = mSelector.selectNode(this.fPartnerLinkType, "*", new IFilter<INode>(){

            @Override
            public boolean select(INode node) {
                return roleName.equals(node.getAttribute(AT_NAME));
            }
        });
        this.setValue("role." + roleName, roleNode);
        if (roleNode == null) {
            IProblem problem = this.createError();
            problem.fill("BPELC_PARTNER_LINK_TYPE__NO_SUCH_ROLE", this.fPartnerLinkType.nodeName(), roleName);
            return;
        }
        INode portTypeFromRole = this.mModelQuery.lookup(roleNode, 12, roleNode.getAttribute(AT_PORT_TYPE));
        this.setValue("role.portType." + roleName, portTypeFromRole);
    }
}

