/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.extensions;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.UnknownExtensionSerializer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.util.DOMUtil;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.adapters.INamespaceMap;
import org.eclipse.bpel.model.extensions.BPELExtensionSerializer;
import org.eclipse.bpel.model.resource.BPELWriter;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.UnknownExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class BPELUnknownExtensionSerializer
extends UnknownExtensionSerializer
implements BPELExtensionSerializer {
    @Override
    public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, Node parentNode, Process process, ExtensionRegistry extReg, BPELWriter bpelWriter) throws WSDLException {
        UnknownExtensibilityElement unknownExt;
        INamespaceMap<String, String> nsMap = BPELUtils.getNamespaceMap((EObject)process);
        Element unknownElement = null;
        if (elementType.getLocalPart().equals("extensibilityAttributes")) {
            unknownExt = (UnknownExtensibilityElement)extension;
            DOMUtil.copyInto((Node)unknownExt.getElement(), (Node)parentNode);
        } else {
            unknownExt = (UnknownExtensibilityElement)extension;
            unknownElement = unknownExt.getElement();
        }
        if (unknownElement != null) {
            StringWriter writer = new StringWriter();
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            DOM2Writer.serializeAsXML((Node)unknownElement, (Writer)writer);
            Document document = this.load(writer);
            Element element = document.getDocumentElement();
            this.removeRepeatedNamespaceDecl(element, nsMap);
            DOMUtil.copyInto((Node)element, (Node)parentNode);
        }
    }

    protected void removeRepeatedNamespaceDecl(Element element, Map nsMap) {
        ArrayList<Attr> removeList = new ArrayList<Attr>();
        NamedNodeMap nodeMap = element.getAttributes();
        int i = 0;
        while (i < nodeMap.getLength()) {
            Attr attr = (Attr)nodeMap.item(i);
            String nsURI = attr.getNamespaceURI();
            String name = attr.getLocalName();
            String value = attr.getValue();
            if ("http://www.w3.org/2000/xmlns/".equals(nsURI) && nsMap.containsKey(name) && value.equals(nsMap.get(name))) {
                removeList.add(attr);
            }
            ++i;
        }
        i = 0;
        while (i < removeList.size()) {
            element.removeAttributeNode((Attr)removeList.get(i));
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            if (children.item(i2) instanceof Element) {
                this.removeRepeatedNamespaceDecl((Element)children.item(i2), nsMap);
            }
            ++i2;
        }
    }

    protected Document load(StringWriter writer) {
        DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            StringBufferInputStream stream = new StringBufferInputStream(writer.getBuffer().toString());
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStreamReader reader = new InputStreamReader((InputStream)stream, "UTF8");
            InputSource source = new InputSource(reader);
            source.setEncoding("UTF8");
            Document document = builder.parse(source);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

