/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

class HessenbergTransformer {
    private final double[][] householderVectors;
    private final double[] ort;
    private RealMatrix cachedP;
    private RealMatrix cachedPt;
    private RealMatrix cachedH;

    public HessenbergTransformer(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.ort = new double[m];
        this.cachedP = null;
        this.cachedPt = null;
        this.cachedH = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int j;
            int n = this.householderVectors.length;
            int high = n - 1;
            double[][] pa = new double[n][n];
            int i = 0;
            while (i < n) {
                j = 0;
                while (j < n) {
                    pa[i][j] = i == j ? 1 : 0;
                    ++j;
                }
                ++i;
            }
            int m = high - 1;
            while (m >= 1) {
                if (this.householderVectors[m][m - 1] != 0.0) {
                    int i2 = m + 1;
                    while (i2 <= high) {
                        this.ort[i2] = this.householderVectors[i2][m - 1];
                        ++i2;
                    }
                    j = m;
                    while (j <= high) {
                        double g = 0.0;
                        int i3 = m;
                        while (i3 <= high) {
                            g += this.ort[i3] * pa[i3][j];
                            ++i3;
                        }
                        g = g / this.ort[m] / this.householderVectors[m][m - 1];
                        i3 = m;
                        while (i3 <= high) {
                            double[] dArray = pa[i3];
                            int n2 = j;
                            dArray[n2] = dArray[n2] + g * this.ort[i3];
                            ++i3;
                        }
                        ++j;
                    }
                }
                --m;
            }
            this.cachedP = MatrixUtils.createRealMatrix(pa);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int m = this.householderVectors.length;
            double[][] h = new double[m][m];
            int i = 0;
            while (i < m) {
                if (i > 0) {
                    h[i][i - 1] = this.householderVectors[i][i - 1];
                }
                int j = i;
                while (j < m) {
                    h[i][j] = this.householderVectors[i][j];
                    ++j;
                }
                ++i;
            }
            this.cachedH = MatrixUtils.createRealMatrix(h);
        }
        return this.cachedH;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    private void transform() {
        int n = this.householderVectors.length;
        int high = n - 1;
        int m = 1;
        while (m <= high - 1) {
            double scale = 0.0;
            int i = m;
            while (i <= high) {
                scale += FastMath.abs(this.householderVectors[i][m - 1]);
                ++i;
            }
            if (!Precision.equals(scale, 0.0)) {
                double f;
                double h = 0.0;
                int i2 = high;
                while (i2 >= m) {
                    this.ort[i2] = this.householderVectors[i2][m - 1] / scale;
                    h += this.ort[i2] * this.ort[i2];
                    --i2;
                }
                double g = this.ort[m] > 0.0 ? -FastMath.sqrt(h) : FastMath.sqrt(h);
                h -= this.ort[m] * g;
                this.ort[m] = this.ort[m] - g;
                int j = m;
                while (j < n) {
                    f = 0.0;
                    int i3 = high;
                    while (i3 >= m) {
                        f += this.ort[i3] * this.householderVectors[i3][j];
                        --i3;
                    }
                    f /= h;
                    i3 = m;
                    while (i3 <= high) {
                        double[] dArray = this.householderVectors[i3];
                        int n2 = j;
                        dArray[n2] = dArray[n2] - f * this.ort[i3];
                        ++i3;
                    }
                    ++j;
                }
                int i4 = 0;
                while (i4 <= high) {
                    f = 0.0;
                    int j2 = high;
                    while (j2 >= m) {
                        f += this.ort[j2] * this.householderVectors[i4][j2];
                        --j2;
                    }
                    f /= h;
                    j2 = m;
                    while (j2 <= high) {
                        double[] dArray = this.householderVectors[i4];
                        int n3 = j2;
                        dArray[n3] = dArray[n3] - f * this.ort[j2];
                        ++j2;
                    }
                    ++i4;
                }
                this.ort[m] = scale * this.ort[m];
                this.householderVectors[m][m - 1] = scale * g;
            }
            ++m;
        }
    }
}

