/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.linear.Array2DRowFieldMatrix;
import org.apache.commons.math3.linear.ArrayFieldVector;
import org.apache.commons.math3.linear.FieldDecompositionSolver;
import org.apache.commons.math3.linear.FieldMatrix;
import org.apache.commons.math3.linear.FieldVector;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.MathArrays;

public class FieldLUDecomposition<T extends FieldElement<T>> {
    private final Field<T> field;
    private T[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private FieldMatrix<T> cachedL;
    private FieldMatrix<T> cachedU;
    private FieldMatrix<T> cachedP;

    public FieldLUDecomposition(FieldMatrix<T> matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m = matrix.getColumnDimension();
        this.field = matrix.getField();
        this.lu = matrix.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        int row = 0;
        while (row < m) {
            this.pivot[row] = row;
            ++row;
        }
        this.even = true;
        this.singular = false;
        int col = 0;
        while (col < m) {
            FieldElement<FieldElement> sum = (FieldElement)this.field.getZero();
            int row2 = 0;
            while (row2 < col) {
                T[] luRow = this.lu[row2];
                sum = luRow[col];
                int i = 0;
                while (i < row2) {
                    sum = sum.subtract((FieldElement)luRow[i].multiply(this.lu[i][col]));
                    ++i;
                }
                luRow[col] = sum;
                ++row2;
            }
            int nonZero = col;
            int row3 = col;
            while (row3 < m) {
                T[] luRow = this.lu[row3];
                sum = luRow[col];
                int i = 0;
                while (i < col) {
                    sum = sum.subtract((FieldElement)luRow[i].multiply(this.lu[i][col]));
                    ++i;
                }
                luRow[col] = sum;
                if (this.lu[nonZero][col].equals(this.field.getZero())) {
                    ++nonZero;
                }
                ++row3;
            }
            if (nonZero >= m) {
                this.singular = true;
                return;
            }
            if (nonZero != col) {
                FieldElement tmp = (FieldElement)this.field.getZero();
                int i = 0;
                while (i < m) {
                    tmp = this.lu[nonZero][i];
                    this.lu[nonZero][i] = this.lu[col][i];
                    this.lu[col][i] = tmp;
                    ++i;
                }
                int temp = this.pivot[nonZero];
                this.pivot[nonZero] = this.pivot[col];
                this.pivot[col] = temp;
                this.even = !this.even;
            }
            T luDiag = this.lu[col][col];
            int row4 = col + 1;
            while (row4 < m) {
                T[] luRow = this.lu[row4];
                luRow[col] = (FieldElement)luRow[col].divide(luDiag);
                ++row4;
            }
            ++col;
        }
    }

    public FieldMatrix<T> getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i = 0;
            while (i < m) {
                T[] luI = this.lu[i];
                int j = 0;
                while (j < i) {
                    this.cachedL.setEntry(i, j, luI[j]);
                    ++j;
                }
                this.cachedL.setEntry(i, i, (FieldElement)this.field.getOne());
                ++i;
            }
        }
        return this.cachedL;
    }

    public FieldMatrix<T> getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i = 0;
            while (i < m) {
                T[] luI = this.lu[i];
                int j = i;
                while (j < m) {
                    this.cachedU.setEntry(i, j, luI[j]);
                    ++j;
                }
                ++i;
            }
        }
        return this.cachedU;
    }

    public FieldMatrix<T> getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = new Array2DRowFieldMatrix<T>(this.field, m, m);
            int i = 0;
            while (i < m) {
                this.cachedP.setEntry(i, this.pivot[i], (FieldElement)this.field.getOne());
                ++i;
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public T getDeterminant() {
        if (this.singular) {
            return (T)((FieldElement)this.field.getZero());
        }
        int m = this.pivot.length;
        FieldElement determinant = this.even ? (FieldElement)this.field.getOne() : ((FieldElement)this.field.getZero()).subtract((FieldElement)this.field.getOne());
        int i = 0;
        while (i < m) {
            determinant = (FieldElement)determinant.multiply(this.lu[i][i]);
            ++i;
        }
        return (T)determinant;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new Solver(this.field, (FieldElement[][])this.lu, this.pivot, this.singular);
    }

    private static class Solver<T extends FieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private final Field<T> field;
        private final T[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(Field<T> field, T[][] lu, int[] pivot, boolean singular) {
            this.field = field;
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        @Override
        public boolean isNonSingular() {
            return !this.singular;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public FieldVector<T> solve(FieldVector<T> b) {
            try {
                return this.solve((ArrayFieldVector)b);
            }
            catch (ClassCastException cce) {
                m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw new DimensionMismatchException(b.getDimension(), m);
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                bp = (FieldElement[])MathArrays.buildArray(this.field, m);
                row = 0;
                ** while (row < m)
            }
lbl-1000:
            // 1 sources

            {
                bp[row] = b.getEntry(this.pivot[row]);
                ++row;
                continue;
            }
lbl15:
            // 1 sources

            col = 0;
            while (col < m) {
                bpCol = bp[col];
                i = col + 1;
                while (i < m) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                bpCol = bp[col];
                i = 0;
                while (i < col) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                --col;
            }
            return new ArrayFieldVector(this.field, bp, false);
        }

        @Override
        public ArrayFieldVector<T> solve(ArrayFieldVector<T> b) {
            int i;
            FieldElement bpCol;
            int m = this.pivot.length;
            int length = b.getDimension();
            if (length != m) {
                throw new DimensionMismatchException(length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            FieldElement[] bp = (FieldElement[])MathArrays.buildArray(this.field, m);
            int row = 0;
            while (row < m) {
                bp[row] = b.getEntry(this.pivot[row]);
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                i = col + 1;
                while (i < m) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bp[col] = (FieldElement)bp[col].divide(this.lu[col][col]);
                bpCol = bp[col];
                i = 0;
                while (i < col) {
                    bp[i] = bp[i].subtract((FieldElement)bpCol.multiply(this.lu[i][col]));
                    ++i;
                }
                --col;
            }
            return new ArrayFieldVector(bp, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) {
            FieldElement[] bpCol;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw new DimensionMismatchException(b.getRowDimension(), m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            FieldElement[][] bp = (FieldElement[][])MathArrays.buildArray(this.field, m, nColB);
            int row = 0;
            while (row < m) {
                FieldElement[] bpRow = bp[row];
                int pRow = this.pivot[row];
                int col = 0;
                while (col < nColB) {
                    bpRow[col] = b.getEntry(pRow, col);
                    ++col;
                }
                ++row;
            }
            int col = 0;
            while (col < m) {
                bpCol = bp[col];
                int i = col + 1;
                while (i < m) {
                    FieldElement[] bpI = bp[i];
                    T luICol = this.lu[i][col];
                    int j = 0;
                    while (j < nColB) {
                        bpI[j] = bpI[j].subtract((FieldElement)bpCol[j].multiply(luICol));
                        ++j;
                    }
                    ++i;
                }
                ++col;
            }
            col = m - 1;
            while (col >= 0) {
                bpCol = bp[col];
                T luDiag = this.lu[col][col];
                int j = 0;
                while (j < nColB) {
                    bpCol[j] = (FieldElement)bpCol[j].divide(luDiag);
                    ++j;
                }
                int i = 0;
                while (i < col) {
                    FieldElement[] bpI = bp[i];
                    T luICol = this.lu[i][col];
                    int j2 = 0;
                    while (j2 < nColB) {
                        bpI[j2] = bpI[j2].subtract((FieldElement)bpCol[j2].multiply(luICol));
                        ++j2;
                    }
                    ++i;
                }
                --col;
            }
            return new Array2DRowFieldMatrix(this.field, bp, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            int m = this.pivot.length;
            FieldElement one = (FieldElement)this.field.getOne();
            Array2DRowFieldMatrix<FieldElement> identity = new Array2DRowFieldMatrix<FieldElement>(this.field, m, m);
            int i = 0;
            while (i < m) {
                identity.setEntry(i, i, one);
                ++i;
            }
            return this.solve(identity);
        }
    }
}

