/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import com.google.javascript.rhino.jstype.PropertyMap;
import com.google.javascript.rhino.jstype.RecordType;
import com.google.javascript.rhino.jstype.StaticTypedScope;
import com.google.javascript.rhino.jstype.TemplateTypeMap;
import java.util.TreeSet;

public class PrototypeObjectType
extends ObjectType {
    private static final long serialVersionUID = 1L;
    private final String className;
    private final PropertyMap properties = new PropertyMap();
    private final boolean nativeType;
    private final boolean anonymousType;
    private ObjectType implicitPrototypeFallback;
    private FunctionType ownerFunction = null;
    private boolean prettyPrint = false;
    private static final int MAX_PRETTY_PRINTED_PROPERTIES = 10;

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype) {
        this(registry, className, implicitPrototype, false, null, false);
    }

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype, boolean anonymousType) {
        this(registry, className, implicitPrototype, false, null, anonymousType);
    }

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype, boolean nativeType, TemplateTypeMap templateTypeMap) {
        this(registry, className, implicitPrototype, nativeType, templateTypeMap, false);
    }

    PrototypeObjectType(JSTypeRegistry registry, String className, ObjectType implicitPrototype, boolean nativeType, TemplateTypeMap templateTypeMap, boolean anonymousType) {
        super(registry, templateTypeMap);
        this.properties.setParentSource(this);
        this.className = className;
        this.nativeType = nativeType;
        this.anonymousType = anonymousType;
        if (nativeType || implicitPrototype != null) {
            this.setImplicitPrototype(implicitPrototype);
        } else {
            this.setImplicitPrototype(registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE));
        }
    }

    @Override
    PropertyMap getPropertyMap() {
        return this.properties;
    }

    @Override
    boolean defineProperty(String name, JSType type, boolean inferred, Node propertyNode) {
        if (this.hasOwnDeclaredProperty(name)) {
            return false;
        }
        Property newProp = new Property(name, type, inferred, propertyNode);
        this.properties.putProperty(name, newProp);
        return true;
    }

    @Override
    public boolean removeProperty(String name) {
        return this.properties.removeProperty(name);
    }

    @Override
    public void setPropertyJSDocInfo(String propertyName, JSDocInfo info) {
        if (info != null) {
            Property property;
            if (this.properties.getOwnProperty(propertyName) == null) {
                this.defineInferredProperty(propertyName, this.getPropertyType(propertyName), null);
            }
            if ((property = this.properties.getOwnProperty(propertyName)) != null) {
                property.setJSDocInfo(info);
            }
        }
    }

    @Override
    public void setPropertyNode(String propertyName, Node defSite) {
        Property property = this.properties.getOwnProperty(propertyName);
        if (property != null) {
            property.setNode(defSite);
        }
    }

    @Override
    public boolean matchesNumberContext() {
        return this.isNumberObjectType() || this.isDateType() || this.isBooleanObjectType() || this.isStringObjectType() || this.hasOverridenNativeProperty("valueOf");
    }

    @Override
    public boolean matchesStringContext() {
        return this.isTheObjectType() || this.isStringObjectType() || this.isDateType() || this.isRegexpType() || this.isArrayType() || this.isNumberObjectType() || this.isBooleanObjectType() || this.hasOverridenNativeProperty("toString");
    }

    private boolean hasOverridenNativeProperty(String propertyName) {
        if (this.isNativeObjectType()) {
            return false;
        }
        JSType propertyType = this.getPropertyType(propertyName);
        ObjectType nativeType = this.isFunctionType() ? this.registry.getNativeObjectType(JSTypeNative.FUNCTION_PROTOTYPE) : this.registry.getNativeObjectType(JSTypeNative.OBJECT_PROTOTYPE);
        JSType nativePropertyType = nativeType.getPropertyType(propertyName);
        return propertyType != nativePropertyType;
    }

    @Override
    public JSType unboxesTo() {
        if (this.isStringObjectType()) {
            return this.getNativeType(JSTypeNative.STRING_TYPE);
        }
        if (this.isBooleanObjectType()) {
            return this.getNativeType(JSTypeNative.BOOLEAN_TYPE);
        }
        if (this.isNumberObjectType()) {
            return this.getNativeType(JSTypeNative.NUMBER_TYPE);
        }
        return super.unboxesTo();
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return this.isRegexpType();
    }

    @Override
    String toStringHelper(boolean forAnnotations) {
        if (this.hasReferenceName()) {
            return this.getReferenceName();
        }
        if (this.prettyPrint) {
            this.prettyPrint = false;
            TreeSet<String> propertyNames = new TreeSet<String>();
            for (ObjectType current = this; current != null && !((ObjectType)current).isNativeObjectType() && propertyNames.size() <= 10; current = ((ObjectType)current).getImplicitPrototype()) {
                propertyNames.addAll(current.getOwnPropertyNames());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            boolean useNewlines = !forAnnotations && propertyNames.size() > 2;
            int i = 0;
            for (String property : propertyNames) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (useNewlines) {
                    sb.append("\n  ");
                }
                sb.append(property);
                sb.append(": ");
                sb.append(this.getPropertyType(property).toStringHelper(forAnnotations));
                if (forAnnotations || ++i != 10) continue;
                sb.append(", ...");
                break;
            }
            if (useNewlines) {
                sb.append("\n");
            }
            sb.append("}");
            this.prettyPrint = true;
            return sb.toString();
        }
        return forAnnotations ? "?" : "{...}";
    }

    void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return this.implicitPrototypeFallback;
    }

    final void setImplicitPrototype(ObjectType implicitPrototype) {
        Preconditions.checkState((!this.hasCachedValues() ? 1 : 0) != 0);
        this.implicitPrototypeFallback = implicitPrototype;
    }

    @Override
    public String getReferenceName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.ownerFunction != null) {
            return this.ownerFunction.getReferenceName() + ".prototype";
        }
        return null;
    }

    @Override
    public boolean hasReferenceName() {
        return this.className != null || this.ownerFunction != null;
    }

    public boolean isAnonymous() {
        return this.anonymousType;
    }

    @Override
    public boolean isSubtype(JSType that) {
        return this.isSubtype(that, JSType.ImplCache.create());
    }

    @Override
    protected boolean isSubtype(JSType that, JSType.ImplCache implicitImplCache) {
        FunctionType thatCtor;
        if (JSType.isSubtypeHelper(this, that, implicitImplCache)) {
            return true;
        }
        if (that.isUnionType()) {
            return false;
        }
        if (that.isRecordType()) {
            return PrototypeObjectType.isSubtype(this, that.toMaybeRecordType(), implicitImplCache);
        }
        ObjectType thatObj = that.toObjectType();
        FunctionType functionType = thatCtor = thatObj == null ? null : thatObj.getConstructor();
        if (this.getConstructor() != null && this.getConstructor().isInterface()) {
            for (ObjectType thisInterface : this.getCtorExtendedInterfaces()) {
                if (!thisInterface.isSubtype(that, implicitImplCache)) continue;
                return true;
            }
        } else if (thatCtor != null && thatCtor.isInterface()) {
            Iterable<ObjectType> thisInterfaces = this.getCtorImplementedInterfaces();
            for (ObjectType thisInterface : thisInterfaces) {
                if (!thisInterface.isSubtype(that, implicitImplCache)) continue;
                return true;
            }
        }
        if (this.isUnknownType() || this.implicitPrototypeChainIsUnknown()) {
            return true;
        }
        return thatObj != null && this.isImplicitPrototype(thatObj);
    }

    static boolean isSubtype(ObjectType typeA, RecordType typeB, JSType.ImplCache implicitImplCache) {
        for (String property : typeB.getOwnPropertyNames()) {
            JSType propB;
            if (!typeA.hasProperty(property)) {
                return false;
            }
            JSType propA = typeA.getPropertyType(property);
            if (propA.isSubtype(propB = typeB.getPropertyType(property), implicitImplCache)) continue;
            return false;
        }
        return true;
    }

    private boolean implicitPrototypeChainIsUnknown() {
        for (ObjectType p = this.getImplicitPrototype(); p != null; p = p.getImplicitPrototype()) {
            if (!p.isUnknownType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasCachedValues() {
        return super.hasCachedValues();
    }

    @Override
    public boolean isNativeObjectType() {
        return this.nativeType;
    }

    @Override
    void setOwnerFunction(FunctionType type) {
        Preconditions.checkState((this.ownerFunction == null || type == null ? 1 : 0) != 0);
        this.ownerFunction = type;
    }

    @Override
    public FunctionType getOwnerFunction() {
        return this.ownerFunction;
    }

    @Override
    public Iterable<ObjectType> getCtorImplementedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getImplementedInterfaces() : ImmutableList.of();
    }

    @Override
    public Iterable<ObjectType> getCtorExtendedInterfaces() {
        return this.isFunctionPrototypeType() ? this.getOwnerFunction().getExtendedInterfaces() : ImmutableList.of();
    }

    @Override
    JSType resolveInternal(ErrorReporter t, StaticTypedScope<JSType> scope) {
        this.setResolvedTypeInternal(this);
        ObjectType implicitPrototype = this.getImplicitPrototype();
        if (implicitPrototype != null) {
            FunctionType superCtor;
            this.implicitPrototypeFallback = (ObjectType)implicitPrototype.resolve(t, scope);
            FunctionType ctor = this.getConstructor();
            if (ctor != null && (superCtor = ctor.getSuperClassConstructor()) != null) {
                superCtor.addSubTypeIfNotPresent(ctor);
            }
        }
        for (Property prop : this.properties.values()) {
            prop.setType(PrototypeObjectType.safeResolve(prop.getType(), t, scope));
        }
        return this;
    }

    @Override
    public void matchConstraint(JSType constraint) {
        if (this.hasReferenceName()) {
            return;
        }
        if (constraint.isRecordType()) {
            this.matchRecordTypeConstraint(constraint.toObjectType());
        } else if (constraint.isUnionType()) {
            for (JSType alt : constraint.toMaybeUnionType().getAlternates()) {
                if (!alt.isRecordType()) continue;
                this.matchRecordTypeConstraint(alt.toObjectType());
            }
        }
    }

    public void matchRecordTypeConstraint(ObjectType constraintObj) {
        for (String prop : constraintObj.getOwnPropertyNames()) {
            JSType propType = constraintObj.getPropertyType(prop);
            if (this.isPropertyTypeDeclared(prop)) continue;
            JSType typeToInfer = propType;
            if (!this.hasProperty(prop)) {
                typeToInfer = this.getNativeType(JSTypeNative.VOID_TYPE).getLeastSupertype(propType);
            }
            this.defineInferredProperty(prop, typeToInfer, null);
        }
    }
}

