/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.apogy.impl;

import javax.vecmath.Matrix4d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.examples.mobile_platform.MobilePlatform;
import org.eclipse.apogy.examples.mobile_platform.Position;
import org.eclipse.apogy.examples.mobile_platform.apogy.impl.MobilePlatformApogySystemApiAdapterImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PositionAdapter
extends AdapterImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PositionAdapter.class);
    private final MobilePlatformApogySystemApiAdapterImpl apiAdapter;

    public PositionAdapter(MobilePlatformApogySystemApiAdapterImpl apiAdapter) {
        this.apiAdapter = apiAdapter;
    }

    public void notifyChanged(Notification msg) {
        try {
            if (msg.getNotifier() instanceof MobilePlatform) {
                if (msg.getFeatureID(MobilePlatform.class) == 7) {
                    if (msg.getOldValue() instanceof Position) {
                        Position oldPosition = (Position)msg.getOldValue();
                        oldPosition.eAdapters().remove((Object)this);
                    }
                    if (msg.getNewValue() instanceof Position) {
                        Position newPosition = (Position)msg.getNewValue();
                        this.updatePose(newPosition);
                        newPosition.eAdapters().add((Object)this);
                    }
                }
            } else if (msg.getNotifier() instanceof Position) {
                Position newPosition = (Position)msg.getNotifier();
                this.updatePose(newPosition);
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private void updatePose(Position position) {
        Matrix4d m = GeometricUtils.packXYZ((double)position.getX(), (double)position.getY(), (double)0.0, (double)0.0, (double)0.0, (double)position.getTheta());
        Matrix4x4 matrix = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
        this.apiAdapter.setPoseTransform(matrix);
    }
}

