/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.camera.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Random;
import javax.imageio.ImageIO;
import org.eclipse.apogy.addons.sensors.SensorStatus;
import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.addons.sensors.fov.RectangularFrustrumFieldOfView;
import org.eclipse.apogy.addons.sensors.imaging.ApogyAddonsSensorsImagingFactory;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.examples.camera.impl.CameraSimulatedImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraSimulatedCustomImpl
extends CameraSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CameraSimulatedImpl.class);
    protected static final double MAXIMUM_HORIZONTAL_FOV_DEGREES = 45.0;
    protected static final double MAXIMUM_VERTICAL_FOV_DEGREES = 33.75;
    protected static final double MIN_ZOOM = 1.0;
    protected static final double MAX_ZOOM = 10.0;
    protected static final double FOV_DEF_MINIMUM_RANGE = 0.0;
    protected static final double FOV_DEF_MAXIMUM_RANGE = 10.0;
    protected static final String IMAGE_FNAME_PREFIX = "image_";
    protected static final String IMAGE_FNAME_SUFFIX = ".jpg";
    protected static final int IMAGE_FNAME_MAX_NO = 71;
    protected static final String IMAGE_DIR = "/images/";
    protected static final String IMAGE_DIR_URL = "platform:/plugin/" + ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(CameraSimulatedCustomImpl.class) + "/images/";
    protected int fileCounter = -1;
    protected Job imageStreamingJob = null;

    @Override
    public RectangularFrustrumFieldOfView getFieldOfView() {
        return this.getFov();
    }

    @Override
    public RectangularFrustrumFieldOfView getFov() {
        RectangularFrustrumFieldOfView tmp = super.getFov();
        if (tmp == null) {
            tmp = ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(0.0, 10.0, this.calculateHorizontalFOVAngle(), this.calculateVerticalFOVAngle());
            this.setFov(tmp);
        }
        return tmp;
    }

    @Override
    public void setFov(RectangularFrustrumFieldOfView newFov) {
        super.setFov(newFov);
        this.updateFov();
    }

    @Override
    public void setCurrentZoom(double newCurrentZoom) {
        if (newCurrentZoom >= this.getMinimumZoom() && newCurrentZoom <= this.getMaximumZoom()) {
            super.setCurrentZoom(newCurrentZoom);
            this.updateFov();
        }
    }

    @Override
    public boolean init() {
        if (!this.isInitialized()) {
            this.setStatus(SensorStatus.READY);
            Logger.info("The camera has been initialized.");
            this.setInitialized(true);
            return true;
        }
        Logger.warn("The camera has been already initialized.");
        return false;
    }

    @Override
    public boolean commandStreaming(boolean streamingEnabled) {
        if (!this.isStreamingEnabled() && streamingEnabled) {
            this.setStreamingEnabled(true);
            this.getImageStreamingJob().schedule();
            Logger.info("The streaming for the camera has now been activated.");
            return true;
        }
        if (this.isStreamingEnabled() && !streamingEnabled) {
            this.setStreamingEnabled(false);
            this.imageStreamingJob = null;
            Logger.info("The streaming for the camera has now been deactivated.");
            return true;
        }
        return false;
    }

    @Override
    public double getMinimumZoom() {
        return 1.0;
    }

    @Override
    public double getMaximumZoom() {
        return 10.0;
    }

    @Override
    public boolean commandZoom(double newZoom) {
        if (!this.isInitialized()) {
            Logger.error("Rejected: The camera is not initialized (with init()).");
            return false;
        }
        this.setCommandedZoom(newZoom);
        if (newZoom >= this.getMinimumZoom() && newZoom <= this.getMaximumZoom()) {
            this.setCurrentZoom(newZoom);
            Logger.info("Zoom changed to specified level; FOV updated accordingly.");
            return true;
        }
        Logger.error("Rejected; The provided zoom was outside of the allowed range of zoom levels [" + this.getMinimumZoom() + " , " + this.getMaximumZoom() + "].");
        return false;
    }

    @Override
    public ImageSnapshot takeSnapshot() {
        String logPrefix = String.valueOf(this.getClass().getSimpleName()) + ".takeSnapshot(): ";
        if (!this.isInitialized()) {
            String message = String.valueOf(logPrefix) + "Rejected; the camera is not initialized (with init()).";
            throw new RuntimeException(message);
        }
        EImage image = this.takeImage();
        if (image.getImageContent() == null) {
            String message = String.valueOf(this.getClass().getSimpleName()) + ".takeSnapshot(): There was a problem retrieving the image for the snapshot;" + " most likely, the image file could not be located.";
            throw new RuntimeException(message);
        }
        ImageSnapshot imageSnapshot = ApogyAddonsSensorsImagingFactory.eINSTANCE.createImageSnapshot();
        imageSnapshot.setTime(new Date());
        imageSnapshot.setFieldOfView(ApogyAddonsSensorsFOVFacade.INSTANCE.createRectangularFrustrumFieldOfView(this.getFieldOfView()));
        imageSnapshot.setImage((AbstractEImage)image);
        this.setLatestImageSnapshot(imageSnapshot);
        Logger.info("The camera successfully took and returned a snapshot, as well as updated the latest image snapshot.");
        return imageSnapshot;
    }

    private EImage takeImage() {
        BufferedImage bufferedImage;
        block16: {
            InputStream inputStream = null;
            bufferedImage = null;
            if (this.fileCounter < 0) {
                this.fileCounter = this.initializeFileCounter();
            }
            String imageFilename = IMAGE_FNAME_PREFIX + this.fileCounter + IMAGE_FNAME_SUFFIX;
            try {
                try {
                    URL url = new URL(String.valueOf(IMAGE_DIR_URL) + imageFilename);
                    inputStream = url.openConnection().getInputStream();
                    bufferedImage = ImageIO.read(inputStream);
                    ++this.fileCounter;
                    if (this.fileCounter > 71) {
                        this.fileCounter = 0;
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        EImage image = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        image.setImageContent(bufferedImage);
        return image;
    }

    protected void updateFov() {
        this.getFov().setHorizontalFieldOfViewAngle(this.calculateHorizontalFOVAngle());
        this.getFov().setVerticalFieldOfViewAngle(this.calculateVerticalFOVAngle());
    }

    protected double calculateHorizontalFOVAngle() {
        double angle = 45.0 / this.getCurrentZoom();
        return Math.toRadians(angle);
    }

    protected double calculateVerticalFOVAngle() {
        double angle = 33.75 / this.getCurrentZoom();
        return Math.toRadians(angle);
    }

    private int initializeFileCounter() {
        Random random = new Random(System.currentTimeMillis());
        int fileCounter = (int)Math.floor(random.nextDouble() * 71.0);
        if (fileCounter < 0) {
            fileCounter = 0;
        }
        if (fileCounter > 71) {
            fileCounter = 71;
        }
        return fileCounter;
    }

    private Job getImageStreamingJob() {
        if (this.imageStreamingJob == null) {
            this.imageStreamingJob = new Job("Image Streaming"){

                protected IStatus run(IProgressMonitor monitor) {
                    while (CameraSimulatedCustomImpl.this.isStreamingEnabled()) {
                        CameraSimulatedCustomImpl.this.takeSnapshot();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.imageStreamingJob;
    }
}

