/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.composites;

import java.io.File;
import java.net.URL;
import org.eclipse.apogy.common.ui.dialogs.PluginResourcesURLDialog;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLSelectionComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(URLSelectionComposite.class);
    private boolean workspaceURLEnabled = true;
    private boolean instalationURLEnabled = true;
    private boolean fileSystemURLEnabled = true;
    private String[] fileExtensions = null;
    private String urlString = null;
    private final Text txtUrltext;

    public URLSelectionComposite(Composite parent, int style) {
        this(parent, style, new String[0], true, true, true);
    }

    public URLSelectionComposite(Composite parent, int style, final String[] fileExtensions, boolean workspaceURLEnabled, boolean instalationURLEnabled, boolean fileSystemURLEnabled) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.workspaceURLEnabled = workspaceURLEnabled;
        this.instalationURLEnabled = instalationURLEnabled;
        this.fileSystemURLEnabled = fileSystemURLEnabled;
        this.setFileExtension(fileExtensions);
        Label lblNewLabel = new Label((Composite)this, 0);
        lblNewLabel.setAlignment(131072);
        lblNewLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewLabel.setText("URL:");
        this.txtUrltext = new Text((Composite)this, 2120);
        GridData gd_txtUrltext = new GridData(4, 4, true, false, 1, 3);
        gd_txtUrltext.heightHint = 50;
        gd_txtUrltext.minimumHeight = 50;
        this.txtUrltext.setLayoutData((Object)gd_txtUrltext);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd_composite = new GridData(16384, 128, false, true, 1, 3);
        gd_composite.widthHint = 110;
        gd_composite.minimumWidth = 110;
        composite.setLayoutData((Object)gd_composite);
        if (workspaceURLEnabled) {
            Button btnWorkspace = new Button(composite, 0);
            btnWorkspace.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            btnWorkspace.setSize(110, 33);
            btnWorkspace.setText("Workspace...");
            btnWorkspace.setToolTipText("Selects a URL refering to a ressource in the current project.");
            btnWorkspace.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String currentDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                    FileDialog fileChooser = new FileDialog(URLSelectionComposite.this.getShell(), 4096);
                    fileChooser.setText("Select a file:");
                    fileChooser.setFilterPath(currentDir);
                    String[] extensions = URLSelectionComposite.this.fileExtensions;
                    if (extensions == null || extensions.length == 0) {
                        extensions = new String[]{"*.*"};
                    }
                    fileChooser.setFilterExtensions(fileExtensions);
                    String filename = fileChooser.open();
                    if (filename != null) {
                        try {
                            filename = filename.replace(File.separatorChar, '/');
                            String workspaceDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                            int index = filename.lastIndexOf(workspaceDir);
                            if (index != -1) {
                                filename = filename.substring(index += workspaceDir.length());
                            }
                            String pathAsURL = filename.replace(File.separatorChar, '/');
                            String newURLString = "platform:/resource";
                            newURLString = pathAsURL.startsWith("/") ? String.valueOf(newURLString) + pathAsURL : String.valueOf(newURLString) + "/" + pathAsURL;
                            URLSelectionComposite.this.setUrlString(newURLString);
                            URLSelectionComposite.this.urlStringSelected(newURLString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (instalationURLEnabled) {
            Button btnInstallation = new Button(composite, 0);
            btnInstallation.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            btnInstallation.setSize(110, 33);
            btnInstallation.setText("Installation...");
            btnInstallation.setToolTipText("Selects a URL refering to a ressource located in one installed plugin.");
            btnInstallation.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    PluginResourcesURLDialog dialog = new PluginResourcesURLDialog(URLSelectionComposite.this.getShell(), fileExtensions);
                    if (dialog.open() == 0) {
                        try {
                            String pathAsURL = dialog.getSelectedPath().replace(File.separatorChar, '/');
                            String newURLString = "platform:/plugin/" + dialog.getSelectedPluginSymbolicName() + pathAsURL;
                            URLSelectionComposite.this.setUrlString(newURLString);
                            URLSelectionComposite.this.urlStringSelected(newURLString);
                        }
                        catch (Exception exception) {
                            Logger.error("Could not create URL for <" + dialog.getSelectedPath() + ">.");
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (fileSystemURLEnabled) {
            Button btnFileSystem = new Button(composite, 0);
            btnFileSystem.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
            btnFileSystem.setSize(110, 33);
            btnFileSystem.setText("File System...");
            btnFileSystem.setToolTipText("Selects a URL refering to a ressource located on the file system.");
            btnFileSystem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String currentDir = System.getProperty("user.dir");
                    FileDialog fileChooser = new FileDialog(URLSelectionComposite.this.getShell(), 4096);
                    fileChooser.setText("Select a file:");
                    fileChooser.setFilterPath(currentDir);
                    String[] extensions = URLSelectionComposite.this.fileExtensions;
                    if (extensions == null || extensions.length == 0) {
                        extensions = new String[]{"*.*"};
                    }
                    fileChooser.setFilterExtensions(fileExtensions);
                    String filename = fileChooser.open();
                    if (filename != null) {
                        try {
                            String newURLString = URLSelectionComposite.this.convertFilenameToURL(filename);
                            URLSelectionComposite.this.setUrlString(newURLString);
                            URLSelectionComposite.this.urlStringSelected(newURLString);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    public String getUrlString() {
        return this.txtUrltext.getText();
    }

    public void setUrlString(String newURLString) {
        this.urlString = newURLString;
        this.txtUrltext.setText(newURLString);
    }

    public void setFileExtension(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    protected void urlStringSelected(String newURLString) {
    }

    private String convertFilenameToURL(String filename) throws Exception {
        File tmpFile = new File(filename);
        URL url = tmpFile.toURI().toURL();
        return url.toString();
    }
}

