/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.composites;

import javax.vecmath.Color3f;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class Color3fComposite
extends Composite {
    private EObject owner = null;
    private EStructuralFeature feature = null;
    private Adapter adapter;
    private boolean enableEditing = true;
    private final ColorFieldEditor colorFieldEditor;

    public Color3fComposite(Composite parent, int style) {
        this(parent, style, "", true, null, null);
    }

    public Color3fComposite(Composite parent, int style, String label, boolean enableEditing, EObject owner, EStructuralFeature feature) {
        super(parent, style);
        this.enableEditing = enableEditing;
        this.owner = owner;
        this.feature = feature;
        this.colorFieldEditor = new ColorFieldEditor("Color", label, (Composite)this);
        this.colorFieldEditor.setEnabled(this.enableEditing, (Composite)this);
        this.colorFieldEditor.getColorSelector().addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Color3f color = Color3fComposite.this.convert(Color3fComposite.this.colorFieldEditor.getColorSelector().getColorValue());
                ApogyCommonTransactionFacade.INSTANCE.basicSet(Color3fComposite.this.getOwner(), Color3fComposite.this.getFeature(), (Object)color);
            }
        });
        if (this.getOwner() != null && this.getFeature() != null) {
            Object value = this.getOwner().eGet(this.getFeature(), true);
            if (value instanceof Color3f) {
                this.updateDisplayedColor((Color3f)value);
            } else {
                this.updateDisplayedColor(null);
            }
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (Color3fComposite.this.getOwner() != null) {
                    Color3fComposite.this.getOwner().eAdapters().remove((Object)Color3fComposite.this.getAdapter());
                }
            }
        });
    }

    public Color3f getSelectedColor() {
        if (this.colorFieldEditor != null) {
            return this.convert(this.colorFieldEditor.getColorSelector().getColorValue());
        }
        return null;
    }

    public EObject getOwner() {
        return this.owner;
    }

    public void setOwner(EObject newOwner) {
        if (this.owner != null) {
            this.owner.eAdapters().remove((Object)this.getAdapter());
        }
        this.owner = newOwner;
        if (newOwner != null) {
            if (this.getFeature() != null) {
                Object value = newOwner.eGet(this.getFeature(), true);
                if (value instanceof Color3f) {
                    this.updateDisplayedColor((Color3f)value);
                } else {
                    this.updateDisplayedColor(null);
                }
            }
            newOwner.eAdapters().add((Object)this.getAdapter());
        }
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public void setFeature(EStructuralFeature feature) {
        this.feature = feature;
        if (this.getOwner() != null && feature != null) {
            Object value = this.getOwner().eGet(this.getFeature(), true);
            if (value instanceof Color3f) {
                this.updateDisplayedColor((Color3f)value);
            } else {
                this.updateDisplayedColor(null);
            }
        } else {
            this.updateDisplayedColor(null);
        }
    }

    protected void newColorSelected(Color3f color) {
    }

    protected Color3f convert(RGB rgb) {
        Color3f color = new Color3f((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f);
        return color;
    }

    protected RGB convert(Color3f color) {
        if (color != null) {
            int red = Math.round(255.0f * color.getX());
            int green = Math.round(255.0f * color.getY());
            int blue = Math.round(255.0f * color.getZ());
            return new RGB(red, green, blue);
        }
        return new RGB(0, 0, 0);
    }

    private void updateDisplayedColor(final Color3f newColor) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Color3fComposite.this.colorFieldEditor != null) {
                    Color3fComposite.this.colorFieldEditor.getColorSelector().setColorValue(Color3fComposite.this.convert(newColor));
                }
            }
        });
        this.newColorSelected(newColor);
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == Color3fComposite.this.getFeature()) {
                        if (msg.getNewValue() instanceof Color3f) {
                            Color3f color = (Color3f)msg.getNewValue();
                            Color3fComposite.this.updateDisplayedColor(color);
                        } else {
                            Color3fComposite.this.updateDisplayedColor(null);
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

