/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.ui.composites;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.ui.provider.ApogyCommonUiEditPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class BundleResourcesSelectionComposite
extends Composite {
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Label lblPluginvalue;
    private final Label lblPathvalue;
    private String[] fileExtensions;
    private String selectedPluginSymbolicName;
    private String selectedPath;

    public BundleResourcesSelectionComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public BundleResourcesSelectionComposite(Composite parent, int style, String[] fileExtensions) {
        super(parent, style);
        this.fileExtensions = fileExtensions;
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 2, 1);
        gd_tree.widthHint = 300;
        gd_tree.minimumWidth = 300;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        Label lblPlugin = new Label((Composite)this, 0);
        lblPlugin.setText("Plugin:");
        this.lblPluginvalue = new Label((Composite)this, 2048);
        GridData gd_lblPluginvalue = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblPluginvalue.minimumWidth = 100;
        gd_lblPluginvalue.widthHint = 100;
        this.lblPluginvalue.setLayoutData((Object)gd_lblPluginvalue);
        Label lblPath = new Label((Composite)this, 0);
        lblPath.setText("Path:");
        this.lblPathvalue = new Label((Composite)this, 2048);
        GridData gd_lblPathvalue = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_lblPathvalue.minimumWidth = 100;
        gd_lblPathvalue.widthHint = 100;
        this.lblPathvalue.setLayoutData((Object)gd_lblPathvalue);
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractElement abstractElement = (AbstractElement)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (abstractElement != null) {
                    AbstractElement root = abstractElement.getRoot();
                    if (root instanceof PluginElement) {
                        BundleResourcesSelectionComposite.this.selectedPluginSymbolicName = root.name;
                        BundleResourcesSelectionComposite.this.lblPluginvalue.setText(BundleResourcesSelectionComposite.this.selectedPluginSymbolicName);
                    }
                    if (abstractElement instanceof FileElement) {
                        BundleResourcesSelectionComposite.this.selectedPath = ((FileElement)abstractElement).getPath();
                        BundleResourcesSelectionComposite.this.lblPathvalue.setText(BundleResourcesSelectionComposite.this.selectedPath);
                    }
                    BundleResourcesSelectionComposite.this.newSelection();
                }
            }
        });
        this.treeViewer.setInput(this.getElements(fileExtensions));
    }

    protected LabelProvider getLabelProvider() {
        return new ResourceLabelProvider();
    }

    protected ITreeContentProvider getContentProvider() {
        return new ResourceContentProvider();
    }

    public String[] getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(String[] fileExtensions) {
        this.fileExtensions = fileExtensions;
        this.treeViewer.setInput(this.getElements(fileExtensions));
    }

    public String getSelectedPluginSymbolicName() {
        return this.selectedPluginSymbolicName;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    protected void newSelection() {
    }

    protected List<PluginElement> getElements(String[] fileExtensions) {
        Bundle[] bundles;
        ArrayList<PluginElement> elements = new ArrayList<PluginElement>();
        Bundle[] bundleArray = bundles = ApogyCommonUiEditPlugin.getPlugin().getBundle().getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            PluginElement pluginElement = new PluginElement();
            pluginElement.name = bundle.getSymbolicName();
            String[] stringArray = fileExtensions;
            int n3 = fileExtensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileExtension = stringArray[n4];
                Enumeration urls = bundle.findEntries("/", fileExtension, true);
                if (urls != null) {
                    while (urls.hasMoreElements()) {
                        URL url = (URL)urls.nextElement();
                        String[] folders = url.getPath().split("/");
                        AbstractElement parent = pluginElement;
                        int i = 0;
                        while (i < folders.length) {
                            String folder = folders[i];
                            if (folder.length() > 0) {
                                if (i + 1 >= folders.length) {
                                    FileElement file = new FileElement();
                                    file.name = folder;
                                    parent.children.add(file);
                                    file.parent = parent;
                                } else {
                                    AbstractElement child = parent.getChildByName(folder);
                                    if (child == null) {
                                        child = new FolderElement();
                                        child.name = folder;
                                        parent.children.add(child);
                                        child.parent = parent;
                                    }
                                    parent = child;
                                }
                            }
                            ++i;
                        }
                    }
                }
                ++n4;
            }
            if (pluginElement.children.size() > 0) {
                elements.add(pluginElement);
            }
            ++n2;
        }
        return elements;
    }

    protected class AbstractElement {
        public String name;
        public AbstractElement parent;
        public List<AbstractElement> children = new ArrayList<AbstractElement>();

        protected AbstractElement() {
        }

        public AbstractElement getChildByName(String name) {
            AbstractElement result = null;
            Iterator<AbstractElement> it = this.children.iterator();
            while (it.hasNext() && result == null) {
                AbstractElement child = it.next();
                if (child.name.compareTo(name) != 0) continue;
                result = child;
            }
            return result;
        }

        public AbstractElement getRoot() {
            AbstractElement currentParent = this;
            while (currentParent.parent != null) {
                currentParent = currentParent.parent;
            }
            return currentParent;
        }
    }

    protected class FileElement
    extends AbstractElement {
        protected FileElement() {
        }

        public String getPath() {
            String path = String.valueOf(File.separator) + this.name;
            AbstractElement currentParent = this;
            while (!(currentParent.parent instanceof PluginElement)) {
                path = String.valueOf(File.separator) + currentParent.parent.name + path;
                currentParent = currentParent.parent;
            }
            return path;
        }
    }

    protected class FolderElement
    extends AbstractElement {
        protected FolderElement() {
        }
    }

    protected class PluginElement
    extends AbstractElement {
        protected PluginElement() {
        }
    }

    private class ResourceContentProvider
    implements ITreeContentProvider {
        private ResourceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            if (inputElement instanceof AbstractElement) {
                return ((AbstractElement)inputElement).children.toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                return ((Collection)parentElement).toArray();
            }
            if (parentElement instanceof AbstractElement) {
                return ((AbstractElement)parentElement).children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Collection) {
                return !((Collection)element).isEmpty();
            }
            if (element instanceof AbstractElement) {
                return !((AbstractElement)element).children.isEmpty();
            }
            return false;
        }
    }

    public class ResourceLabelProvider
    extends LabelProvider {
        ImageDescriptor pluginImageDesc = this.getImageDescriptor("/icons/plugin.gif");
        ImageDescriptor folderImageDesc = this.getImageDescriptor("/icons/folder.gif");
        ImageDescriptor fileImageDesc = this.getImageDescriptor("/icons/file.gif");
        private final Image pluginImage = this.pluginImageDesc.createImage();
        private final Image folderImage = this.folderImageDesc.createImage();
        private final Image fileImage = this.fileImageDesc.createImage();

        public Image getImage(Object element) {
            if (element instanceof PluginElement) {
                return this.pluginImage;
            }
            if (element instanceof FolderElement) {
                return this.folderImage;
            }
            if (element instanceof FileElement) {
                return this.fileImage;
            }
            return null;
        }

        public String getText(Object element) {
            String str = null;
            if (element instanceof AbstractElement) {
                str = ((AbstractElement)element).name;
            }
            return str;
        }

        public void dispose() {
            this.pluginImage.dispose();
            this.folderImage.dispose();
            this.fileImage.dispose();
            super.dispose();
        }

        private ImageDescriptor getImageDescriptor(String path) {
            Bundle bundle = ApogyCommonUiEditPlugin.getPlugin().getBundle();
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            return ImageDescriptor.createFromURL((URL)url);
        }
    }
}

