/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.processors.impl;

import java.util.Iterator;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.processors.Processor;
import org.eclipse.apogy.common.processors.impl.JobProcessorsChainImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobProcessorsChainCustomImpl<I, O>
extends JobProcessorsChainImpl<I, O> {
    private static final Logger Logger = LoggerFactory.getLogger(JobProcessorsChainImpl.class);

    @Override
    public O doProcess(final I input, IProgressMonitor monitor) throws Exception {
        Job chainJob = new Job(this.getClass().getSimpleName()){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)JobProcessorsChainCustomImpl.this.getProcessors().size());
                JobProcessorsChainCustomImpl.this.setIntermediateResult(null);
                JobProcessorsChainCustomImpl.this.setOutput(null);
                Iterator it = JobProcessorsChainCustomImpl.this.getProcessors().iterator();
                int i = 0;
                while (it.hasNext() && !subMonitor.isCanceled()) {
                    subMonitor.subTask("Calling sub-processor <" + i + ">");
                    JobProcessorsChainCustomImpl.this.setRunningProcessor((Processor)it.next());
                    final Processor<?, ?> processor = JobProcessorsChainCustomImpl.this.getRunningProcessor();
                    Job processorJob = new Job(processor.getClass().getSimpleName()){

                        protected IStatus run(IProgressMonitor _monitor) {
                            try {
                                processor.setProgressMonitor(_monitor);
                                processor.process(input);
                            }
                            catch (Exception e) {
                                Logger.error(e.getMessage(), (Throwable)e);
                                return new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(JobProcessorsChainCustomImpl.this.getClass()), 4, "Failed to run.", (Throwable)e);
                            }
                            return new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(JobProcessorsChainCustomImpl.this.getClass()), 0, "Done.", null);
                        }
                    };
                    processorJob.schedule();
                    try {
                        processorJob.join();
                    }
                    catch (InterruptedException e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                    if (processorJob.getResult() != null && !processorJob.getResult().isOK()) {
                        return new Status(4, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(JobProcessorsChainCustomImpl.this.getClass()), 4, "Error.", null);
                    }
                    subMonitor.worked(1);
                    ++i;
                    if (!it.hasNext()) continue;
                    JobProcessorsChainCustomImpl.this.setIntermediateResult(JobProcessorsChainCustomImpl.this.getRunningProcessor().getOutput());
                }
                JobProcessorsChainCustomImpl.this.setOutput(JobProcessorsChainCustomImpl.this.getRunningProcessor().getOutput());
                JobProcessorsChainCustomImpl.this.getProgressMonitor().done();
                if (subMonitor.isCanceled()) {
                    return new Status(8, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(JobProcessorsChainCustomImpl.this.getClass()), 8, "Cancelled.", null);
                }
                return new Status(0, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(JobProcessorsChainCustomImpl.this.getClass()), 0, "Done.", null);
            }
        };
        chainJob.schedule();
        return this.getOutput();
    }
}

