/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.converters;

import java.io.File;
import java.util.List;
import org.eclipse.apogy.common.converters.FileExporterUtilities;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.converters.BufferedImageToFileConverter;

public class AbstractEImageToFileConverter
extends BufferedImageToFileConverter {
    @Override
    public Class<?> getOutputType() {
        return File.class;
    }

    @Override
    public Class<?> getInputType() {
        return AbstractEImage.class;
    }

    @Override
    public boolean canConvert(Object input) {
        if (input instanceof AbstractEImage) {
            return ((AbstractEImage)input).asBufferedImage() != null;
        }
        return false;
    }

    @Override
    public Object convert(Object input) throws Exception {
        AbstractEImage eImage = (AbstractEImage)input;
        return super.convert(eImage.asBufferedImage());
    }

    @Override
    public void exportToFile(Object input, String filePath, List<String> extensions) throws Exception {
        AbstractEImage eImage = (AbstractEImage)input;
        for (String extension : extensions) {
            String fullPathString = String.valueOf(filePath) + "." + extension;
            if (extension.equalsIgnoreCase("jpg")) {
                EImagesUtilities.INSTANCE.saveImageAsJPEG(fullPathString, eImage);
                continue;
            }
            if (extension.equalsIgnoreCase("png")) {
                EImagesUtilities.INSTANCE.saveImageAsPNG(fullPathString, eImage);
                continue;
            }
            if (!extension.equalsIgnoreCase("metadata")) continue;
            FileExporterUtilities.saveMetaDataToFile((String)fullPathString, (String)AbstractEImageToFileConverter.getMetaData(eImage));
        }
    }

    @Override
    public List<String> getSupportedFileExtensions() {
        List<String> extensions = super.getSupportedFileExtensions();
        extensions.add("metadata");
        return extensions;
    }

    @Override
    public String getDescription(String fileExtension) {
        if (fileExtension.contains("metadata")) {
            return "The Image metadata.";
        }
        return super.getDescription(fileExtension);
    }

    public static String getMetaData(AbstractEImage eImage) {
        String metadata = "";
        if (eImage != null) {
            metadata = String.valueOf(metadata) + "Image Width = " + eImage.getWidth() + "\n";
            metadata = String.valueOf(metadata) + "Image Height = " + eImage.getHeight() + "\n";
        }
        return metadata;
    }
}

