/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.impl;

import edu.wlu.cs.levy.CG.KDTree;
import edu.wlu.cs.levy.CG.KeyDuplicateException;
import edu.wlu.cs.levy.CG.KeySizeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianCoordinatesSet;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.impl.InfiniteHeightVoxelResamplerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfiniteHeightVoxelResamplerCustomImpl
extends InfiniteHeightVoxelResamplerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(InfiniteHeightVoxelResamplerImpl.class);
    private double[] queryBuffer1;
    private double[] queryBuffer2;

    public CartesianCoordinatesSet doProcess(CartesianCoordinatesSet input, IProgressMonitor monitor) throws Exception {
        monitor.subTask("Creating KDTree...");
        KDTree kdTree = this.createKDTree(input);
        monitor.subTask("Filtering short range with limit from <0> to <" + this.getShortRangeLimit() + "> at resolution <" + this.getShortRangeResolution() + ">...");
        List<Point3d> shortRange = this.applyShortRange(kdTree, input);
        monitor.subTask("Filtering long range with limit from <" + this.getShortRangeLimit() + "> to <" + this.getLongRangeLimit() + "> at resolution <" + this.getLongRangeResolution() + ">...");
        List<Point3d> longRange = this.applyLongRange(kdTree, input);
        ArrayList<Point3d> resampled = new ArrayList<Point3d>();
        resampled.addAll(shortRange);
        resampled.addAll(longRange);
        CartesianCoordinatesSet output = ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianCoordinatesSet();
        for (Point3d point : resampled) {
            CartesianPositionCoordinates p = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point.x, point.y, point.z);
            output.getPoints().add((Object)p);
        }
        return output;
    }

    protected KDTree createKDTree(CartesianCoordinatesSet input) {
        KDTree kdTree = new KDTree(2);
        int numberOfPoints = input.getPoints().size();
        int pid = 0;
        while (pid < numberOfPoints) {
            CartesianPositionCoordinates point = (CartesianPositionCoordinates)input.getPoints().get(pid);
            double[] key = new double[]{point.getX(), point.getY()};
            try {
                kdTree.insert(key, (Object)pid);
            }
            catch (KeySizeException keySizeException) {
            }
            catch (KeyDuplicateException keyDuplicateException) {}
            ++pid;
        }
        return kdTree;
    }

    protected List<Point3d> findPointIdsWithinRadius(KDTree kdTree, CartesianCoordinatesSet input, double radius, Point3d point) {
        int[] indexes;
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        this.getQueryBuffer1()[0] = point.getX() - Math.abs(radius);
        this.getQueryBuffer1()[1] = point.getY() - Math.abs(radius);
        this.getQueryBuffer2()[0] = point.getX() + Math.abs(radius);
        this.getQueryBuffer2()[1] = point.getY() + Math.abs(radius);
        try {
            Object[] range = kdTree.range(this.getQueryBuffer1(), this.getQueryBuffer2());
            indexes = new int[range.length];
            int i = 0;
            while (i < range.length) {
                indexes[i] = (Integer)range[i];
                ++i;
            }
        }
        catch (KeySizeException e) {
            indexes = new int[]{};
            Logger.error(e.getMessage(), (Throwable)e);
        }
        int i = 0;
        while (i < indexes.length) {
            points.add(((CartesianPositionCoordinates)input.getPoints().get(indexes[i])).asPoint3d());
            ++i;
        }
        return points;
    }

    protected double[] getQueryBuffer1() {
        if (this.queryBuffer1 == null) {
            this.queryBuffer1 = new double[2];
        }
        return this.queryBuffer1;
    }

    protected double[] getQueryBuffer2() {
        if (this.queryBuffer2 == null) {
            this.queryBuffer2 = new double[2];
        }
        return this.queryBuffer2;
    }

    protected List<Point3d> applyShortRange(KDTree kdTree, CartesianCoordinatesSet input) {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        Set<Point3d> grid = this.generatePoints(0.0, this.getShortRangeLimit(), this.getShortRangeResolution());
        for (Point3d gridPoint : grid) {
            List<Point3d> neighbors = this.findPointIdsWithinRadius(kdTree, input, this.getShortRangeResolution(), gridPoint);
            if (neighbors.size() < this.getMinimumNumberOfPointPerVoxel()) continue;
            points.add(new Point3d(gridPoint.x, gridPoint.y, this.applyFilter(neighbors)));
        }
        return points;
    }

    protected List<Point3d> applyLongRange(KDTree kdTree, CartesianCoordinatesSet input) {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        Set<Point3d> grid = this.generatePoints(this.getShortRangeLimit(), this.getLongRangeLimit(), this.getLongRangeResolution());
        for (Point3d gridPoint : grid) {
            List<Point3d> neighbors = this.findPointIdsWithinRadius(kdTree, input, this.getLongRangeResolution(), gridPoint);
            if (neighbors.size() < this.getMinimumNumberOfPointPerVoxel()) continue;
            points.add(new Point3d(gridPoint.x, gridPoint.y, this.applyFilter(neighbors)));
        }
        return points;
    }

    protected double applyFilter(Collection<Point3d> pointsInVoxel) {
        double result = 0.0;
        switch (this.getFilterType().getValue()) {
            case 1: {
                result = this.applyAverageFilter(pointsInVoxel);
                break;
            }
            case 0: {
                result = this.applyMedianFilter(pointsInVoxel);
                break;
            }
        }
        return result;
    }

    protected double applyAverageFilter(Collection<Point3d> pointsInVoxel) {
        double result = 0.0;
        for (Point3d p : pointsInVoxel) {
            result += p.z;
        }
        return result /= (double)pointsInVoxel.size();
    }

    protected double applyMedianFilter(Collection<Point3d> pointsInVoxel) {
        double result = 0.0;
        double[] values = new double[pointsInVoxel.size()];
        int i = 0;
        for (Point3d p : pointsInVoxel) {
            values[i] = p.z;
            ++i;
        }
        Arrays.sort(values);
        if (values.length % 2 == 0) {
            int index1 = 0;
            int index2 = 0;
            if (values.length == 2) {
                index1 = 0;
                index2 = 1;
            } else {
                index1 = (int)((float)values.length * 0.5f) - 1;
                index2 = index1 + 1;
                result = (values[index1] + values[index2]) * 0.5;
            }
            result = (values[index1] + values[index2]) * 0.5;
        } else {
            int middelIndex = (int)((float)values.length * 0.5f);
            result = values[middelIndex];
        }
        return result;
    }

    protected Set<Point3d> generatePoints(double minRadius, double maxRadius, double increment) {
        ArrayList<Point3d> firstQuadrant = new ArrayList<Point3d>();
        Point3d center = new Point3d();
        double x = 0.0;
        double y = 0.0;
        while (x <= maxRadius) {
            y = 0.0;
            while (y <= maxRadius) {
                Point3d point = new Point3d(x, y, 0.0);
                double radius = point.distance(center);
                if (minRadius <= radius && radius <= maxRadius) {
                    firstQuadrant.add(point);
                }
                y += increment;
            }
            x += increment;
        }
        ArrayList<Point3d> secondQuadrant = new ArrayList<Point3d>();
        for (Point3d p : firstQuadrant) {
            Point3d point = new Point3d(-p.x, p.y, 0.0);
            secondQuadrant.add(point);
        }
        ArrayList<Point3d> thirdQuadrant = new ArrayList<Point3d>();
        for (Point3d p : firstQuadrant) {
            Point3d point = new Point3d(-p.x, -p.y, 0.0);
            thirdQuadrant.add(point);
        }
        ArrayList<Point3d> fourthQuadrant = new ArrayList<Point3d>();
        for (Point3d p : firstQuadrant) {
            Point3d point = new Point3d(p.x, -p.y, 0.0);
            fourthQuadrant.add(point);
        }
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        points.addAll(firstQuadrant);
        points.addAll(secondQuadrant);
        points.addAll(thirdQuadrant);
        points.addAll(fourthQuadrant);
        TreeSet<Point3d> set = new TreeSet<Point3d>(new Point3dComparator());
        set.addAll(points);
        return set;
    }

    protected class Point3dComparator
    implements Comparator<Point3d> {
        protected Point3dComparator() {
        }

        @Override
        public int compare(Point3d o1, Point3d o2) {
            if (o1.distance(o2) == 0.0) {
                return 0;
            }
            if (o1.x != o2.x) {
                if (o1.x > o2.x) {
                    return 1;
                }
                return -1;
            }
            if (o1.y != o2.y) {
                if (o1.y > o2.y) {
                    return 1;
                }
                return -1;
            }
            if (o1.z > o2.z) {
                return 1;
            }
            return -1;
        }
    }
}

