/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.AbstractPickLocationToolNode;
import org.eclipse.apogy.addons.ApogyAddonsFactory;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.impl.AbstractPickLocationToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.ui.Activator;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class AbstractPickLocationToolCustomImpl
extends AbstractPickLocationToolImpl {
    @Override
    public void initialise() {
        super.initialise();
        AbstractPickLocationToolNode toolNode = ApogyAddonsFactory.eINSTANCE.createAbstractPickLocationToolNode();
        toolNode.setDescription("Node associated with the Abstract Pick Location Tool named <" + this.getName() + ">");
        toolNode.setNodeId("ABSTRACT_PICK_LOCATION_TOOL_" + this.getName().replaceAll(" ", "_"));
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_PICK_LOCATION_TOOL__ABSTRACT_PICK_LOCATION_TOOL_NODE, (Object)toolNode);
        this.attachPickLocationToolNode();
    }

    @Override
    public void setVisible(boolean newVisible) {
        super.setVisible(newVisible);
        this.setPickLocationToolNodeVisibility(newVisible);
    }

    @Override
    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        this.initializeNodeAndPosition();
        this.setPickLocationToolNodeVisibility(this.isVisible());
    }

    @Override
    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.initializeNodeAndPosition();
    }

    @Override
    public void selectionChanged(final NodeSelection nodeSelection) {
        if (!this.isDisposed() && nodeSelection != null) {
            TransactionalEditingDomain transactionalEditingDomain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this);
            RecordingCommand cmd = new RecordingCommand(transactionalEditingDomain){

                protected void doExecute() {
                    Node node = nodeSelection.getSelectedNode();
                    AbstractPickLocationToolCustomImpl.this.setSelectedNode(node);
                    GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
                    NodePath nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
                    AbstractPickLocationToolCustomImpl.this.setSelectedNodeNodePath(nodePath);
                    Tuple3d relativePosition = null;
                    if (nodeSelection.getRelativeIntersectionPoint() != null) {
                        relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
                    }
                    AbstractPickLocationToolCustomImpl.this.setSelectedRelativePosition(relativePosition);
                    Tuple3d relativeNormal = null;
                    if (nodeSelection.getRelativeIntersectionNormal() != null) {
                        relativeNormal = ApogyCommonMathFacade.INSTANCE.createTuple3d((double)nodeSelection.getRelativeIntersectionNormal().x, (double)nodeSelection.getRelativeIntersectionNormal().y, (double)nodeSelection.getRelativeIntersectionNormal().z);
                    }
                    AbstractPickLocationToolCustomImpl.this.setRelativeIntersectionNormal(relativeNormal);
                    AbstractPickLocationToolCustomImpl.this.detachPickLocationToolNode();
                    if (AbstractPickLocationToolCustomImpl.this.getAbstractPickLocationToolNode() != null) {
                        Matrix4d matrix = new Matrix4d();
                        matrix.setIdentity();
                        matrix.setTranslation(new Vector3d(relativePosition.asTuple3d()));
                        AbstractPickLocationToolCustomImpl.this.getAbstractPickLocationToolNode().setTransformation(matrix);
                    }
                    AbstractPickLocationToolCustomImpl.this.attachPickLocationToolNode();
                }
            };
            try {
                transactionalEditingDomain.getCommandStack().execute((Command)cmd);
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.abstractPickLocationToolNode != null && this.abstractPickLocationToolNode.getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.abstractPickLocationToolNode.getParent();
            parent.getChildren().remove((Object)this.abstractPickLocationToolNode);
            this.abstractPickLocationToolNode.setParent(null);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_PICK_LOCATION_TOOL__ABSTRACT_PICK_LOCATION_TOOL_NODE, null);
    }

    protected void initializeNodeAndPosition() {
        if (this.getSelectedNodeNodePath() != null) {
            Node node = ApogyCommonTopologyFacade.INSTANCE.resolveNode(this.getRootNode(), this.getSelectedNodeNodePath());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_PICK_LOCATION_TOOL__SELECTED_NODE, (Object)node);
        }
        this.attachPickLocationToolNode();
    }

    protected void setPickLocationToolNodeVisibility(boolean visible) {
        NodePresentation nodePresentation;
        if (this.getAbstractPickLocationToolNode() != null && (nodePresentation = Activator.getTopologyPresentationRegistry().getPresentationNode((Node)this.getAbstractPickLocationToolNode())) != null) {
            nodePresentation.setVisible(visible);
        }
    }

    protected void attachPickLocationToolNode() {
        if (this.getAbstractPickLocationToolNode() != null) {
            this.detachPickLocationToolNode();
            if (this.getSelectedNode() != null) {
                if (this.getSelectedNode() instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)this.getSelectedNode();
                    groupNode.getChildren().add((Object)this.getAbstractPickLocationToolNode());
                    if (this.getSelectedRelativePosition() != null) {
                        this.getAbstractPickLocationToolNode().setPosition((Tuple3d)EcoreUtil.copy((EObject)this.getSelectedRelativePosition()));
                    }
                } else if (this.getSelectedNode().getParent() instanceof GroupNode) {
                    GroupNode groupNode = (GroupNode)this.getSelectedNode().getParent();
                    groupNode.getChildren().add((Object)this.getAbstractPickLocationToolNode());
                    if (this.getSelectedRelativePosition() != null) {
                        this.getAbstractPickLocationToolNode().setPosition((Tuple3d)EcoreUtil.copy((EObject)this.getSelectedRelativePosition()));
                    }
                }
            }
        }
    }

    protected void detachPickLocationToolNode() {
        if (this.getAbstractPickLocationToolNode() != null && this.getAbstractPickLocationToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getAbstractPickLocationToolNode().getParent();
            parent.getChildren().remove((Object)this.getAbstractPickLocationToolNode());
        }
    }
}

