/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.Simple3DTool;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.common.topology.ui.viewer.TopologyViewerRegistry;
import org.eclipse.apogy.core.ApogyTopology;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyViewerListenerManager {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyViewerListenerManager.class);
    private Adapter topologyViewerRegistryAdapter = null;
    private Adapter sessionAdapter = null;
    private final TopologyViewerRegistry topologyViewerRegistry;
    private Node currentRootNode = null;
    private final List<Simple3DTool> simple3DTools = new ArrayList<Simple3DTool>();

    public TopologyViewerListenerManager(TopologyViewerRegistry topologyViewerRegistry) {
        this.topologyViewerRegistry = topologyViewerRegistry;
        topologyViewerRegistry.eAdapters().add((Object)this.getTopologyViewerRegistryAdapter());
        ApogyCoreTopologyFacade.INSTANCE.eAdapters().add((Object)this.getApogyTopologyAdapter());
        this.setAllSimple3DToolRootNode(this.resolveRootNode());
    }

    public void dispose() {
        if (this.topologyViewerRegistry != null) {
            this.topologyViewerRegistry.eAdapters().remove((Object)this.getTopologyViewerRegistryAdapter());
        }
    }

    public void registerSimple3DTool(Simple3DTool tool) {
        if (!this.simple3DTools.contains(tool)) {
            this.simple3DTools.add(tool);
        }
        try {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)tool, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE3_DTOOL__ROOT_NODE, (Object)this.currentRootNode);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void unRegisterSimple3DTool(Simple3DTool tool) {
        this.simple3DTools.remove(tool);
    }

    public void setAllSimple3DToolRootNode(Node root) {
        Logger.info("Updating Simple3DTool  Root Node to <" + root + ">.");
        this.currentRootNode = root;
        if (this.currentRootNode != null) {
            for (Simple3DTool tool : this.simple3DTools) {
                try {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)tool, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE3_DTOOL__ROOT_NODE, (Object)this.currentRootNode);
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        }
    }

    protected Node resolveRootNode() {
        GroupNode root = null;
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null && ApogyCoreTopologyFacade.INSTANCE.getApogyTopology() != null) {
            root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
        }
        return root;
    }

    protected void notifyAllSimple3DTool(NodeSelection nodeSelection) {
        for (Simple3DTool tool : this.simple3DTools) {
            try {
                if (!tool.isActive()) continue;
                tool.selectionChanged(nodeSelection);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    protected void notifyAllSimple3DTool(MouseButton mouseButtonClicked) {
        for (Simple3DTool tool : this.simple3DTools) {
            try {
                if (!tool.isActive()) continue;
                tool.mouseButtonClicked(mouseButtonClicked);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    protected void notifynotifyAllSimple3DToolkeyPressed(char key) {
        for (Simple3DTool tool : this.simple3DTools) {
            try {
                if (!tool.isActive()) continue;
                tool.keyPressed(key);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    protected void notifynotifyAllSimple3DToolkeyReleased(char key) {
        for (Simple3DTool tool : this.simple3DTools) {
            try {
                if (!tool.isActive()) continue;
                tool.keyReleased(key);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
    }

    protected Adapter getTopologyViewerRegistryAdapter() {
        if (this.topologyViewerRegistryAdapter == null) {
            this.topologyViewerRegistryAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TopologyViewerRegistry) {
                        int featureId = msg.getFeatureID(TopologyViewerRegistry.class);
                        switch (featureId) {
                            case 1: {
                                if (!(msg.getNewValue() instanceof NodeSelection)) break;
                                NodeSelection nodeSelection = (NodeSelection)msg.getNewValue();
                                TopologyViewerListenerManager.this.notifyAllSimple3DTool(nodeSelection);
                                break;
                            }
                            case 2: {
                                if (!(msg.getNewValue() instanceof MouseButton)) break;
                                MouseButton mouseButton = (MouseButton)msg.getNewValue();
                                TopologyViewerListenerManager.this.notifyAllSimple3DTool(mouseButton);
                                break;
                            }
                            case 3: {
                                TopologyViewerListenerManager.this.notifynotifyAllSimple3DToolkeyPressed(msg.getNewCharValue());
                                break;
                            }
                            case 4: {
                                TopologyViewerListenerManager.this.notifynotifyAllSimple3DToolkeyReleased(msg.getNewCharValue());
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.topologyViewerRegistryAdapter;
    }

    private Adapter getApogyTopologyAdapter() {
        if (this.sessionAdapter == null) {
            this.sessionAdapter = new ApogyTopologyAdapter();
        }
        return this.sessionAdapter;
    }

    private class ApogyTopologyAdapter
    extends AdapterImpl {
        private ApogyTopologyAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof ApogyCoreTopologyFacade) {
                int featureId = msg.getFeatureID(ApogyCoreTopologyFacade.class);
                switch (featureId) {
                    case 0: {
                        ApogyTopology newApogyTopology = (ApogyTopology)msg.getNewValue();
                        if (newApogyTopology != null) {
                            TopologyViewerListenerManager.this.setAllSimple3DToolRootNode((Node)newApogyTopology.getRootNode());
                            break;
                        }
                        TopologyViewerListenerManager.this.setAllSimple3DToolRootNode(null);
                        break;
                    }
                }
            }
        }
    }
}

