/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems;

import java.util.Date;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerConverterState;
import org.eclipse.apogy.addons.powersystems.PowerSystemFacade;
import org.eclipse.apogy.addons.powersystems.impl.PowerConverterImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerConverterCustomImpl
extends PowerConverterImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PowerConverterCustomImpl.class);

    @Override
    public void restart() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER__CONVERTER_STATE, (Object)PowerConverterState.ON, true);
        Logger.info("Power Converter " + this.getName() + " restarted.");
    }

    @Override
    public double getEffectiveEfficiency() {
        if (this.getConverterState() == PowerConverterState.ON) {
            return this.getEfficiency();
        }
        return 0.0;
    }

    @Override
    public void update(Date time) {
        double requiredPower = PowerSystemFacade.INSTANCE.findRequiredPowerFromConsumer(this.getPowerSystem().getSystemGraph(), this);
        switch (this.getConverterState().getValue()) {
            case 0: {
                if (!(requiredPower > this.getMaxPowerOutput())) break;
                this.trip();
                break;
            }
            case 1: {
                if (!this.isAutoRestart() || !(requiredPower <= this.getMaxPowerOutput())) break;
                this.restart();
                break;
            }
        }
    }

    protected void trip() {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_CONVERTER__CONVERTER_STATE, (Object)PowerConverterState.SHUTDOWN, true);
        Logger.warn("Power Converter " + this.getName() + " exceeded maximum power !");
    }
}

