/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.ui.composites;

import java.text.DecimalFormat;
import javax.measure.unit.Unit;
import org.eclipse.apogy.addons.powersystems.ApogyAddonsPowerSystemsPackage;
import org.eclipse.apogy.addons.powersystems.PowerBus;
import org.eclipse.apogy.addons.powersystems.PowerBusState;
import org.eclipse.apogy.common.emf.Ranges;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.emf.ui.emfforms.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PowerBusComposite<RootEObject extends EObject>
extends AbstractEObjectComposite<RootEObject, PowerBus, PowerBus> {
    public static final Color NOT_AVAILABLE_COLOR = new Color((Device)Display.getDefault(), 0, 255, 255);
    public static final Color POWER_BUS_NOMINAL_COLOR = new Color((Device)Display.getDefault(), 0, 255, 0);
    public static final Color POWER_BUS_LOAD_SHEDDING_COLOR = new Color((Device)Display.getDefault(), 0, 255, 255);
    public static final Color POWER_BUS_OVERLOADED_COLOR = new Color((Device)Display.getDefault(), 255, 0, 0);
    private DataBindingContext m_bindingContext;
    private Text busStateText;
    private TypedElementSimpleUnitsComposite powerBalanceComposite;
    private TypedElementSimpleUnitsComposite overloadComposite;
    private TypedElementSimpleUnitsComposite totalLoadComposite;
    private TypedElementSimpleUnitsComposite sourcesPowerComposite;
    private TypedElementSimpleUnitsComposite storagePowerComposite;

    public PowerBusComposite(Composite parent, int style, FeaturePath featurePath) {
        super(parent, style, featurePath, null);
        this.addListener(12, e -> {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
            }
        });
    }

    protected Composite createContentComposite(Composite parent, int style) {
        Composite top = new Composite(parent, style);
        top.setLayout((Layout)new GridLayout(6, true));
        Label busStateLabel = new Label(top, 0);
        busStateLabel.setText("Bus State :");
        this.busStateText = new Text(top, 2056);
        this.busStateText.setText("N/A");
        this.busStateText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label powerBalanceLabel = new Label(top, 0);
        powerBalanceLabel.setText("Power Balance (W) :");
        this.powerBalanceComposite = new TypedElementSimpleUnitsComposite(top, 0, false, false, "N/A"){
            private DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected Unit<?> getDisplayUnits() {
                return Unit.valueOf((CharSequence)"W");
            }

            protected Color getInvalidDataColor() {
                return NOT_AVAILABLE_COLOR;
            }

            protected Ranges getRange(ETypedElement eTypedElement, Object value) {
                Ranges ranges = Ranges.NOMINAL;
                Number number = (Number)value;
                ranges = number.doubleValue() > 0.0 ? Ranges.NOMINAL : Ranges.WARNING;
                return ranges;
            }
        };
        this.powerBalanceComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label overloadLabel = new Label(top, 0);
        overloadLabel.setText("Overload (W) :");
        this.overloadComposite = new TypedElementSimpleUnitsComposite(top, 0, false, false, "N/A"){
            private DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected Unit<?> getDisplayUnits() {
                return Unit.valueOf((CharSequence)"W");
            }

            protected Color getInvalidDataColor() {
                return NOT_AVAILABLE_COLOR;
            }

            protected Ranges getRange(ETypedElement eTypedElement, Object value) {
                Ranges ranges = Ranges.NOMINAL;
                Number number = (Number)value;
                if (number.doubleValue() > 0.0) {
                    ranges = Ranges.ALARM;
                }
                return ranges;
            }
        };
        this.overloadComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label powerLoadLabel = new Label(top, 0);
        powerLoadLabel.setText("Power Load (W) :");
        this.totalLoadComposite = new TypedElementSimpleUnitsComposite(top, 0, false, false, "N/A"){
            private DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected Unit<?> getDisplayUnits() {
                return Unit.valueOf((CharSequence)"W");
            }

            protected Color getInvalidDataColor() {
                return NOT_AVAILABLE_COLOR;
            }
        };
        this.totalLoadComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label sourcesPowerLabel = new Label(top, 0);
        sourcesPowerLabel.setText("Sources Power (W) :");
        this.sourcesPowerComposite = new TypedElementSimpleUnitsComposite(top, 0, false, false, "N/A"){
            private DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected Unit<?> getDisplayUnits() {
                return Unit.valueOf((CharSequence)"W");
            }

            protected Color getInvalidDataColor() {
                return NOT_AVAILABLE_COLOR;
            }
        };
        this.sourcesPowerComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label storagePowerLabel = new Label(top, 0);
        storagePowerLabel.setText("Storage Power (W) :");
        this.storagePowerComposite = new TypedElementSimpleUnitsComposite(top, 0, false, false, "N/A"){
            private DecimalFormat format;
            {
                this.format = new DecimalFormat("0.000");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected Unit<?> getDisplayUnits() {
                return Unit.valueOf((CharSequence)"W");
            }

            protected Color getInvalidDataColor() {
                return NOT_AVAILABLE_COLOR;
            }
        };
        this.storagePowerComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (this.getResolvedEObject() != null && !this.isDisposed()) {
            this.m_bindingContext = this.initDataBindings();
        }
        return top;
    }

    protected void rootEObjectChanged(RootEObject rootEObject) {
    }

    protected void resolvedEObjectChanged(PowerBus value) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (value != null && !this.isDisposed()) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    protected void itemObjectChanged(PowerBus itemObject) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
            this.m_bindingContext = null;
        }
        if (itemObject != null && !this.isDisposed()) {
            this.m_bindingContext = this.initDataBindings();
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue powerBusStateObserveValue = EMFObservables.observeValue((EObject)this.getResolvedEObject(), (EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_BUS_STATE);
        ISWTObservableValue busStateTextObserveText = WidgetProperties.text((int)0).observe((Widget)this.busStateText);
        bindingContext.bindValue((IObservableValue)busStateTextObserveText, powerBusStateObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                return ((PowerBusState)fromObject).getLiteral();
            }

            public Object getFromType() {
                return PowerBusState.class;
            }

            public Object getToType() {
                return String.class;
            }
        }));
        ISWTObservableValue busStateTextObserveBackground = WidgetProperties.background().observe((Widget)this.busStateText);
        bindingContext.bindValue((IObservableValue)busStateTextObserveBackground, powerBusStateObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter(new IConverter(){

            public Object convert(Object fromObject) {
                Color color = null;
                PowerBusState powerBusState = (PowerBusState)fromObject;
                switch (powerBusState.getValue()) {
                    case 0: {
                        color = POWER_BUS_NOMINAL_COLOR;
                        break;
                    }
                    case 2: {
                        color = POWER_BUS_LOAD_SHEDDING_COLOR;
                        break;
                    }
                    case 1: {
                        color = POWER_BUS_OVERLOADED_COLOR;
                        break;
                    }
                }
                return color;
            }

            public Object getFromType() {
                return PowerBusState.class;
            }

            public Object getToType() {
                return Color.class;
            }
        }));
        try {
            this.powerBalanceComposite.setTypedElement((EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_BALANCE, this.getResolvedEObject());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.overloadComposite.setTypedElement((EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__BUS_POWER_OVERLOAD, this.getResolvedEObject());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.totalLoadComposite.setTypedElement((EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__TOTAL_POWER_LOAD, this.getResolvedEObject());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.sourcesPowerComposite.setTypedElement((EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_AVAILABLE_FROM_SOURCES, this.getResolvedEObject());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            this.storagePowerComposite.setTypedElement((EStructuralFeature)ApogyAddonsPowerSystemsPackage.Literals.POWER_BUS__POWER_AVAILABLE_FROM_ENERGY_STORAGE, this.getResolvedEObject());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return bindingContext;
    }
}

