/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.io.FileNotFoundException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import org.eclipse.apogy.addons.monitoring.impl.SoundWithQuindarTonesNotificationEffectImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class SoundWithQuindarTonesNotificationEffectCustomImpl
extends SoundWithQuindarTonesNotificationEffectImpl {
    protected Clip introClip = null;
    protected Clip outroClip = null;

    @Override
    protected void stopClip() {
        super.stopClip();
        if (this.introClip != null) {
            try {
                this.introClip.stop();
                this.introClip = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.outroClip != null) {
            try {
                this.outroClip.stop();
                this.outroClip = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void startClip() {
        try {
            URL url = this.resolveSoundURL();
            if (url != null) {
                this.introClip = null;
                this.outroClip = null;
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
                this.clip = AudioSystem.getClip();
                this.clip.open(audioIn);
                if (this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    this.volumeControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                    float gain = this.getMasterGain(this.getVolume());
                    this.volumeControl.setValue(gain);
                }
                if (this.isRepeat()) {
                    this.clip.setLoopPoints(0, this.clip.getFrameLength() - 1);
                    this.clip.loop(-1);
                }
                this.clip.addLineListener(new LineListener(){

                    @Override
                    public void update(LineEvent event) {
                        if (event.getType() == LineEvent.Type.STOP && SoundWithQuindarTonesNotificationEffectCustomImpl.this.isEnableOutroTone()) {
                            SoundWithQuindarTonesNotificationEffectCustomImpl.this.getOutroClip().setMicrosecondPosition(0L);
                            SoundWithQuindarTonesNotificationEffectCustomImpl.this.getOutroClip().start();
                        }
                    }
                });
                if (this.isEnableIntroTone()) {
                    this.getIntroClip().addLineListener(new LineListener(){

                        @Override
                        public void update(LineEvent event) {
                            if (event.getType() == LineEvent.Type.STOP) {
                                SoundWithQuindarTonesNotificationEffectCustomImpl.this.clip.start();
                            }
                        }
                    });
                    this.getIntroClip().setMicrosecondPosition(0L);
                    this.getIntroClip().start();
                } else {
                    this.clip.start();
                }
            }
        }
        catch (FileNotFoundException e) {
            String title = "Sound Alarm Effect failed to activate !";
            String message = "Failed to open sound file <" + this.getSoundURL() + "> !";
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, message, 1, new String[]{"OK"}, 0);
            dialog.open();
            e.printStackTrace();
        }
        catch (Exception e) {
            String title = "Sound Alarm Effect failed to activate !";
            String message = "Failed to play sound file <" + this.getSoundURL() + "> : " + e.getMessage();
            MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), title, null, message, 1, new String[]{"OK"}, 0);
            dialog.open();
            e.printStackTrace();
        }
    }

    protected Clip getIntroClip() {
        if (this.introClip == null) {
            try {
                URL introURL = new URL("platform:/plugin/org.eclipse.apogy.addons.monitoring/sounds/Quindar_Intro_Tone.wav");
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(introURL);
                this.introClip = AudioSystem.getClip();
                this.introClip.open(audioIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.introClip;
    }

    protected Clip getOutroClip() {
        if (this.outroClip == null) {
            try {
                URL outroURL = new URL("platform:/plugin/org.eclipse.apogy.addons.monitoring/sounds/Quindar_Outro_Tone.wav");
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(outroURL);
                this.outroClip = AudioSystem.getClip();
                this.outroClip.open(audioIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.outroClip;
    }
}

