/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RelationalOperation implements Enumerator
{
    LESS_THAN(1, "LESS_THAN", "<"),
    LESS_THAN_OR_EQUAL(2, "LESS_THAN_OR_EQUAL", "<="),
    EQUAL(3, "EQUAL", "="),
    GREATER_THAN_OR_EQUAL(4, "GREATER_THAN_OR_EQUAL", ">="),
    GREATER_THAN(5, "GREATER_THAN", ">"),
    NOT_EQUAL(6, "NOT_EQUAL", "!=");

    public static final int LESS_THAN_VALUE = 1;
    public static final int LESS_THAN_OR_EQUAL_VALUE = 2;
    public static final int EQUAL_VALUE = 3;
    public static final int GREATER_THAN_OR_EQUAL_VALUE = 4;
    public static final int GREATER_THAN_VALUE = 5;
    public static final int NOT_EQUAL_VALUE = 6;
    private static final RelationalOperation[] VALUES_ARRAY;
    public static final List<RelationalOperation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationalOperation[]{LESS_THAN, LESS_THAN_OR_EQUAL, EQUAL, GREATER_THAN_OR_EQUAL, GREATER_THAN, NOT_EQUAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationalOperation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperation get(int value) {
        switch (value) {
            case 1: {
                return LESS_THAN;
            }
            case 2: {
                return LESS_THAN_OR_EQUAL;
            }
            case 3: {
                return EQUAL;
            }
            case 4: {
                return GREATER_THAN_OR_EQUAL;
            }
            case 5: {
                return GREATER_THAN;
            }
            case 6: {
                return NOT_EQUAL;
            }
        }
        return null;
    }

    private RelationalOperation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

