/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.monitoring;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;
import org.eclipse.apogy.addons.monitoring.ApogyNotifier;
import org.eclipse.apogy.addons.monitoring.impl.CSVLoggingNotificationEffectImpl;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.emf.common.util.Enumerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVLoggingNotificationEffectCustomImpl
extends CSVLoggingNotificationEffectImpl {
    private static final Logger Logger = LoggerFactory.getLogger(CSVLoggingNotificationEffectCustomImpl.class);
    private PrintWriter csvFileWriter = null;

    @Override
    public void activate(ApogyNotifier notifier, Object newValue) {
        long now = System.currentTimeMillis();
        Date nowDate = new Date(now);
        String csvEntry = String.valueOf(ApogyCommonEMFFacade.INSTANCE.format(nowDate)) + "," + Long.toString(now) + ", " + this.getValueString(newValue) + "\n";
        try {
            this.writeToFile(csvEntry);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.csvFileWriter != null) {
                this.csvFileWriter.flush();
                this.csvFileWriter.close();
                this.csvFileWriter = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setFileURL(String newFileURL) {
        super.setFileURL(newFileURL);
        if (this.csvFileWriter != null) {
            this.csvFileWriter.flush();
            this.csvFileWriter.close();
            this.csvFileWriter = null;
        }
    }

    @Override
    public void setAppend(boolean newAppend) {
        super.setAppend(newAppend);
        if (!newAppend && this.getFileURL() != null) {
            String filePath = this.getFileURL().replaceFirst("file:", "");
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
            this.csvFileWriter = null;
        }
    }

    protected String getValueString(Object newValue) {
        String value = "null";
        if (newValue != null) {
            value = newValue instanceof Boolean ? Boolean.toString((Boolean)newValue) : (newValue instanceof Number ? Double.toString(((Number)newValue).doubleValue()) : (newValue instanceof Enumerator ? ((Enumerator)newValue).getLiteral() : newValue.toString()));
        }
        return value;
    }

    protected void writeToFile(String string) throws Exception {
        this.getCsvFileWriter().write(string);
        this.getCsvFileWriter().flush();
    }

    private PrintWriter getCsvFileWriter() {
        if (this.csvFileWriter == null) {
            try {
                String filePath = this.getFileURL().replaceFirst("file:", "");
                File testFile = new File(filePath);
                boolean fileExist = testFile.exists();
                if (!fileExist) {
                    testFile.createNewFile();
                }
                FileWriter fileWriter = new FileWriter(filePath, this.isAppend());
                BufferedWriter bw = new BufferedWriter(fileWriter);
                this.csvFileWriter = new PrintWriter(bw);
                if (!this.isAppend()) {
                    this.csvFileWriter.print("Time, Time (UNIX ms), Value \n");
                }
            }
            catch (Exception exception) {
                Logger.info("Could not create csv file <" + this.getFileURL() + "> !");
            }
        }
        return this.csvFileWriter;
    }
}

