/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.post.SceneProcessor;
import com.jme3.post.TextureProjector;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.GeometryList;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.List;

public class MultiTextureProjectorRenderer
implements SceneProcessor {
    private static final int numProjectorsPerPass = 8;
    private RenderManager renderManager;
    private ViewPort viewPort;
    private Material textureMat;
    private ArrayList<TextureProjector> textureProjectors;
    private GeometryList targetGeometryList;

    public MultiTextureProjectorRenderer(AssetManager assetManager) {
        this.textureMat = new Material(assetManager, "Common/MatDefs/Misc/ProjectiveMultiTextureMapping.j3md");
        this.textureProjectors = new ArrayList();
        this.renderManager = null;
        this.viewPort = null;
        this.targetGeometryList = null;
        this.setPolyOffset(-0.1f, -0.1f);
    }

    public List<TextureProjector> getTextureProjectors() {
        return this.textureProjectors;
    }

    public GeometryList getTargetGeometryList() {
        return this.targetGeometryList;
    }

    public void setTargetGeometryList(GeometryList targetGeometryList) {
        this.targetGeometryList = targetGeometryList;
    }

    public final void setPolyOffset(float factor, float units) {
        this.textureMat.getAdditionalRenderState().setPolyOffset(factor, units);
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderManager = rm;
        this.viewPort = vp;
    }

    public boolean isInitialized() {
        return this.viewPort != null;
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        this.renderManager.getRenderer().setFrameBuffer(out);
        this.renderManager.setForcedMaterial(this.textureMat);
        int numProjectors = this.textureProjectors.size();
        int numPasses = (numProjectors + 8 - 1) / 8;
        int currentProjector = 0;
        int pass = 0;
        while (pass < numPasses) {
            int numProjectorsThisPass = pass < numPasses - 1 ? 8 : numProjectors - currentProjector;
            this.textureMat.setInt("NumProjectors", numProjectorsThisPass);
            int i = 0;
            while (i < 8) {
                if (i < numProjectorsThisPass) {
                    TextureProjector textureProjector = this.textureProjectors.get(currentProjector);
                    float fallOffDistance = textureProjector.getFallOffDistance();
                    Object combineMode = textureProjector.getParameter("CombineMode");
                    if (combineMode != null && combineMode instanceof CombineMode) {
                        this.textureMat.setInt("CombineMode" + i, ((CombineMode)((Object)combineMode)).ordinal());
                    }
                    this.textureMat.setTexture("ProjectiveMap" + i, (Texture)textureProjector.getProjectiveTexture());
                    this.textureMat.setMatrix4("ProjectorViewProjectionMatrix" + i, textureProjector.getProjectorViewProjectionMatrix());
                    if (textureProjector.isParallelProjection()) {
                        this.textureMat.clearParam("ProjectorLocation" + i);
                        this.textureMat.setVector3("ProjectorDirection" + i, textureProjector.getProjectorDirection());
                    } else {
                        this.textureMat.clearParam("ProjectorDirection" + i);
                        this.textureMat.setVector3("ProjectorLocation" + i, textureProjector.getProjectorLocation());
                    }
                    if (fallOffDistance != Float.MAX_VALUE) {
                        this.textureMat.setFloat("FallOffDistance" + i, textureProjector.getFallOffDistance());
                        this.textureMat.setFloat("FallOffPower" + i, textureProjector.getFallOffPower());
                    } else {
                        this.textureMat.clearParam("FallOffDistance" + i);
                        this.textureMat.clearParam("FallOffPower" + i);
                    }
                } else {
                    this.textureMat.clearParam("ProjectiveMap" + i);
                    this.textureMat.clearParam("ProjectorViewProjectionMatrix" + i);
                    this.textureMat.clearParam("ProjectorLocation" + i);
                    this.textureMat.clearParam("ProjectorDirection" + i);
                    this.textureMat.clearParam("FallOffDistance" + i);
                    this.textureMat.clearParam("FallOffPower" + i);
                    this.textureMat.clearParam("CombineMode" + i);
                }
                ++i;
                ++currentProjector;
            }
            if (this.targetGeometryList != null) {
                this.renderManager.renderGeometryList(this.targetGeometryList);
            } else {
                this.renderManager.renderViewPortRaw(this.viewPort);
            }
            ++pass;
        }
        this.renderManager.setForcedMaterial(null);
    }

    public void cleanup() {
    }

    public void reshape(ViewPort vp, int w, int h) {
    }

    public static enum CombineMode {
        BLEND_COLOR_ADD_ALPHA,
        BLEND_ALL;

    }
}

