/*******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Mathieu Larose (Savoir-faire Linux) - Initial API and implementation
 *
 * SPDX-License-Identifier: EPL-1.0
 *     
 *******************************************************************************/
package org.eclipse.apogy.core.programs.javascript;

import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

/**
 * Gets an attribute of EObject represented by a {@VariableFeatureReference}.
 */
public class AttributeGetter {
	private final VariableFeatureReference variableFeatureReference;
	private final EStructuralFeature feature;

	public AttributeGetter(VariableFeatureReference variableFeatureReference, EStructuralFeature feature) {
		this.variableFeatureReference = variableFeatureReference;
		this.feature = feature;
	}

	/**
	 * Returns the attribute (represented by this class) of the EObject (represented
	 * by <code>variableFeatureReference</code>)
	 * 
	 * @param self The JavaScript object
	 * @return the attribute
	 */
	public Object get(Scriptable self) {
		EObject instance = ApogyCoreInvocatorFacade.INSTANCE.getInstance(this.variableFeatureReference);
		return Context.javaToJS(instance.eGet(this.feature), self);
	}
}