/**
 * *******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Steve Monnier OBEO - Initial API and implementation
 *         
 * SPDX-License-Identifier: EPL-1.0    
 * *******************************************************************************
 */
package org.eclipse.apogy.core.programs.javascript.impl;

import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;

import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;

import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsFactory;
import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage;
import org.eclipse.apogy.core.programs.javascript.ApogyJavaScriptFacade;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgramFactory;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgramRuntime;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ApogyCoreJavaScriptProgramsPackageImpl extends EPackageImpl implements ApogyCoreJavaScriptProgramsPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass apogyJavaScriptFacadeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass javaScriptProgramEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass javaScriptProgramRuntimeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass javaScriptProgramFactoryEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ApogyCoreJavaScriptProgramsPackageImpl() {
		super(eNS_URI, ApogyCoreJavaScriptProgramsFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link ApogyCoreJavaScriptProgramsPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ApogyCoreJavaScriptProgramsPackage init() {
		if (isInited) return (ApogyCoreJavaScriptProgramsPackage)EPackage.Registry.INSTANCE.getEPackage(ApogyCoreJavaScriptProgramsPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredApogyCoreJavaScriptProgramsPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		ApogyCoreJavaScriptProgramsPackageImpl theApogyCoreJavaScriptProgramsPackage = registeredApogyCoreJavaScriptProgramsPackage instanceof ApogyCoreJavaScriptProgramsPackageImpl ? (ApogyCoreJavaScriptProgramsPackageImpl)registeredApogyCoreJavaScriptProgramsPackage : new ApogyCoreJavaScriptProgramsPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		EcorePackage.eINSTANCE.eClass();
		ApogyCoreInvocatorPackage.eINSTANCE.eClass();
		ApogyCommonEMFPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theApogyCoreJavaScriptProgramsPackage.createPackageContents();

		// Initialize created meta-data
		theApogyCoreJavaScriptProgramsPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theApogyCoreJavaScriptProgramsPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ApogyCoreJavaScriptProgramsPackage.eNS_URI, theApogyCoreJavaScriptProgramsPackage);
		return theApogyCoreJavaScriptProgramsPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getApogyJavaScriptFacade() {
		return apogyJavaScriptFacadeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getApogyJavaScriptFacade__CreateJavaScriptCodeTemplate__InvocatorSession_JavaScriptProgram() {
		return apogyJavaScriptFacadeEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJavaScriptProgram() {
		return javaScriptProgramEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getJavaScriptProgram_ScriptPath() {
		return (EAttribute)javaScriptProgramEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJavaScriptProgramRuntime() {
		return javaScriptProgramRuntimeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getJavaScriptProgramFactory() {
		return javaScriptProgramFactoryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ApogyCoreJavaScriptProgramsFactory getApogyCoreJavaScriptProgramsFactory() {
		return (ApogyCoreJavaScriptProgramsFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		apogyJavaScriptFacadeEClass = createEClass(APOGY_JAVA_SCRIPT_FACADE);
		createEOperation(apogyJavaScriptFacadeEClass, APOGY_JAVA_SCRIPT_FACADE___CREATE_JAVA_SCRIPT_CODE_TEMPLATE__INVOCATORSESSION_JAVASCRIPTPROGRAM);

		javaScriptProgramEClass = createEClass(JAVA_SCRIPT_PROGRAM);
		createEAttribute(javaScriptProgramEClass, JAVA_SCRIPT_PROGRAM__SCRIPT_PATH);

		javaScriptProgramRuntimeEClass = createEClass(JAVA_SCRIPT_PROGRAM_RUNTIME);

		javaScriptProgramFactoryEClass = createEClass(JAVA_SCRIPT_PROGRAM_FACTORY);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);
		ApogyCoreInvocatorPackage theApogyCoreInvocatorPackage = (ApogyCoreInvocatorPackage)EPackage.Registry.INSTANCE.getEPackage(ApogyCoreInvocatorPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		javaScriptProgramEClass.getESuperTypes().add(theApogyCoreInvocatorPackage.getScriptBasedProgram());
		javaScriptProgramEClass.getESuperTypes().add(theApogyCoreInvocatorPackage.getOperationCallContainer());
		javaScriptProgramRuntimeEClass.getESuperTypes().add(theApogyCoreInvocatorPackage.getAbstractProgramRuntime());
		javaScriptProgramFactoryEClass.getESuperTypes().add(theApogyCoreInvocatorPackage.getProgramFactory());

		// Initialize classes, features, and operations; add parameters
		initEClass(apogyJavaScriptFacadeEClass, ApogyJavaScriptFacade.class, "ApogyJavaScriptFacade", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		EOperation op = initEOperation(getApogyJavaScriptFacade__CreateJavaScriptCodeTemplate__InvocatorSession_JavaScriptProgram(), theEcorePackage.getEString(), "createJavaScriptCodeTemplate", 0, 1, !IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theApogyCoreInvocatorPackage.getInvocatorSession(), "session", 0, 1, !IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getJavaScriptProgram(), "javaScriptProgram", 0, 1, !IS_UNIQUE, IS_ORDERED);

		initEClass(javaScriptProgramEClass, JavaScriptProgram.class, "JavaScriptProgram", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getJavaScriptProgram_ScriptPath(), theEcorePackage.getEString(), "scriptPath", null, 0, 1, JavaScriptProgram.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(javaScriptProgramRuntimeEClass, JavaScriptProgramRuntime.class, "JavaScriptProgramRuntime", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEClass(javaScriptProgramFactoryEClass, JavaScriptProgramFactory.class, "JavaScriptProgramFactory", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// http://www.eclipse.org/apogy
		createApogyAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "prefix", "ApogyCoreJavaScriptPrograms",
			   "childCreationExtenders", "true",
			   "extensibleProviderFactory", "true",
			   "multipleEditorPages", "false",
			   "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Steve Monnier OBEO - Initial API and implementation\n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************",
			   "modelName", "ApogyCoreJavaScriptPrograms",
			   "suppressGenModelAnnotations", "false",
			   "publicConstructors", "true",
			   "dynamicTemplates", "true",
			   "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates",
			   "modelDirectory", "/org.eclipse.apogy.core.programs.javascript/src-gen",
			   "editDirectory", "/org.eclipse.apogy.core.programs.javascript.edit/src-gen",
			   "basePackage", "org.eclipse.apogy.core.programs"
		   });
		addAnnotation
		  (getApogyJavaScriptFacade__CreateJavaScriptCodeTemplate__InvocatorSession_JavaScriptProgram(),
		   source,
		   new String[] {
			   "documentation", "*\nCreate the default Java Script code template. This template includes the required header and main function.\n@param session The session in which the script is being defined.\n@param javaScriptProgram The JavaScriptProgram for which the script is being created."
		   });
		addAnnotation
		  (javaScriptProgramEClass,
		   source,
		   new String[] {
			   "documentation", "A JavaScriptProgram is an entity that invokes Operation Calls on Variables through a JavaScript program file."
		   });
		addAnnotation
		  (javaScriptProgramRuntimeEClass,
		   source,
		   new String[] {
			   "documentation", "Specialization of AbstractProgramRuntime used for executing Java Scripts."
		   });
		addAnnotation
		  (javaScriptProgramFactoryEClass,
		   source,
		   new String[] {
			   "documentation", "Javascript Factory"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/apogy</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createApogyAnnotations() {
		String source = "http://www.eclipse.org/apogy";
		addAnnotation
		  (apogyJavaScriptFacadeEClass,
		   source,
		   new String[] {
			   "isSingleton", "true",
			   "hasCustomClass", "true"
		   });
		addAnnotation
		  (javaScriptProgramEClass,
		   source,
		   new String[] {
			   "hasCustomItemProvider", "true"
		   });
		addAnnotation
		  (javaScriptProgramRuntimeEClass,
		   source,
		   new String[] {
			   "hasCustomClass", "true"
		   });
		addAnnotation
		  (javaScriptProgramFactoryEClass,
		   source,
		   new String[] {
			   "hasCustomClass", "true"
		   });
	}

} //ApogyCoreJavaScriptProgramsPackageImpl
