#import "Common/ShaderLib/Parallax.glsllib"
#import "Common/ShaderLib/Optics.glsllib"
#define ATTENUATION
//#define HQ_ATTENUATION

varying vec2 texCoord;
#ifdef SEPARATE_TEXCOORD
  varying vec2 texCoord2;
#endif

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;

// ShaderBasedMeshTool START
uniform mat4  g_ModelViewMatrixInverse;

uniform mat4 m_Tool0Matrix;
uniform mat4 m_Tool1Matrix;
uniform mat4 m_Tool2Matrix;
uniform mat4 m_Tool3Matrix;
uniform mat4 m_Tool4Matrix;
uniform mat4 m_Tool5Matrix;
uniform mat4 m_Tool6Matrix;
uniform mat4 m_Tool7Matrix;

uniform sampler2D m_Tool0Texture2D;
uniform sampler2D m_Tool1Texture2D;
uniform sampler2D m_Tool2Texture2D;
uniform sampler2D m_Tool3Texture2D;
uniform sampler2D m_Tool4Texture2D;
uniform sampler2D m_Tool5Texture2D;
uniform sampler2D m_Tool6Texture2D;
uniform sampler2D m_Tool7Texture2D;

uniform float[] m_Tool0;
uniform float[] m_Tool1;
uniform float[] m_Tool2;
uniform float[] m_Tool3;
uniform float[] m_Tool4;
uniform float[] m_Tool5;
uniform float[] m_Tool6;
uniform float[] m_Tool7;

varying vec3 myNormal;
varying vec3 myPosition;

const vec3 vertical = vec3(0.0, 0.0, 1.0);

const int NUMBER_OF_TOOLS 	 = 8;

const int TOOL_ENABLED_INDEX = 0;
const int TOOL_TYPE_INDEX    = 1;
const int TOOL_ALPHA_INDEX   = 2;
const int TOOL_PARAM0_INDEX  = 3;

const float TOOL_NONE_TYPE 	 			 = 0.0;
const float TOOL_DISCRETE_SLOPES_TYPE 	 = 1.0;
const float TOOL_GRID_TYPE 	 			 = 2.0;
const float TOOL_CIRCULAR_LINE_TYPE		 = 3.0;
const float TOOL_ANGULAR_TYPE			 = 4.0;
const float TOOL_IMAGE_TYPE			 	 = 5.0;

// ShaderBasedMeshTool END


#ifndef VERTEX_LIGHTING
  uniform vec4 g_LightDirection;
  //varying vec3 vPosition;
  varying vec3 vViewDir;
  varying vec4 vLightDir;
  varying vec3 lightVec;
#else
  varying vec2 vertexLightValues;
#endif

#ifdef DIFFUSEMAP
  uniform sampler2D m_DiffuseMap;
#endif

#ifdef SPECULARMAP
  uniform sampler2D m_SpecularMap;
#endif

#ifdef PARALLAXMAP
  uniform sampler2D m_ParallaxMap;  
#endif
#if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
    uniform float m_ParallaxHeight;
#endif

#ifdef LIGHTMAP
  uniform sampler2D m_LightMap;
#endif
  
#ifdef NORMALMAP
  uniform sampler2D m_NormalMap;   
#else
  varying vec3 vNormal;
#endif

#ifdef ALPHAMAP
  uniform sampler2D m_AlphaMap;
#endif

#ifdef COLORRAMP
  uniform sampler2D m_ColorRamp;
#endif

uniform float m_AlphaDiscardThreshold;

#ifndef VERTEX_LIGHTING
uniform float m_Shininess;

#ifdef HQ_ATTENUATION
uniform vec4 g_LightPosition;
#endif

#ifdef USE_REFLECTION 
    uniform float m_ReflectionPower;
    uniform float m_ReflectionIntensity;
    varying vec4 refVec;

    uniform ENVMAP m_EnvMap;
#endif

float tangDot(in vec3 v1, in vec3 v2){
    float d = dot(v1,v2);
    #ifdef V_TANGENT
        d = 1.0 - d*d;
        return step(0.0, d) * sqrt(d);
    #else
        return d;
    #endif
}

float lightComputeDiffuse(in vec3 norm, in vec3 lightdir, in vec3 viewdir){
    #ifdef MINNAERT
        float NdotL = max(0.0, dot(norm, lightdir));
        float NdotV = max(0.0, dot(norm, viewdir));
        return NdotL * pow(max(NdotL * NdotV, 0.1), -1.0) * 0.5;
    #else
        return max(0.0, dot(norm, lightdir));
    #endif
}

float lightComputeSpecular(in vec3 norm, in vec3 viewdir, in vec3 lightdir, in float shiny){
    // NOTE: check for shiny <= 1 removed since shininess is now 
    // 1.0 by default (uses matdefs default vals)
    #ifdef LOW_QUALITY
       // Blinn-Phong
       // Note: preferably, H should be computed in the vertex shader
       vec3 H = (viewdir + lightdir) * vec3(0.5);
       return pow(max(tangDot(H, norm), 0.0), shiny);
    #elif defined(WARDISO)
        // Isotropic Ward
        vec3 halfVec = normalize(viewdir + lightdir);
        float NdotH  = max(0.001, tangDot(norm, halfVec));
        float NdotV  = max(0.001, tangDot(norm, viewdir));
        float NdotL  = max(0.001, tangDot(norm, lightdir));
        float a      = tan(acos(NdotH));
        float p      = max(shiny/128.0, 0.001);
        return NdotL * (1.0 / (4.0*3.14159265*p*p)) * (exp(-(a*a)/(p*p)) / (sqrt(NdotV * NdotL)));
    #else
       // Standard Phong
       vec3 R = reflect(-lightdir, norm);
       return pow(max(tangDot(R, viewdir), 0.0), shiny);
    #endif
}

vec2 computeLighting(in vec3 wvNorm, in vec3 wvViewDir, in vec3 wvLightDir){
   float diffuseFactor = lightComputeDiffuse(wvNorm, wvLightDir, wvViewDir);
   float specularFactor = lightComputeSpecular(wvNorm, wvViewDir, wvLightDir, m_Shininess);

   #ifdef HQ_ATTENUATION
    float att = clamp(1.0 - g_LightPosition.w * length(lightVec), 0.0, 1.0);
   #else
    float att = vLightDir.w;
   #endif

   if (m_Shininess <= 1.0) {
       specularFactor = 0.0; // should be one instruction on most cards ..
   }

   specularFactor *= diffuseFactor;

   return vec2(diffuseFactor, specularFactor) * vec2(att);
}
#endif

//-------------------------------------------------------------------------

vec4 slopesColor(vec3 normal, float slope1Min, float slope1Max, vec3 color1, float slope2Min, float slope2Max, vec3 color2, float slope3Min, float slope3Max, vec3 color3) 
{
	float angle = abs(acos(dot(normal, vec3(0.0, 0.0, 1.0))));		
	
	vec4 slopeColor = vec4(0.0, 0.0, 0.0, 0.0);
								
	if(slope1Min >= 0.0 && slope1Max >= 0.0)
	{						
		if(angle >= slope1Min && angle < slope1Max)
		{
			slopeColor = vec4(color1, 1.0);
		}
	}
	  	
	if(slope2Min >= 0.0 && slope2Max >= 0.0)
	{						
		if(angle >= slope2Min && angle < slope2Max)
		{
			slopeColor = vec4(color2, 1.0);
		}  	
	}
	
	if(slope3Min >= 0.0 && slope3Min >= 0.0)
	{
		if(angle >= slope3Min && angle < slope3Max)
		{
			slopeColor = vec4(color3, 1.0);  
		}  	
	}
        
    return slopeColor;    
}

//-------------------------------------------------------------------------

vec4 gridColor(vec3 position, mat4 matrix, vec3 lineColor, float showX, float deltaX, float xMin, float xMax, float showY, float deltaY, float yMin, float yMax, float lineWidth)
{
	vec4 gridColor = vec4(0.0, 0.0, 0.0, 0.0);	
	
	// Apply transform to the point
	vec4 point = matrix * vec4(position.x, position.y, position.z, 1.0);
		
	float dX  = fract( abs(point.x / deltaX) );
	if(dX > 0.5) dX = 1.0 - dX;
	dX = dX * deltaX;
		
	float dY  = fract( abs(point.y / deltaY) );
	if(dY > 0.5) dY = 1.0 - dY;
	dY = dY * deltaY;
	
	if( (point.x >= xMin && point.x <= xMax) && (point.y >= yMin && point.y <= yMax) )
	{	
		if(dX <= (lineWidth / 2.0) && (showX > 0.0))
		{
			gridColor = vec4(lineColor, 1.0);
		}
		
		if(dY <= (lineWidth / 2.0) && (showY > 0.0))
		{
			gridColor = vec4(lineColor, 1.0);
		}	
	}
	
	return gridColor;
}

//-------------------------------------------------------------------------
vec4 angularToolColor(vec3 position, mat4 matrix, vec3 lineColor, float minRadius, float maxRadius, float startAngle, float endAngle, float angleInterval, float lineWidth)
{				
	// Apply transform to the point
	vec4 point = matrix * vec4(position.x, position.y, position.z, 1.0);
		
	float stopAngle = endAngle;
	float theta = startAngle;
	
	if(startAngle > endAngle)
	{
			stopAngle =  endAngle + 2.0 * 3.14159265;						
	}

	vec2 vector = vec2(point.x, point.y);
	while(theta < stopAngle)
	{								
		// Generate ray line,								
		vec2 ray = vec2(maxRadius * cos(theta), maxRadius * sin(theta));
			
		// Computes projection of vector on the ray.
		float angleBetween = acos(dot(ray, vector) / (length(ray) * length(vector)) );			
		float proj = length(vector) * cos(angleBetween);
										
		if(proj >= minRadius && proj <= maxRadius)
		{
			// Compute how far the point is to the ray line.
			float dist = length(vector) * sin(angleBetween);
			if(dist <= (lineWidth / 2.0))
			{				
				return vec4(lineColor, 1.0);;
			}
		}
										
		// Increment theta
		theta += angleInterval;
	}
	return vec4(0.0, 0.0, 0.0, 0.0);	
}

//-------------------------------------------------------------------------

vec4 projectedImageColor(vec3 position, mat4 matrix, float xDimension, float yDimension, sampler2D image, vec3 transparentColor)
{
	vec4 imageColor = vec4(0.0, 0.0, 0.0, 0.0);
	vec4 point = matrix * vec4(position.x, position.y, position.z, 1.0);	

	float u = (point.x + (xDimension / 2.0)) / xDimension;
	float v = (point.y + (yDimension / 2.0)) / yDimension;

	// Check image is visible.
	if(xDimension > 0.0 && yDimension > 0.0)
	{
		if( (0.0 <= u) && (u <= 1.0) )
		{
			if( (0.0 <= v) && (v <= 1.0)  )
			{
				// Sample the texture.				
				vec2 texCoord = vec2(u, v);
				imageColor = texture2D(image, texCoord);	
				
				// White is set to transparent.
				if(imageColor.r == transparentColor.r && imageColor.g == transparentColor.g && imageColor.b == transparentColor.b)
				{
					imageColor = vec4(0.0, 0.0, 0.0, 0.0);
				}			
			}
		}		
	}
	
	return imageColor;
}

//-------------------------------------------------------------------------

vec4 circularLineColor(vec3 position,  mat4 matrix, float radiusInterval, float maxRadius, float lineWidth, vec3 lineColor)
{
	vec4 circleColor = vec4(0.0, 0.0, 0.0, 0.0);
	
	vec4 point = matrix * vec4(position.x, position.y, position.z, 1.0);	
	vec3 flattenPosition = vec3(point.x, point.y, 0.0);		
	float r = length(flattenPosition);
	
	if(r <= maxRadius)
	{
		float dR  = fract( abs(r / radiusInterval) );
		if(dR > 0.5) dR = 1.0 - dR;
		dR = dR * radiusInterval;
							
		if(dR <= (lineWidth / 2.0))
		{
			circleColor = vec4(lineColor, 1.0);
		}
	}
	
	return circleColor;
}

//-------------------------------------------------------------------------

float getToolEnableParameter(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_ENABLED_INDEX];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_ENABLED_INDEX];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_ENABLED_INDEX];
    }
  
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolAlphaParameter(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_ALPHA_INDEX];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_ALPHA_INDEX];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_ALPHA_INDEX];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolTypeParameter(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_TYPE_INDEX];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_TYPE_INDEX];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_TYPE_INDEX];
    }
    
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter0(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX];
    }    
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX];
    }
        
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter1(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 1];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 1];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 1];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter2(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 2];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 2];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 2];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter3(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 3];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 3];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 3];
    }
      
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter4(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 4];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 4];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 4];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter5(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 5];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 5];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 5];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter6(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 6];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 6];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 6];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter7(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 7];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 7];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 7];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter8(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 8];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 8];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 8];
    }
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter9(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 9];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 9];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 9];
    }   
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter10(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 10];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 10];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 10];
    }       
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter11(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 11];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 11];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 11];
    }       
     
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter12(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 12];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 12];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 12];
    }          
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter13(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 13];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 13];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 13];
    }       
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter14(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 14];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 14];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 14];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter15(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 15];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 15];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 15];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 15];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 15];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 15];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 15];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 15];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter16(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 16];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 16];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 16];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 16];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 16];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 16];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 16];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 16];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter17(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 17];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 17];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 17];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 17];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 17];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 17];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 17];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 17];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter18(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 18];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 18];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 18];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter19(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 19];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 19];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 19];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 19];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 19];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 19];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 18];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 19];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

float getToolParameter20(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 20];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 20];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 20];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 20];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 20];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 20];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 20];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 20];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter21(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 21];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 21];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 21];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 21];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 21];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 21];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 21];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 21];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

float getToolParameter22(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 22];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 22];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 22];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 22];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 22];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 22];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 22];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 22];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

float getToolParameter23(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 23];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 23];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 23];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 23];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 23];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 23];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 23];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 23];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

float getToolParameter24(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 24];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 24];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 24];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 24];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 24];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 24];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 24];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 24];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

float getToolParameter25(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 25];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 25];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 25];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 25];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 25];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 25];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 25];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 25];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter26(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 26];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 26];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 26];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 26];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 26];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 26];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 26];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 26];
    }       
    
    return 0.0;
}

//-------------------------------------------------------------------------

float getToolParameter27(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0[TOOL_PARAM0_INDEX + 27];    	
    }
    else if(toolIndex == 1)
    {
    	return m_Tool1[TOOL_PARAM0_INDEX + 27];
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2[TOOL_PARAM0_INDEX + 27];
    }
     else if(toolIndex == 3)
    {
    	return m_Tool3[TOOL_PARAM0_INDEX + 27];
    }
    else if(toolIndex == 4)
    {
    	return m_Tool4[TOOL_PARAM0_INDEX + 27];
    }
    else if(toolIndex == 5)
    {
    	return m_Tool5[TOOL_PARAM0_INDEX + 27];
    }
    else if(toolIndex == 6)
    {
    	return m_Tool6[TOOL_PARAM0_INDEX + 27];
    }
    else if(toolIndex == 7)
    {
    	return m_Tool7[TOOL_PARAM0_INDEX + 27];
    }       
    
    return 0.0;
}
//-------------------------------------------------------------------------

mat4 getToolMatrix(int toolIndex)
{
	if(toolIndex == 0)
    {
    	return m_Tool0Matrix;    	
    }	
    else if(toolIndex == 1)
    {
    	return m_Tool1Matrix;    	
    }
    else if(toolIndex == 2)
    {
    	return m_Tool2Matrix;    	
    }		   
    else if(toolIndex == 3)
    {
    	return m_Tool3Matrix;    	
    }		   
    else if(toolIndex == 4)
    {
    	return m_Tool4Matrix;    	
    }		   
    else if(toolIndex == 5)
    {
    	return m_Tool5Matrix;    	
    }		   
    else if(toolIndex == 6)
    {
    	return m_Tool6Matrix;    	
    }		   
    else if(toolIndex == 7)
    {
    	return m_Tool7Matrix;    	
    }		   
    		       
	return mat4(1.0, 0.0, 0.0, 0.0,
				0.0, 1.0, 0.0, 0.0,
    			0.0, 0.0, 1.0, 0.0,
    			0.0, 0.0, 0.0, 1.0); 
}
//-------------------------------------------------------------------------

void main()
{
    vec2 newTexCoord;
     
    #if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING) 
     
       #ifdef STEEP_PARALLAX
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map         
               newTexCoord = steepParallaxOffset(m_NormalMap, vViewDir, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = steepParallaxOffset(m_ParallaxMap, vViewDir, texCoord, m_ParallaxHeight);         
           #endif
       #else
           #ifdef NORMALMAP_PARALLAX
               //parallax map is stored in the alpha channel of the normal map         
               newTexCoord = classicParallaxOffset(m_NormalMap, vViewDir, texCoord, m_ParallaxHeight);
           #else
               //parallax map is a texture
               newTexCoord = classicParallaxOffset(m_ParallaxMap, vViewDir, texCoord, m_ParallaxHeight);
           #endif
       #endif
    #else
       newTexCoord = texCoord;    
    #endif
    
   #ifdef DIFFUSEMAP
      vec4 diffuseColor = texture2D(m_DiffuseMap, newTexCoord);
    #else
      vec4 diffuseColor = vec4(1.0);
    #endif

    float alpha = DiffuseSum.a * diffuseColor.a;
    #ifdef ALPHAMAP
       alpha = alpha * texture2D(m_AlphaMap, newTexCoord).r;
    #endif
    if(alpha < m_AlphaDiscardThreshold){
        discard;
    }

    #ifndef VERTEX_LIGHTING
        float spotFallOff = 1.0;

        #if __VERSION__ >= 110
          // allow use of control flow
          if(g_LightDirection.w != 0.0){
        #endif

          vec3 L       = normalize(lightVec.xyz);
          vec3 spotdir = normalize(g_LightDirection.xyz);
          float curAngleCos = dot(-L, spotdir);             
          float innerAngleCos = floor(g_LightDirection.w) * 0.001;
          float outerAngleCos = fract(g_LightDirection.w);
          float innerMinusOuter = innerAngleCos - outerAngleCos;
          spotFallOff = (curAngleCos - outerAngleCos) / innerMinusOuter;

          #if __VERSION__ >= 110
              if(spotFallOff <= 0.0){
                  gl_FragColor.rgb = AmbientSum * diffuseColor.rgb;
                  gl_FragColor.a   = alpha;
                  return;
              }else{
                  spotFallOff = clamp(spotFallOff, 0.0, 1.0);
              }
             }
          #else
             spotFallOff = clamp(spotFallOff, step(g_LightDirection.w, 0.001), 1.0);
          #endif
     #endif
 
    // ***********************
    // Read from textures
    // ***********************
    #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
      vec4 normalHeight = texture2D(m_NormalMap, newTexCoord);
      //Note the -2.0 and -1.0. We invert the green channel of the normal map, 
      //as it's complient with normal maps generated with blender.
      //see http://hub.jmonkeyengine.org/forum/topic/parallax-mapping-fundamental-bug/#post-256898
      //for more explanation.
      vec3 normal = normalize((normalHeight.xyz * vec3(2.0,-2.0,2.0) - vec3(1.0,-1.0,1.0)));
      #ifdef LATC
        normal.z = sqrt(1.0 - (normal.x * normal.x) - (normal.y * normal.y));
      #endif      
    #elif !defined(VERTEX_LIGHTING)
      vec3 normal = vNormal;
      #if !defined(LOW_QUALITY) && !defined(V_TANGENT)
         normal = normalize(normal);
      #endif
    #endif

    #ifdef SPECULARMAP
      vec4 specularColor = texture2D(m_SpecularMap, newTexCoord);
    #else
      vec4 specularColor = vec4(1.0);
    #endif

    #ifdef LIGHTMAP
       vec3 lightMapColor;
       #ifdef SEPARATE_TEXCOORD
          lightMapColor = texture2D(m_LightMap, texCoord2).rgb;
       #else
          lightMapColor = texture2D(m_LightMap, texCoord).rgb;
       #endif
       specularColor.rgb *= lightMapColor;
       diffuseColor.rgb  *= lightMapColor;
    #endif

    #ifdef VERTEX_LIGHTING
       vec2 light = vertexLightValues.xy;
       #ifdef COLORRAMP
           light.x = texture2D(m_ColorRamp, vec2(light.x, 0.0)).r;
           light.y = texture2D(m_ColorRamp, vec2(light.y, 0.0)).r;
       #endif

       gl_FragColor.rgb =  AmbientSum     * diffuseColor.rgb + 
                           DiffuseSum.rgb * diffuseColor.rgb  * vec3(light.x) +
                           SpecularSum    * specularColor.rgb * vec3(light.y);
    #else
       vec4 lightDir = vLightDir;
       lightDir.xyz = normalize(lightDir.xyz);
       vec3 viewDir = normalize(vViewDir);

       vec2   light = computeLighting(normal, viewDir, lightDir.xyz) * spotFallOff;
       #ifdef COLORRAMP
           diffuseColor.rgb  *= texture2D(m_ColorRamp, vec2(light.x, 0.0)).rgb;
           specularColor.rgb *= texture2D(m_ColorRamp, vec2(light.y, 0.0)).rgb;
       #endif

       // Workaround, since it is not possible to modify varying variables
       vec4 SpecularSum2 = vec4(SpecularSum, 1.0);
       #ifdef USE_REFLECTION
            vec4 refColor = Optics_GetEnvColor(m_EnvMap, refVec.xyz);

            // Interpolate light specularity toward reflection color
            // Multiply result by specular map
            specularColor = mix(SpecularSum2 * light.y, refColor, refVec.w) * specularColor;

            SpecularSum2 = vec4(1.0);
            light.y = 1.0;
       #endif

       gl_FragColor.rgb =  AmbientSum       * diffuseColor.rgb  +
                           DiffuseSum.rgb   * diffuseColor.rgb  * vec3(light.x) +
                           SpecularSum2.rgb * specularColor.rgb * vec3(light.y);
    #endif
    gl_FragColor.a = alpha;
        
    // Experimental             
                             	              		
    // Process each tool.
    float tool_enable		= 0.0;
    float tool_alpha  		= 0.0;
    float tool_type  		= 0.0;
    
    // Tool matrx representing the tool position relative to the mesh.
    mat4  toolMatrix        = mat4(1.0, 0.0, 0.0, 0.0,
    							   0.0, 1.0, 0.0, 0.0,
    							   0.0, 0.0, 1.0, 0.0,
    							   0.0, 0.0, 0.0, 1.0);   
    
    // Tool parameters.
    float tool_param_0	= 0.0;
    float tool_param_1 	= 0.0;
    float tool_param_2 	= 0.0;
    float tool_param_3 	= 0.0;
    float tool_param_4 	= 0.0;
    float tool_param_5 	= 0.0;
    float tool_param_6 	= 0.0;
    float tool_param_7 	= 0.0;
    float tool_param_8 	= 0.0;
    float tool_param_9 	= 0.0;
    float tool_param_10	= 0.0;
    float tool_param_11	= 0.0;
    float tool_param_12	= 0.0;
    float tool_param_13	= 0.0;
    float tool_param_14	= 0.0;
    float tool_param_15	= 0.0;
    
    // Color produced by the tool being processed.                     
    vec4 toolColor = vec4(0.0, 0.0, 0.0, 0.0);
    
   	vec4 toolsColors[NUMBER_OF_TOOLS] = vec4[NUMBER_OF_TOOLS](vec4(0.0), vec4(0.0), vec4(0.0), vec4(0.0), vec4(0.0), vec4(0.0), vec4(0.0), vec4(0.0));
   	float[NUMBER_OF_TOOLS] toolsAlphas = float[NUMBER_OF_TOOLS](0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                 
    float enabledToolCount = 0.0;                 
    for(int i = 0; i < NUMBER_OF_TOOLS; i++)
    {
    	// Clear previous tool color.
    	toolColor = vec4(0.0, 0.0, 0.0, 0.0);
    
    	// Gets the tool parameters.    	    	
    	tool_enable 	= getToolEnableParameter(i);  
    	tool_alpha 		= getToolAlphaParameter(i);  	
    	tool_type		= getToolTypeParameter(i);
    	    	    	    	
    	tool_param_0 	= getToolParameter0(i);
    	tool_param_1 	= getToolParameter1(i);
    	tool_param_2 	= getToolParameter2(i);
    	tool_param_3 	= getToolParameter3(i);
    	tool_param_4 	= getToolParameter4(i);
    	tool_param_5 	= getToolParameter5(i);
    	tool_param_6 	= getToolParameter6(i);
    	tool_param_7 	= getToolParameter7(i);
    	tool_param_8 	= getToolParameter8(i);
    	tool_param_9 	= getToolParameter9(i);
    	tool_param_10 	= getToolParameter10(i);
    	tool_param_11 	= getToolParameter11(i);
    	tool_param_12 	= getToolParameter12(i);
    	tool_param_13 	= getToolParameter13(i);
    	tool_param_14 	= getToolParameter14(i);
    	tool_param_15 	= getToolParameter15(i);
    	    	   	    	    	    
    	// Records the tool alpha value.		    	   	    	    	
    	toolsAlphas[i] = tool_alpha;
    	    	   	    	    	    	    	    	
    	// If the tool is enabled.
    	if(tool_enable == 1.0)
    	{
    		enabledToolCount += 1.0;
    	
    		// Get the tool matrix.
    		toolMatrix = getToolMatrix(i);
    	    	
    		if(tool_type == TOOL_DISCRETE_SLOPES_TYPE)
    		{
    			float slope1Min = tool_param_0;
    			float slope1Max = tool_param_1;
     			vec3 color1 = vec3(tool_param_2, tool_param_3, tool_param_4);
     			
     			float slope2Min = tool_param_5;
    			float slope2Max = tool_param_6;
     			vec3 color2 = vec3(tool_param_7, tool_param_8, tool_param_9);
    		
    			float slope3Min = tool_param_10;
    			float slope3Max = tool_param_11;
     			vec3 color3 = vec3(tool_param_12, tool_param_13, tool_param_14);
 
 				toolColor = slopesColor(myNormal, slope1Min, slope1Max, color1, slope2Min, slope2Max, color2, slope3Min, slope3Max, color3); 							      		
    		}
    		
    		if(tool_type == TOOL_GRID_TYPE)
    		{
    			vec3 gridLineColor = vec3(tool_param_0,tool_param_1,tool_param_2);
    			float showX = tool_param_3;    			
    			float deltaX = tool_param_4;
    			float xMin = tool_param_5;
    			float xMax = tool_param_6;
    			
    			float showY = tool_param_7;
    			float deltaY = tool_param_8;    			
    			float yMin = tool_param_9;
    			float yMax = tool_param_10;
    			
    			float lineWidth = tool_param_11;    		
    			
    			toolColor = gridColor(myPosition, toolMatrix, gridLineColor, showX, deltaX, xMin, xMax, showY, deltaY, yMin, yMax, lineWidth);    					    			    		
    		}
    		
    		if(tool_type == TOOL_CIRCULAR_LINE_TYPE)
    		{   
    			vec3 circleLineColor = vec3(tool_param_0,tool_param_1,tool_param_2);
    		 		 	
    		 	float radiusInterval = tool_param_3;
    		 	float maxRadius = tool_param_4;
    		 	float lineWidth = tool_param_5;    		 	
    		 	    		 	    		
    		 	toolColor = circularLineColor(myPosition, toolMatrix, radiusInterval, maxRadius, lineWidth, circleLineColor);    		 	    		 								    		     		 	    		 								     				        			
    		}
    		
    		if(tool_type == TOOL_ANGULAR_TYPE)
    		{
    		 	vec3 lineColor = vec3(tool_param_0,tool_param_1,tool_param_2);
    		 	float minRadius = tool_param_3;
    		 	float maxRadius = tool_param_4;
    		 	float startAngle =  tool_param_5;
    		 	float endAngle =  tool_param_6;
    		 	float angleInterval =  tool_param_7;
    		 	float lineWidth = tool_param_8;
    		 	
				toolColor = angularToolColor(myPosition, toolMatrix, lineColor, minRadius, maxRadius, startAngle, endAngle, angleInterval, lineWidth);    		 		 								    		     		 	    		 								     				        			
    		}
    		
    		if(tool_type == TOOL_IMAGE_TYPE)
    		{
    			float xDimension = tool_param_0;
    			float yDimension = tool_param_1;
    			vec3 transparentColor = vec3(tool_param_2,tool_param_3,tool_param_4);
    			
    			if(i == 0)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool0Texture2D, transparentColor);	
			    }	
			    else if(i == 1)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool1Texture2D, transparentColor);		
			    }
			    else if(i == 2)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool2Texture2D, transparentColor);	
			    }		   
			    else if(i == 3)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool3Texture2D, transparentColor);	
			    }		   
			    else if(i == 4)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool4Texture2D, transparentColor);	
			    }		   
			    else if(i == 5)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool5Texture2D, transparentColor);	
			    }		   
			    else if(i == 6)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool6Texture2D, transparentColor);	  	
			    }		   
			    else if(i == 7)
			    {
			    	toolColor = projectedImageColor(myPosition, toolMatrix, xDimension, yDimension, m_Tool7Texture2D, transparentColor);		
			    }		     			    			    		    		
    		}    		    
    	}
    	else
    	{
    		// Effective tool alpha is zero when tool is disabled.
    		toolsAlphas[i] = 0.0; 
    	}
    	
    	// Records the color produced by the tool.	
    	toolsColors[i] = toolColor;   		    		     	    	
    }
    	    	    		     
	// Computes the color generated by all the tools.
	vec4 color = vec4(0.0, 0.0, 0.0, 0.0);

	if(enabledToolCount > 0.0)
	{
		for(int i =0; i < NUMBER_OF_TOOLS; i++)
		{
			color = color * (1.0 - toolsAlphas[i]) + toolsAlphas[i] * toolsColors[i];
		}    		
		
		if(color.a > 1.0) color.a = 1.0;
					
		gl_FragColor = gl_FragColor * (1.0 - color.a) + color.a * color;
	}
    		    		    		     		    		    	    	                 			    
    // Experimental
}


