//*******************************************************************************
// Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency.
// All rights reserved. This program and the accompanying materials
// are made available under the terms of the Eclipse Public License v1.0
// which accompanies this distribution, and is available at
// http://www.eclipse.org/legal/epl-v10.html
//
// Contributors:
// 	 	 Pierre Allard - initial API and implementation
// 	 	 
// SPDX-License-Identifier: EPL-1.0
//*******************************************************************************
uniform mat4 g_ViewMatrix;
uniform mat4 g_ProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform mat4 g_WorldViewProjectionMatrix;
uniform mat3 g_NormalMatrix;
uniform vec3 m_NormalScale;

attribute vec3 inPosition;
attribute vec3 inNormal;

varying vec3 normal;
varying vec3 position;

void main()
{   	
  	normal = vec3(inNormal);
  	normal = normalize(normal);
  	
  	position = inPosition;
  	
  	gl_Position = g_WorldViewProjectionMatrix * vec4(inPosition, 1.0);
}
