/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.jme3;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import org.eclipse.apogy.addons.telecoms.AbstractAntennaRadiationPattern;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;

public class JME3TelecomsUtilities {
    private static JME3TelecomsUtilities instance = new JME3TelecomsUtilities();

    public static Mesh createAntennaPattern(AbstractAntennaRadiationPattern antennaPattern) {
        Mesh mesh = null;
        try {
            ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
            ArrayList<Integer> indexesList = new ArrayList<Integer>();
            ArrayList<Vector3f> normalslList = new ArrayList<Vector3f>();
            double thetaIncrement = Math.toRadians(2.0);
            double phiIncrement = Math.toRadians(10.0);
            GainLimits gainLimits = JME3TelecomsUtilities.getGainLimits(antennaPattern, thetaIncrement, phiIncrement);
            double theta = 0.0;
            int verticeIndex = 0;
            while (theta <= Math.PI) {
                double phi = -Math.PI;
                while (phi <= Math.PI) {
                    double gain0 = antennaPattern.computeGain(theta, phi);
                    double r0 = JME3TelecomsUtilities.computeRadius(gain0, gainLimits);
                    float x0 = (float)(r0 * Math.sin(theta) * Math.cos(phi));
                    float y0 = (float)(r0 * Math.sin(theta) * Math.sin(phi));
                    float z0 = (float)(r0 * Math.cos(theta));
                    Vector3f p0 = new Vector3f(x0, y0, z0);
                    double theta1 = theta + thetaIncrement;
                    double phi1 = phi;
                    double gain1 = antennaPattern.computeGain(theta1, phi1);
                    double r1 = JME3TelecomsUtilities.computeRadius(gain1, gainLimits);
                    float x1 = (float)(r1 * Math.sin(theta1) * Math.cos(phi1));
                    float y1 = (float)(r1 * Math.sin(theta1) * Math.sin(phi1));
                    float z1 = (float)(r1 * Math.cos(theta1));
                    Vector3f p1 = new Vector3f(x1, y1, z1);
                    double theta2 = theta + thetaIncrement;
                    double phi2 = phi + phiIncrement;
                    double gain2 = antennaPattern.computeGain(theta2, phi2);
                    double r2 = JME3TelecomsUtilities.computeRadius(gain2, gainLimits);
                    float x2 = (float)(r2 * Math.sin(theta2) * Math.cos(phi2));
                    float y2 = (float)(r2 * Math.sin(theta2) * Math.sin(phi2));
                    float z2 = (float)(r2 * Math.cos(theta2));
                    Vector3f p2 = new Vector3f(x2, y2, z2);
                    double theta3 = theta;
                    double phi3 = phi + phiIncrement;
                    double gain3 = antennaPattern.computeGain(theta3, phi3);
                    double r3 = JME3TelecomsUtilities.computeRadius(gain3, gainLimits);
                    float x3 = (float)(r3 * Math.sin(theta3) * Math.cos(phi3));
                    float y3 = (float)(r3 * Math.sin(theta3) * Math.sin(phi3));
                    float z3 = (float)(r3 * Math.cos(theta3));
                    Vector3f p3 = new Vector3f(x3, y3, z3);
                    verticesList.add(p0);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(p1);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(p2);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal1 = JME3Utilities.computeTriangleNormal((Vector3f)p0, (Vector3f)p1, (Vector3f)p2);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    normalslList.add(normal1);
                    verticesList.add(p2);
                    indexesList.add(new Integer(verticeIndex));
                    verticesList.add(p3);
                    indexesList.add(new Integer(++verticeIndex));
                    verticesList.add(p0);
                    indexesList.add(new Integer(++verticeIndex));
                    ++verticeIndex;
                    Vector3f normal2 = JME3Utilities.computeTriangleNormal((Vector3f)p2, (Vector3f)p3, (Vector3f)p0);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    normalslList.add(normal2);
                    phi += phiIncrement;
                }
                theta += thetaIncrement;
            }
            mesh = new Mesh();
            mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
            mesh.setBuffer(VertexBuffer.Type.Index, 3, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
            mesh.setBuffer(VertexBuffer.Type.Normal, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(normalslList)));
            mesh.updateBound();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mesh;
    }

    public static GainLimits getGainLimits(AbstractAntennaRadiationPattern antennaPattern, double thetaIncrement, double phiIncrement) {
        GainLimits gainLimits = instance.new GainLimits();
        double theta = 0.0;
        while (theta <= Math.PI) {
            double phi = -Math.PI;
            while (phi <= Math.PI) {
                double gain = antennaPattern.computeGain(theta, phi);
                if (gain > gainLimits.maximumGain) {
                    gainLimits.maximumGain = gain;
                }
                if (gain < gainLimits.minimumGain) {
                    gainLimits.minimumGain = gain;
                }
                phi += phiIncrement;
            }
            theta += thetaIncrement;
        }
        return gainLimits;
    }

    private static double computeRadius(double gain, GainLimits gainLimits) {
        double radius = 1.0;
        if (gainLimits.maximumGain - gainLimits.minimumGain != 0.0) {
            radius = (gain - gainLimits.minimumGain) / (gainLimits.maximumGain - gainLimits.minimumGain);
        }
        return radius;
    }

    public class GainLimits {
        public double minimumGain = Double.POSITIVE_INFINITY;
        public double maximumGain = Double.NEGATIVE_INFINITY;
    }
}

