/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.composites;

import java.text.DecimalFormat;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.OrientationCorrectionMode;
import org.eclipse.apogy.addons.vehicle.VehiclePoseCorrector;
import org.eclipse.apogy.addons.vehicle.ZCorrectionMode;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class VehiclePoseCorrectorComposite
extends Composite {
    public static final String DEGREE_STRING = "\u00b0";
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private VehiclePoseCorrector vehiclePoseCorrector;
    private Adapter orientationCorrectionAdapter;
    private Button btnEnable;
    private Button btnReinitialize;
    private ComboViewer comboZCorrectionMode;
    private ComboViewer comboOrientationCorrectionMode;
    private Text txtZCorrection;
    private Tuple3dComposite orientationCorrectionComposite;
    private final Tuple3d orientationCorrection = ApogyCommonMathFacade.INSTANCE.createTuple3d(0.0, 0.0, 0.0);
    private final DecimalFormat zCorrectionFormat = new DecimalFormat("0.000");
    private DataBindingContext m_bindingContext;

    public VehiclePoseCorrectorComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblEnable = new Label((Composite)this, 0);
        lblEnable.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEnable.setText("Enabled :");
        this.btnEnable = new Button((Composite)this, 32);
        this.btnReinitialize = new Button((Composite)this, 0);
        this.btnReinitialize.setToolTipText("Forces re-initialization of the pose corrector meshes contact geometries.");
        this.btnReinitialize.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnReinitialize.setText("Re-Initialize");
        this.btnReinitialize.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (VehiclePoseCorrectorComposite.this.getVehiclePoseCorrector() != null) {
                    Job job = new Job(""){

                        protected IStatus run(IProgressMonitor monitor) {
                            VehiclePoseCorrectorComposite.this.getVehiclePoseCorrector().reInitialize();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblZCorrectionMode = new Label((Composite)this, 0);
        lblZCorrectionMode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblZCorrectionMode.setText("Z Correction Mode:");
        this.comboZCorrectionMode = new ComboViewer((Composite)this, 0);
        this.comboZCorrectionMode.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.comboZCorrectionMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboZCorrectionMode.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboZCorrectionMode.setInput((Object)ZCorrectionMode.values());
        Label lblOrientationCorrectionMode = new Label((Composite)this, 0);
        lblOrientationCorrectionMode.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOrientationCorrectionMode.setText("Orientation Correction Mode:");
        this.comboOrientationCorrectionMode = new ComboViewer((Composite)this, 0);
        this.comboOrientationCorrectionMode.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.comboOrientationCorrectionMode.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboOrientationCorrectionMode.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.comboOrientationCorrectionMode.setInput((Object)OrientationCorrectionMode.values());
        Label lblCurrentZCorrectionm = new Label((Composite)this, 0);
        lblCurrentZCorrectionm.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCurrentZCorrectionm.setText("Z Correction (m):");
        this.txtZCorrection = new Text((Composite)this, 2048);
        this.txtZCorrection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.txtZCorrection.setEditable(false);
        Label lblCurrentOrientationCorrection = new Label((Composite)this, 0);
        lblCurrentOrientationCorrection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCurrentOrientationCorrection.setText("Orientation Correction (\u00b0):");
        this.orientationCorrectionComposite = new Tuple3dComposite((Composite)this, 0, "0.00");
        GridData gd_orientation = new GridData(4, 0x1000000, true, false, 2, 1);
        gd_orientation.widthHint = 300;
        gd_orientation.minimumWidth = 300;
        this.orientationCorrectionComposite.setLayoutData((Object)gd_orientation);
        this.orientationCorrectionComposite.setEnableEditing(false);
        this.orientationCorrectionComposite.setTuple3d(this.orientationCorrection);
        this.enableControls(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (VehiclePoseCorrectorComposite.this.m_bindingContext != null) {
                    VehiclePoseCorrectorComposite.this.m_bindingContext.dispose();
                }
                if (VehiclePoseCorrectorComposite.this.vehiclePoseCorrector != null) {
                    VehiclePoseCorrectorComposite.this.vehiclePoseCorrector.eAdapters().remove((Object)VehiclePoseCorrectorComposite.this.getOrientationCorrectionAdapter());
                }
            }
        });
    }

    public VehiclePoseCorrector getVehiclePoseCorrector() {
        return this.vehiclePoseCorrector;
    }

    public void setVehiclePoseCorrector(VehiclePoseCorrector vehiclePoseCorrector) {
        if (vehiclePoseCorrector != null) {
            vehiclePoseCorrector.eAdapters().remove((Object)this.getOrientationCorrectionAdapter());
        }
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.vehiclePoseCorrector = vehiclePoseCorrector;
        this.enableControls(vehiclePoseCorrector != null);
        if (vehiclePoseCorrector != null) {
            this.m_bindingContext = this.customInitDataBindings();
            vehiclePoseCorrector.eAdapters().add((Object)this.getOrientationCorrectionAdapter());
        }
    }

    public void enableControls(boolean enabled) {
        if (this.btnEnable != null && !this.btnEnable.isDisposed()) {
            this.btnEnable.setEnabled(enabled);
        }
        if (this.btnReinitialize != null && !this.btnReinitialize.isDisposed()) {
            this.btnReinitialize.setEnabled(enabled);
        }
        if (this.txtZCorrection != null && !this.txtZCorrection.isDisposed()) {
            this.txtZCorrection.setEnabled(enabled);
        }
        if (this.orientationCorrectionComposite != null && !this.orientationCorrectionComposite.isDisposed()) {
            this.orientationCorrectionComposite.setEnabled(enabled);
        }
        if (this.comboZCorrectionMode != null && this.comboZCorrectionMode.getCombo() != null && !this.comboZCorrectionMode.getCombo().isDisposed()) {
            this.comboZCorrectionMode.getControl().setEnabled(enabled);
            this.comboZCorrectionMode.getCombo().setEnabled(enabled);
        }
        if (this.comboOrientationCorrectionMode != null && this.comboOrientationCorrectionMode.getCombo() != null && !this.comboOrientationCorrectionMode.getCombo().isDisposed()) {
            this.comboOrientationCorrectionMode.getControl().setEnabled(enabled);
            this.comboOrientationCorrectionMode.getCombo().setEnabled(enabled);
        }
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeEnabled = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCorePackage.Literals.ABSTRACT_APOGY_SYSTEM_POSE_CORRECTOR__ENABLED})).observe((Object)this.vehiclePoseCorrector);
        ISWTObservableValue observeEnabledButtton = WidgetProperties.selection().observe((Widget)this.btnEnable);
        bindingContext.bindValue((IObservableValue)observeEnabledButtton, observeEnabled, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeZCorrection = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.VEHICLE_POSE_CORRECTOR__ZCORRECTION})).observe((Object)this.vehiclePoseCorrector);
        ISWTObservableValue observeZCorrectionTxt = WidgetProperties.text((int)24).observe((Widget)this.txtZCorrection);
        bindingContext.bindValue((IObservableValue)observeZCorrectionTxt, observeZCorrection, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return VehiclePoseCorrectorComposite.this.zCorrectionFormat.format(fromObject);
            }
        }));
        ISWTObservableValue observeZCorrectionEnable = WidgetProperties.enabled().observe((Widget)this.txtZCorrection);
        bindingContext.bindValue((IObservableValue)observeZCorrectionEnable, observeEnabled, new UpdateValueStrategy(), new UpdateValueStrategy());
        ISWTObservableValue observeOrientationCorrectionEnable = WidgetProperties.enabled().observe((Widget)this.orientationCorrectionComposite);
        bindingContext.bindValue((IObservableValue)observeOrientationCorrectionEnable, observeEnabled, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeZCorrectionMode = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.VEHICLE_POSE_CORRECTOR__ZCORRECTION_MODE})).observe((Object)this.vehiclePoseCorrector);
        IViewerObservableValue observeZCorrectionModeCombViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboZCorrectionMode);
        bindingContext.bindValue((IObservableValue)observeZCorrectionModeCombViewer, observeZCorrectionMode, new UpdateValueStrategy(), new UpdateValueStrategy());
        IObservableValue observeOrientationCorrectionMode = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.VEHICLE_POSE_CORRECTOR__ORIENTATION_CORRECTION_MODE})).observe((Object)this.vehiclePoseCorrector);
        IViewerObservableValue observeOrientationCorrectionModeComboViewer = ViewerProperties.singleSelection().observe((Viewer)this.comboOrientationCorrectionMode);
        bindingContext.bindValue((IObservableValue)observeOrientationCorrectionModeComboViewer, observeOrientationCorrectionMode, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }

    protected Adapter getOrientationCorrectionAdapter() {
        if (this.orientationCorrectionAdapter == null) {
            this.orientationCorrectionAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureID;
                    if (msg.getNotifier() instanceof VehiclePoseCorrector && (featureID = msg.getFeatureID(VehiclePoseCorrector.class)) == 7 && msg.getNewValue() instanceof Matrix3x3) {
                        Matrix3x3 rot = (Matrix3x3)msg.getNewValue();
                        Vector3d r = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rot.asMatrix3d());
                        VehiclePoseCorrectorComposite.this.orientationCorrection.setX(Math.toDegrees(r.x));
                        VehiclePoseCorrectorComposite.this.orientationCorrection.setY(Math.toDegrees(r.y));
                        VehiclePoseCorrectorComposite.this.orientationCorrection.setZ(Math.toDegrees(r.z));
                    }
                }
            };
        }
        return this.orientationCorrectionAdapter;
    }
}

