/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.powersystems.edit;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.powersystems.Motor;
import org.eclipse.apogy.addons.powersystems.provider.MotorItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class MotorCustomItemProvider
extends MotorItemProvider {
    public static final double RADS_PER_SEC_TO_RPM = 9.5493;
    private DecimalFormat decimalFormat = new DecimalFormat("0.000");

    public MotorCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        Motor motor = (Motor)object;
        String label = motor.getName();
        if (label == null || label.length() == 0) {
            label = this.getString("_UI_Motor_type");
        }
        label = String.valueOf(label) + " (";
        label = String.valueOf(label) + this.getSuffix(motor);
        label = String.valueOf(label) + ")";
        return label;
    }

    protected String getSuffix(Motor motor) {
        String suffix = String.valueOf(this.decimalFormat.format(motor.getRequiredPower())) + "W, ";
        suffix = String.valueOf(suffix) + this.decimalFormat.format(motor.getAngularvelocity() * 9.5493) + " RPM, ";
        suffix = String.valueOf(suffix) + this.decimalFormat.format(motor.getTorque()) + " Nm";
        return suffix;
    }
}

