/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.robotic_arm.ros;

import org.eclipse.apogy.examples.robotic_arm.MoveSpeedLevel;
import org.eclipse.apogy.examples.robotic_arm.RoboticArm;
import org.eclipse.apogy.examples.robotic_arm.ros.MoveSpeed;
import org.eclipse.apogy.examples.robotic_arm.ros.RoboticArmTelemetry;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdInitRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdInitResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdMoveToRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdMoveToResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdSpeedLevelRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdSpeedLevelResponse;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdStowRequest;
import org.eclipse.apogy.examples.robotic_arm.ros.cmdStowResponse;
import org.ros.exception.ServiceException;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.Node;
import org.ros.node.service.ServiceResponseBuilder;
import org.ros.node.topic.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoboticArmROSServer
extends AbstractNodeMain {
    private static final Logger Logger = LoggerFactory.getLogger(RoboticArmROSServer.class);
    protected RoboticArm roboticArm = null;
    protected Publisher<RoboticArmTelemetry> telemetryPublisher = null;
    protected boolean telemetryShouldRun = true;
    protected Thread telemetryThread = null;
    protected ConnectedNode rosNode;

    public RoboticArmROSServer(RoboticArm roboticArm) {
        this.roboticArm = roboticArm;
    }

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)"roboticArmServer");
    }

    public void onStart(ConnectedNode connectedNode) {
        this.rosNode = connectedNode;
        this.initializeTopics();
        this.initializeServices();
        this.telemetryShouldRun = true;
        this.telemetryThread = new Thread(this.getTelemetryRunnable());
        this.telemetryThread.start();
    }

    public void onShutdown(Node node) {
        this.telemetryShouldRun = false;
        this.rosNode.shutdown();
        super.onShutdown(node);
    }

    private void initializeTopics() {
        Logger.info("Initializing topics...");
        this.telemetryPublisher = this.rosNode.newPublisher("/roboticArm/Telemetry", "org.eclipse.apogy.examples.robotic_arm.ros/RoboticArmTelemetry");
    }

    private void initializeServices() {
        Logger.info("Initializing services...");
        Logger.info("Initializing /roboticArm/cmdInit service...");
        this.rosNode.newServiceServer("/roboticArm/cmdInit", "org.eclipse.apogy.examples.robotic_arm.ros/cmdInit", (ServiceResponseBuilder)new ServiceResponseBuilder<cmdInitRequest, cmdInitResponse>(){

            public void build(cmdInitRequest request, cmdInitResponse response) throws ServiceException {
                Logger.info("------------>RoboticArmROSServer.init()");
                RoboticArmROSServer.this.roboticArm.init();
                response.setResult(true);
            }
        });
        Logger.info("Initializing /roboticArm/cmdMoveTo service...");
        this.rosNode.newServiceServer("/roboticArm/cmdMoveTo", "org.eclipse.apogy.examples.robotic_arm.ros/cmdMoveTo", (ServiceResponseBuilder)new ServiceResponseBuilder<cmdMoveToRequest, cmdMoveToResponse>(){

            public void build(cmdMoveToRequest request, cmdMoveToResponse response) throws ServiceException {
                double turretAngle = Math.toDegrees(request.getTurretAngle());
                double shoulderAngle = Math.toDegrees(request.getShoulderAngle());
                double elbowAngle = Math.toDegrees(request.getElbowAngle());
                double wristAngle = Math.toDegrees(request.getWristAngle());
                RoboticArmROSServer.this.roboticArm.moveTo(turretAngle, shoulderAngle, elbowAngle, wristAngle);
                response.setResult(true);
            }
        });
        Logger.info("Initializing /roboticArm/cmdStow service...");
        this.rosNode.newServiceServer("/roboticArm/cmdStow", "org.eclipse.apogy.examples.robotic_arm.ros/cmdStow", (ServiceResponseBuilder)new ServiceResponseBuilder<cmdStowRequest, cmdStowResponse>(){

            public void build(cmdStowRequest request, cmdStowResponse response) throws ServiceException {
                RoboticArmROSServer.this.roboticArm.stow();
                response.setResult(true);
            }
        });
        Logger.info("Initializing /roboticArm/cmdMoveSpeed service...");
        this.rosNode.newServiceServer("/roboticArm/cmdMoveSpeed", "org.eclipse.apogy.examples.robotic_arm.ros/cmdSpeedLevel", (ServiceResponseBuilder)new ServiceResponseBuilder<cmdSpeedLevelRequest, cmdSpeedLevelResponse>(){

            public void build(cmdSpeedLevelRequest request, cmdSpeedLevelResponse response) throws ServiceException {
                RoboticArmROSServer.this.roboticArm.setSpeed(MoveSpeedLevel.get((int)request.getSpeed().getSpeedStatus()));
                response.setResult(true);
            }
        });
    }

    private Runnable getTelemetryRunnable() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Logger.info("Robotic Arm ROS Server : Telemetry Update starts.");
                while (RoboticArmROSServer.this.telemetryShouldRun) {
                    RoboticArmTelemetry roboticArmTelemetry = (RoboticArmTelemetry)RoboticArmROSServer.this.rosNode.getTopicMessageFactory().newFromType("org.eclipse.apogy.examples.robotic_arm.ros/RoboticArmTelemetry");
                    roboticArmTelemetry.setElbowAngle((float)Math.toRadians(RoboticArmROSServer.this.roboticArm.getElbowAngle()));
                    roboticArmTelemetry.setShoulderAngle((float)Math.toRadians(RoboticArmROSServer.this.roboticArm.getShoulderAngle()));
                    roboticArmTelemetry.setTurretAngle((float)Math.toRadians(RoboticArmROSServer.this.roboticArm.getTurretAngle()));
                    roboticArmTelemetry.setWristAngle((float)Math.toRadians(RoboticArmROSServer.this.roboticArm.getWristAngle()));
                    roboticArmTelemetry.setMoving(RoboticArmROSServer.this.roboticArm.isArmMoving());
                    MoveSpeed moveSpeed = (MoveSpeed)RoboticArmROSServer.this.rosNode.getTopicMessageFactory().newFromType("org.eclipse.apogy.examples.robotic_arm.ros/MoveSpeed");
                    moveSpeed.setSpeedStatus((byte)RoboticArmROSServer.this.roboticArm.getSpeed().getValue());
                    roboticArmTelemetry.setSpeed(moveSpeed);
                    RoboticArmROSServer.this.telemetryPublisher.publish((Object)roboticArmTelemetry);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        RoboticArmROSServer.this.telemetryShouldRun = false;
                    }
                }
            }
        };
        return runnable;
    }
}

