/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.obstacles.apogy.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.TransformNode;
import org.eclipse.apogy.common.topology.URLNode;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.examples.obstacles.ApogyExamplesObstaclesFactory;
import org.eclipse.apogy.examples.obstacles.ConeObstacle;
import org.eclipse.apogy.examples.obstacles.CubeObstacle;
import org.eclipse.apogy.examples.obstacles.Obstacle;
import org.eclipse.apogy.examples.obstacles.ObstaclesField;
import org.eclipse.apogy.examples.obstacles.apogy.ApogyExamplesObstaclesApogyFactory;
import org.eclipse.apogy.examples.obstacles.apogy.ObstaclesFieldData;
import org.eclipse.apogy.examples.obstacles.apogy.impl.ObstaclesFieldApogySystemApiAdapterImpl;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ObstaclesFieldApogySystemApiAdapterCustomImpl
extends ObstaclesFieldApogySystemApiAdapterImpl {
    private Map<Obstacle, TransformNode> map = new HashMap<Obstacle, TransformNode>();
    private Adapter adapter = null;

    public void init(Environment environment, Type elementType, EObject instance) {
        super.init(environment, elementType, instance);
        this.getObstaclesField().eAdapters().add((Object)this.getAdapter());
    }

    public void dispose() {
        super.dispose();
        this.getObstaclesField().eAdapters().remove((Object)this.getAdapter());
    }

    protected ObstaclesField getObstaclesField() {
        return (ObstaclesField)this.getInstance();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesObstaclesApogyFactory.eINSTANCE.createObstaclesFieldData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        for (Obstacle obstacle : this.getObstaclesField().getObstacles()) {
            this.removeObstacle(obstacle);
        }
        if (initializationData instanceof ObstaclesFieldData) {
            ObstaclesFieldData data = (ObstaclesFieldData)initializationData;
            this.getObstaclesField().getObstacles().clear();
            this.getObstaclesField().getObstacles().addAll(EcoreUtil.copyAll((Collection)data.getObstaclesField().getObstacles()));
            for (Obstacle obstacle : this.getObstaclesField().getObstacles()) {
                this.addObstacle(obstacle);
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof ObstaclesFieldData) {
            ObstaclesFieldData data = (ObstaclesFieldData)initializationData;
            data.setObstaclesField(ApogyExamplesObstaclesFactory.eINSTANCE.createObstaclesField());
            data.getObstaclesField().getObstacles().addAll(EcoreUtil.copyAll((Collection)this.getObstaclesField().getObstacles()));
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getNotifier() instanceof ObstaclesField) {
                        int featureId = msg.getFeatureID(ObstaclesField.class);
                        block0 : switch (featureId) {
                            case 2: {
                                int type = msg.getEventType();
                                switch (type) {
                                    case 3: {
                                        ObstaclesFieldApogySystemApiAdapterCustomImpl.this.addObstacle((Obstacle)msg.getNewValue());
                                        break block0;
                                    }
                                    case 4: {
                                        ObstaclesFieldApogySystemApiAdapterCustomImpl.this.removeObstacle((Obstacle)msg.getOldValue());
                                    }
                                }
                            }
                        }
                    }
                    if (msg.getNotifier() instanceof Obstacle) {
                        ObstaclesFieldApogySystemApiAdapterCustomImpl.this.update((Obstacle)msg.getNotifier());
                    }
                }
            };
        }
        return this.adapter;
    }

    private void addObstacle(Obstacle obstacle) {
        TransformNode transformNode = ApogyCommonTopologyFacade.INSTANCE.createTransformNodeXYZ(obstacle.getX(), obstacle.getY(), obstacle.getZ(), obstacle.getRx(), obstacle.getRy(), obstacle.getRz());
        URLNode urlNode = ApogyCommonTopologyFactory.eINSTANCE.createURLNode();
        if (obstacle instanceof ConeObstacle) {
            urlNode.setUrl("platform:/plugin/org.eclipse.apogy.examples.obstacles.apogy/objs/cone_obstacle.obj");
        } else if (obstacle instanceof CubeObstacle) {
            urlNode.setUrl("platform:/plugin/org.eclipse.apogy.examples.obstacles.apogy/objs/cube_obstacle.obj");
        }
        transformNode.getChildren().add((Object)urlNode);
        GroupNode top = (GroupNode)this.getApogySystem().getTopologyRoot().getOriginNode();
        top.getChildren().add((Object)transformNode);
        this.map.put(obstacle, transformNode);
    }

    private void removeObstacle(Obstacle obstacle) {
        TransformNode transformNode = this.map.get(obstacle);
        if (transformNode != null) {
            GroupNode top = (GroupNode)this.getApogySystem().getTopologyRoot().getOriginNode();
            top.getChildren().remove((Object)transformNode);
        }
        this.map.remove(obstacle);
    }

    private void update(Obstacle obstacle) {
        TransformNode transformNode = this.map.get(obstacle);
        if (transformNode == null) {
            this.addObstacle(obstacle);
        } else {
            transformNode.setPosition(ApogyCommonMathFacade.INSTANCE.createTuple3d(obstacle.getX(), obstacle.getY(), obstacle.getZ()));
            transformNode.setRotationMatrix(ApogyCommonTopologyFacade.INSTANCE.createRotationNodeXYZ(obstacle.getRx(), obstacle.getRy(), obstacle.getRz()).getRotationMatrix());
        }
    }
}

