/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.addons.telecoms.ApogyAddonsTelecomsPackage;
import org.eclipse.apogy.addons.telecoms.TelecomNode;
import org.eclipse.apogy.addons.telecoms.TelecomNodeStatus;
import org.eclipse.apogy.addons.telecoms.TelecomStatusMonitorTool;
import org.eclipse.apogy.addons.telecoms.impl.TelecomStatusMonitorToolImpl;
import org.eclipse.apogy.common.emf.ApogyCommonTransactionFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Display;

public class TelecomStatusMonitorToolCustomImpl
extends TelecomStatusMonitorToolImpl {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").indexOf("Windows") != -1;
    private final List<TelecomNodeJob> nodeJobs = new ArrayList<TelecomNodeJob>();

    protected TelecomStatusMonitorToolCustomImpl() {
    }

    @Override
    public void initialise() {
    }

    @Override
    public void start() {
        if (!this.isDisposed()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL__ACTIVE, (Object)true, true);
            TelecomNodeJob nodeJob = new TelecomNodeJob(this);
            nodeJob.schedule();
            this.nodeJobs.add(nodeJob);
        }
    }

    @Override
    public void stop() {
        if (!this.isDisposed()) {
            for (TelecomNodeJob nodeJob : this.nodeJobs) {
                nodeJob.cancel();
            }
            this.nodeJobs.clear();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL__ACTIVE, (Object)false, true);
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__STATUS, (Object)TelecomNodeStatus.NOT_STARTED, true);
        }
    }

    @Override
    public void dispose() {
        if (!this.isDisposed()) {
            this.stop();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.SIMPLE_TOOL__DISPOSED, (Object)true, true);
        }
    }

    @Override
    public void variablesInstantiated() {
    }

    @Override
    public void variablesCleared() {
    }

    private void updateStatus(TelecomNode node) {
        TelecomNodeStatus status = TelecomNodeStatus.NOT_STARTED;
        status = !this.isActive() ? TelecomNodeStatus.NOT_ENABLED : (node.getPacketLoss() >= 100.0 ? TelecomNodeStatus.UNREACHABLE : (node.getLatency() >= 0.0 && node.getLatency() < node.getLatencyWarning() ? (node.getPacketLoss() < node.getPacketLossWarning() ? TelecomNodeStatus.NORMAL : (node.getPacketLoss() >= node.getPacketLossWarning() && node.getPacketLoss() < node.getPacketLossAlarm() ? TelecomNodeStatus.PACKET_LOSS_WARNING : TelecomNodeStatus.PACKET_LOSS_ALARM)) : (node.getLatency() >= node.getLatencyWarning() && node.getLatency() < node.getLatencyAlarm() ? (node.getPacketLoss() < node.getPacketLossWarning() ? TelecomNodeStatus.LATENCY_WARNING : (node.getPacketLoss() >= node.getPacketLossWarning() && node.getPacketLoss() < node.getPacketLossAlarm() ? TelecomNodeStatus.BOTH_WARNING : TelecomNodeStatus.BOTH_ALARM)) : (node.getPacketLoss() < node.getPacketLossWarning() ? TelecomNodeStatus.LATENCY_ALARM : (node.getPacketLoss() >= node.getPacketLossWarning() && node.getPacketLoss() < node.getPacketLossAlarm() ? TelecomNodeStatus.BOTH_ALARM : TelecomNodeStatus.BOTH_ALARM)))));
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)node, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__STATUS, (Object)status, true);
    }

    private class TelecomNodeJob
    extends Job {
        private static final int TIMEOUT_OFFSET = 30;
        private static final String PACKET_LINE_ERROR_STR = "errors";
        private final TelecomStatusMonitorTool tool;

        public TelecomNodeJob(TelecomStatusMonitorTool telecomStatusMonitorTool) {
            super("Job for NetworkNode " + telecomStatusMonitorTool.getName());
            this.tool = telecomStatusMonitorTool;
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled() && TelecomStatusMonitorToolCustomImpl.this.isActive()) {
                if (this.tool.isActive()) {
                    ProcessBuilder pingPB = null;
                    if (IS_WINDOWS) {
                        pingPB = new ProcessBuilder("ping", "-n", Integer.toString(this.tool.getPacketsToSend()), "-w", Double.toString(this.tool.getConnectionTimeout()), this.tool.getAddress());
                    } else {
                        double timeoutInSec = (double)this.tool.getConnectionTimeout() / 1000.0;
                        pingPB = new ProcessBuilder("ping", "-c", Integer.toString(this.tool.getPacketsToSend()), "-W", Double.toString(timeoutInSec), this.tool.getAddress());
                    }
                    try {
                        long waitForTimeout = this.tool.getPacketsToSend() * this.tool.getConnectionTimeout() + 30;
                        final Process pingProcess = pingPB.start();
                        boolean finished = pingProcess.waitFor(waitForTimeout, TimeUnit.MILLISECONDS);
                        if (finished) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    TelecomNodeJob.this.extractValuesFromPingOutput(pingProcess);
                                    TelecomStatusMonitorToolCustomImpl.this.updateStatus(TelecomNodeJob.this.tool);
                                }
                            });
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)TelecomNodeJob.this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__STATUS, (Object)TelecomNodeStatus.UNREACHABLE, true);
                                }
                            });
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        break;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                        break;
                    }
                }
                try {
                    Thread.sleep(TelecomStatusMonitorToolCustomImpl.this.getUpdatePeriod());
                }
                catch (InterruptedException interruptedException) {}
            }
            return Status.OK_STATUS;
        }

        private void extractValuesFromPingOutput(Process proc) {
            block23: {
                BufferedReader br = null;
                try {
                    try {
                        br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                        String line = null;
                        boolean startStatLineFound = false;
                        boolean packetStatLineFound = false;
                        boolean latencyStatLineFound = false;
                        if (IS_WINDOWS) {
                            Pattern statLine = Pattern.compile("^Ping statistics for .+:$");
                            Pattern packetLine = Pattern.compile("^Packets: Sent = .+, Received = .+, Lost = .+ \\(.+% loss\\),$");
                            Pattern latencyLine = Pattern.compile("^Minimum = .+ms, Maximum = .+ms, Average = .+ms$");
                            while ((line = br.readLine()) != null) {
                                if (statLine.matcher(line = line.trim()).matches()) {
                                    startStatLineFound = true;
                                    continue;
                                }
                                if (!startStatLineFound) continue;
                                if (!packetStatLineFound) {
                                    if (!packetLine.matcher(line).matches()) continue;
                                    packetStatLineFound = true;
                                    String[] packetStats = line.split(",");
                                    packetStats = packetStats[2].split("\\(");
                                    packetStats = packetStats[1].split("%");
                                    String packetLossVal = packetStats[0];
                                    packetLossVal = packetLossVal.trim();
                                    double packetLossPercentage = Double.parseDouble(packetLossVal);
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)packetLossPercentage, true);
                                    continue;
                                }
                                if (latencyStatLineFound || !latencyLine.matcher(line).matches()) continue;
                                latencyStatLineFound = true;
                                String[] latencyStats = line.split(",");
                                latencyStats = latencyStats[2].split("=");
                                String averageLatency = latencyStats[1].trim();
                                averageLatency = averageLatency.substring(0, averageLatency.length() - 2);
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)Double.parseDouble(averageLatency), true);
                            }
                        } else {
                            Pattern statLine = Pattern.compile("^--- .+ ping statistics ---$");
                            Pattern packetLine = Pattern.compile("^.+ packets transmitted, .+ received, .+% packet loss, time .+ms$");
                            Pattern latencyLine = Pattern.compile("^rtt min/avg/max/mdev = .+/.+/.+/.+ ms$");
                            while ((line = br.readLine()) != null) {
                                if (statLine.matcher(line = line.trim()).matches()) {
                                    startStatLineFound = true;
                                    continue;
                                }
                                if (!startStatLineFound) continue;
                                if (!packetStatLineFound) {
                                    if (!packetLine.matcher(line).matches()) continue;
                                    packetStatLineFound = true;
                                    String[] packetStats = line.split(",");
                                    int packetLossStatIndex = 2;
                                    if (line.contains(PACKET_LINE_ERROR_STR)) {
                                        packetLossStatIndex = 3;
                                    }
                                    String packetLossStat = packetStats[packetLossStatIndex].trim();
                                    String packetLossVal = packetLossStat.split("%")[0];
                                    packetLossVal = packetLossVal.trim();
                                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)Double.parseDouble(packetLossVal), true);
                                    continue;
                                }
                                if (latencyStatLineFound || !latencyLine.matcher(line).matches()) continue;
                                latencyStatLineFound = true;
                                String[] latencyStats = line.split("=");
                                latencyStats = latencyStats[1].split("/");
                                String averageLatency = latencyStats[1];
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)Double.parseDouble(averageLatency), true);
                            }
                        }
                        if (!packetStatLineFound) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__PACKET_LOSS, (Object)100.0, true);
                        }
                        if (!latencyStatLineFound) {
                            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this.tool, (EStructuralFeature)ApogyAddonsTelecomsPackage.Literals.TELECOM_NODE__LATENCY, (Object)0.0, true);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        if (br == null) break block23;
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                        }
                    }
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                            br = null;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        }
    }
}

