/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.interpolation.HermiteInterpolator;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;

public class TimeStampedPVCoordinates
extends PVCoordinates
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedPVCoordinates(AbsoluteDate date, Vector3D position, Vector3D velocity, Vector3D acceleration) {
        super(position, velocity, acceleration);
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, Vector3D position, Vector3D velocity) {
        this(date, position, velocity, Vector3D.ZERO);
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, PVCoordinates pv) {
        this(date, pv.getPosition(), pv.getVelocity(), pv.getAcceleration());
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a, PVCoordinates pv) {
        super(new Vector3D(a, pv.getPosition()), new Vector3D(a, pv.getVelocity()), new Vector3D(a, pv.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, PVCoordinates start, PVCoordinates end) {
        super(end.getPosition().subtract((Vector)start.getPosition()), end.getVelocity().subtract((Vector)start.getVelocity()), end.getAcceleration().subtract((Vector)start.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3, double a4, PVCoordinates pv4) {
        super(new Vector3D(a1, pv1.getPosition(), a2, pv2.getPosition(), a3, pv3.getPosition(), a4, pv4.getPosition()), new Vector3D(a1, pv1.getVelocity(), a2, pv2.getVelocity(), a3, pv3.getVelocity(), a4, pv4.getVelocity()), new Vector3D(a1, pv1.getAcceleration(), a2, pv2.getAcceleration(), a3, pv3.getAcceleration(), a4, pv4.getAcceleration()));
        this.date = date;
    }

    public TimeStampedPVCoordinates(AbsoluteDate date, FieldVector3D<DerivativeStructure> p) {
        super(p);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedPVCoordinates shiftedBy(double dt) {
        PVCoordinates spv = super.shiftedBy(dt);
        return new TimeStampedPVCoordinates(this.date.shiftedBy(dt), spv.getPosition(), spv.getVelocity(), spv.getAcceleration());
    }

    public PVCoordinatesProvider toTaylorProvider(final Frame instanceFrame) {
        return new PVCoordinatesProvider(){

            @Override
            public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate d, Frame f) throws OrekitException {
                TimeStampedPVCoordinates shifted = TimeStampedPVCoordinates.this.shiftedBy(d.durationFrom(TimeStampedPVCoordinates.this.date));
                Transform transform = instanceFrame.getTransformTo(f, d);
                return transform.transformPVCoordinates(shifted);
            }
        };
    }

    public static TimeStampedPVCoordinates interpolate(AbsoluteDate date, CartesianDerivativesFilter filter, Collection<TimeStampedPVCoordinates> sample) {
        HermiteInterpolator interpolator = new HermiteInterpolator();
        switch (filter) {
            case USE_P: {
                for (TimeStampedPVCoordinates pv : sample) {
                    Vector3D position = pv.getPosition();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{{position.getX(), position.getY(), position.getZ()}});
                }
                break;
            }
            case USE_PV: {
                for (TimeStampedPVCoordinates pv : sample) {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{{position.getX(), position.getY(), position.getZ()}, {velocity.getX(), velocity.getY(), velocity.getZ()}});
                }
                break;
            }
            case USE_PVA: {
                for (TimeStampedPVCoordinates pv : sample) {
                    Vector3D position = pv.getPosition();
                    Vector3D velocity = pv.getVelocity();
                    Vector3D acceleration = pv.getAcceleration();
                    interpolator.addSamplePoint(pv.getDate().durationFrom(date), (double[][])new double[][]{{position.getX(), position.getY(), position.getZ()}, {velocity.getX(), velocity.getY(), velocity.getZ()}, {acceleration.getX(), acceleration.getY(), acceleration.getZ()}});
                }
                break;
            }
            default: {
                throw OrekitException.createInternalError(null);
            }
        }
        DerivativeStructure zero = new DerivativeStructure(1, 2, 0, 0.0);
        DerivativeStructure[] p = interpolator.value(zero);
        return new TimeStampedPVCoordinates(date, new Vector3D(p[0].getValue(), p[1].getValue(), p[2].getValue()), new Vector3D(p[0].getPartialDerivative(new int[]{1}), p[1].getPartialDerivative(new int[]{1}), p[2].getPartialDerivative(new int[]{1})), new Vector3D(p[0].getPartialDerivative(new int[]{2}), p[1].getPartialDerivative(new int[]{2}), p[2].getPartialDerivative(new int[]{2})));
    }

    @Override
    public String toString() {
        String comma = ", ";
        return new StringBuffer().append('{').append(this.date).append(", P(").append(this.getPosition().getX()).append(", ").append(this.getPosition().getY()).append(", ").append(this.getPosition().getZ()).append("), V(").append(this.getVelocity().getX()).append(", ").append(this.getVelocity().getY()).append(", ").append(this.getVelocity().getZ()).append("), A(").append(this.getAcceleration().getX()).append(", ").append(this.getAcceleration().getY()).append(", ").append(this.getAcceleration().getZ()).append(")}").toString();
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private double[] d;

        private DTO(TimeStampedPVCoordinates pv) {
            double epoch = FastMath.floor((double)pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH));
            double offset = pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH.shiftedBy(epoch));
            this.d = new double[]{epoch, offset, pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()};
        }

        private Object readResolve() {
            return new TimeStampedPVCoordinates(AbsoluteDate.J2000_EPOCH.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[2], this.d[3], this.d[4]), new Vector3D(this.d[5], this.d[6], this.d[7]), new Vector3D(this.d[8], this.d[9], this.d[10]));
        }
    }
}

