/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collection;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.interpolation.HermiteInterpolator;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.PVCoordinates;

public class TimeStampedAngularCoordinates
extends AngularCoordinates
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedAngularCoordinates(AbsoluteDate date, Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u1, PVCoordinates u2, PVCoordinates v1, PVCoordinates v2, double tolerance) throws OrekitException {
        super(u1, u2, v1, v2, tolerance);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u, PVCoordinates v) throws OrekitException {
        super(u, v);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, FieldRotation<DerivativeStructure> r) {
        super(r);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedAngularCoordinates revert() {
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    @Override
    public TimeStampedAngularCoordinates shiftedBy(double dt) {
        AngularCoordinates sac = super.shiftedBy(dt);
        return new TimeStampedAngularCoordinates(this.date.shiftedBy(dt), sac.getRotation(), sac.getRotationRate(), sac.getRotationAcceleration());
    }

    @Override
    public TimeStampedAngularCoordinates addOffset(AngularCoordinates offset) {
        Vector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        Vector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().applyTo(offset.getRotation()), this.getRotationRate().add((Vector)rOmega), new Vector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, Vector3D.crossProduct((Vector3D)this.getRotationRate(), (Vector3D)rOmega)));
    }

    @Override
    public TimeStampedAngularCoordinates subtractOffset(AngularCoordinates offset) {
        return this.addOffset(offset.revert());
    }

    public static TimeStampedAngularCoordinates interpolate(AbsoluteDate date, AngularDerivativesFilter filter, Collection<TimeStampedAngularCoordinates> sample) throws OrekitException {
        Vector3D meanRate;
        Vector3D sum;
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min((double)-0.9999, (double)(-FastMath.cos((double)(epsilon / 4.0))));
        if (filter != AngularDerivativesFilter.USE_R) {
            sum = Vector3D.ZERO;
            for (TimeStampedAngularCoordinates datedAC : sample) {
                sum = sum.add((Vector)datedAC.getRotationRate());
            }
            meanRate = new Vector3D(1.0 / (double)sample.size(), sum);
        } else {
            if (sample.size() < 2) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, sample.size());
            }
            sum = Vector3D.ZERO;
            TimeStampedAngularCoordinates previous = null;
            for (TimeStampedAngularCoordinates datedAC : sample) {
                if (previous != null) {
                    sum = sum.add((Vector)TimeStampedAngularCoordinates.estimateRate(previous.getRotation(), datedAC.getRotation(), datedAC.date.durationFrom(previous.date)));
                }
                previous = datedAC;
            }
            meanRate = new Vector3D(1.0 / (double)(sample.size() - 1), sum);
        }
        TimeStampedAngularCoordinates offset = new TimeStampedAngularCoordinates(date, Rotation.IDENTITY, meanRate, Vector3D.ZERO);
        boolean restart = true;
        for (int i = 0; restart && i < sample.size() + 2; ++i) {
            restart = false;
            HermiteInterpolator interpolator = new HermiteInterpolator();
            double sign = 1.0;
            Rotation previous = Rotation.IDENTITY;
            block8: for (TimeStampedAngularCoordinates ac : sample) {
                double dt = ac.date.durationFrom(date);
                TimeStampedAngularCoordinates fixed = ac.subtractOffset(offset.shiftedBy(dt));
                double dot = MathArrays.linearCombination((double)fixed.getRotation().getQ0(), (double)previous.getQ0(), (double)fixed.getRotation().getQ1(), (double)previous.getQ1(), (double)fixed.getRotation().getQ2(), (double)previous.getQ2(), (double)fixed.getRotation().getQ3(), (double)previous.getQ3());
                sign = FastMath.copySign((double)1.0, (double)(dot * sign));
                previous = fixed.getRotation();
                if (fixed.getRotation().getQ0() * sign < threshold) {
                    restart = true;
                    break;
                }
                double[][] rodrigues = fixed.getModifiedRodrigues(sign);
                switch (filter) {
                    case USE_RRA: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0], rodrigues[1], rodrigues[2]});
                        continue block8;
                    }
                    case USE_RR: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0], rodrigues[1]});
                        continue block8;
                    }
                    case USE_R: {
                        interpolator.addSamplePoint(dt, (double[][])new double[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw OrekitException.createInternalError(null);
            }
            if (!restart) {
                DerivativeStructure zero = new DerivativeStructure(1, 2, 0, 0.0);
                DerivativeStructure[] p = interpolator.value(zero);
                AngularCoordinates ac = TimeStampedAngularCoordinates.createFromModifiedRodrigues(new double[][]{{p[0].getValue(), p[1].getValue(), p[2].getValue()}, {p[0].getPartialDerivative(new int[]{1}), p[1].getPartialDerivative(new int[]{1}), p[2].getPartialDerivative(new int[]{1})}, {p[0].getPartialDerivative(new int[]{2}), p[1].getPartialDerivative(new int[]{2}), p[2].getPartialDerivative(new int[]{2})}});
                return new TimeStampedAngularCoordinates(offset.getDate(), ac.getRotation(), ac.getRotationRate(), ac.getRotationAcceleration()).addOffset(offset);
            }
            offset = offset.addOffset(new AngularCoordinates(new Rotation(Vector3D.PLUS_I, epsilon), Vector3D.ZERO, Vector3D.ZERO));
        }
        throw OrekitException.createInternalError(null);
    }
}

