/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PVCoordinates
implements TimeShiftable<PVCoordinates>,
Serializable {
    public static final PVCoordinates ZERO = new PVCoordinates(Vector3D.ZERO, Vector3D.ZERO, Vector3D.ZERO);
    private static final long serialVersionUID = 20140407L;
    private final Vector3D position;
    private final Vector3D velocity;
    private final Vector3D acceleration;

    public PVCoordinates() {
        this.position = Vector3D.ZERO;
        this.velocity = Vector3D.ZERO;
        this.acceleration = Vector3D.ZERO;
    }

    public PVCoordinates(Vector3D position, Vector3D velocity) {
        this.position = position;
        this.velocity = velocity;
        this.acceleration = Vector3D.ZERO;
    }

    public PVCoordinates(Vector3D position, Vector3D velocity, Vector3D acceleration) {
        this.position = position;
        this.velocity = velocity;
        this.acceleration = acceleration;
    }

    public PVCoordinates(double a, PVCoordinates pv) {
        this.position = new Vector3D(a, pv.position);
        this.velocity = new Vector3D(a, pv.velocity);
        this.acceleration = new Vector3D(a, pv.acceleration);
    }

    public PVCoordinates(PVCoordinates start, PVCoordinates end) {
        this.position = end.position.subtract((Vector)start.position);
        this.velocity = end.velocity.subtract((Vector)start.velocity);
        this.acceleration = end.acceleration.subtract((Vector)start.acceleration);
    }

    public PVCoordinates(double a1, PVCoordinates pv1, double a2, PVCoordinates pv2) {
        this.position = new Vector3D(a1, pv1.position, a2, pv2.position);
        this.velocity = new Vector3D(a1, pv1.velocity, a2, pv2.velocity);
        this.acceleration = new Vector3D(a1, pv1.acceleration, a2, pv2.acceleration);
    }

    public PVCoordinates(double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3) {
        this.position = new Vector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position);
        this.velocity = new Vector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity);
        this.acceleration = new Vector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration);
    }

    public PVCoordinates(double a1, PVCoordinates pv1, double a2, PVCoordinates pv2, double a3, PVCoordinates pv3, double a4, PVCoordinates pv4) {
        this.position = new Vector3D(a1, pv1.position, a2, pv2.position, a3, pv3.position, a4, pv4.position);
        this.velocity = new Vector3D(a1, pv1.velocity, a2, pv2.velocity, a3, pv3.velocity, a4, pv4.velocity);
        this.acceleration = new Vector3D(a1, pv1.acceleration, a2, pv2.acceleration, a3, pv3.acceleration, a4, pv4.acceleration);
    }

    public PVCoordinates(FieldVector3D<DerivativeStructure> p) {
        this.position = new Vector3D(((DerivativeStructure)p.getX()).getReal(), ((DerivativeStructure)p.getY()).getReal(), ((DerivativeStructure)p.getZ()).getReal());
        if (((DerivativeStructure)p.getX()).getOrder() >= 1) {
            this.velocity = new Vector3D(((DerivativeStructure)p.getX()).getPartialDerivative(new int[]{1}), ((DerivativeStructure)p.getY()).getPartialDerivative(new int[]{1}), ((DerivativeStructure)p.getZ()).getPartialDerivative(new int[]{1}));
            this.acceleration = ((DerivativeStructure)p.getX()).getOrder() >= 2 ? new Vector3D(((DerivativeStructure)p.getX()).getPartialDerivative(new int[]{2}), ((DerivativeStructure)p.getY()).getPartialDerivative(new int[]{2}), ((DerivativeStructure)p.getZ()).getPartialDerivative(new int[]{2})) : Vector3D.ZERO;
        } else {
            this.velocity = Vector3D.ZERO;
            this.acceleration = Vector3D.ZERO;
        }
    }

    public FieldVector3D<DerivativeStructure> toDerivativeStructureVector(int order) throws OrekitException {
        DerivativeStructure z;
        DerivativeStructure y;
        DerivativeStructure x;
        switch (order) {
            case 0: {
                x = new DerivativeStructure(1, 0, this.position.getX());
                y = new DerivativeStructure(1, 0, this.position.getY());
                z = new DerivativeStructure(1, 0, this.position.getZ());
                break;
            }
            case 1: {
                x = new DerivativeStructure(1, 1, new double[]{this.position.getX(), this.velocity.getX()});
                y = new DerivativeStructure(1, 1, new double[]{this.position.getY(), this.velocity.getY()});
                z = new DerivativeStructure(1, 1, new double[]{this.position.getZ(), this.velocity.getZ()});
                break;
            }
            case 2: {
                x = new DerivativeStructure(1, 2, new double[]{this.position.getX(), this.velocity.getX(), this.acceleration.getX()});
                y = new DerivativeStructure(1, 2, new double[]{this.position.getY(), this.velocity.getY(), this.acceleration.getY()});
                z = new DerivativeStructure(1, 2, new double[]{this.position.getZ(), this.velocity.getZ(), this.acceleration.getZ()});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldVector3D((RealFieldElement)x, (RealFieldElement)y, (RealFieldElement)z);
    }

    public static Vector3D estimateVelocity(Vector3D start, Vector3D end, double dt) {
        double scale = 1.0 / dt;
        return new Vector3D(scale, end, -scale, start);
    }

    @Override
    public PVCoordinates shiftedBy(double dt) {
        return new PVCoordinates(new Vector3D(1.0, this.position, dt, this.velocity, 0.5 * dt * dt, this.acceleration), new Vector3D(1.0, this.velocity, dt, this.acceleration), this.acceleration);
    }

    @Deprecated
    public static PVCoordinates interpolate(AbsoluteDate date, boolean useVelocities, Collection<Pair<AbsoluteDate, PVCoordinates>> sample) {
        ArrayList<TimeStampedPVCoordinates> list = new ArrayList<TimeStampedPVCoordinates>(sample.size());
        for (Pair<AbsoluteDate, PVCoordinates> pair : sample) {
            list.add(new TimeStampedPVCoordinates((AbsoluteDate)pair.getFirst(), ((PVCoordinates)pair.getSecond()).getPosition(), ((PVCoordinates)pair.getSecond()).getVelocity(), ((PVCoordinates)pair.getSecond()).getAcceleration()));
        }
        return TimeStampedPVCoordinates.interpolate(date, useVelocities ? CartesianDerivativesFilter.USE_PV : CartesianDerivativesFilter.USE_P, list);
    }

    public Vector3D getPosition() {
        return this.position;
    }

    public Vector3D getVelocity() {
        return this.velocity;
    }

    public Vector3D getAcceleration() {
        return this.acceleration;
    }

    public Vector3D getMomentum() {
        return Vector3D.crossProduct((Vector3D)this.position, (Vector3D)this.velocity);
    }

    public Vector3D getAngularVelocity() {
        return this.getMomentum().scalarMultiply(1.0 / this.getPosition().getNormSq());
    }

    public PVCoordinates negate() {
        return new PVCoordinates(this.position.negate(), this.velocity.negate(), this.acceleration.negate());
    }

    public PVCoordinates normalize() {
        double inv = 1.0 / this.position.getNorm();
        Vector3D u = new Vector3D(inv, this.position);
        Vector3D v = new Vector3D(inv, this.velocity);
        Vector3D w = new Vector3D(inv, this.acceleration);
        double uv = Vector3D.dotProduct((Vector3D)u, (Vector3D)v);
        double v2 = Vector3D.dotProduct((Vector3D)v, (Vector3D)v);
        double uw = Vector3D.dotProduct((Vector3D)u, (Vector3D)w);
        Vector3D uDot = new Vector3D(1.0, v, -uv, u);
        Vector3D uDotDot = new Vector3D(1.0, w, -2.0 * uv, v, 3.0 * uv * uv - v2 - uw, u);
        return new PVCoordinates(u, uDot, uDotDot);
    }

    public static PVCoordinates crossProduct(PVCoordinates pv1, PVCoordinates pv2) {
        Vector3D p1 = pv1.position;
        Vector3D v1 = pv1.velocity;
        Vector3D a1 = pv1.acceleration;
        Vector3D p2 = pv2.position;
        Vector3D v2 = pv2.velocity;
        Vector3D a2 = pv2.acceleration;
        return new PVCoordinates(Vector3D.crossProduct((Vector3D)p1, (Vector3D)p2), new Vector3D(1.0, Vector3D.crossProduct((Vector3D)p1, (Vector3D)v2), 1.0, Vector3D.crossProduct((Vector3D)v1, (Vector3D)p2)), new Vector3D(1.0, Vector3D.crossProduct((Vector3D)p1, (Vector3D)a2), 2.0, Vector3D.crossProduct((Vector3D)v1, (Vector3D)v2), 1.0, Vector3D.crossProduct((Vector3D)a1, (Vector3D)p2)));
    }

    public String toString() {
        String comma = ", ";
        return new StringBuffer().append('{').append("P(").append(this.position.getX()).append(", ").append(this.position.getY()).append(", ").append(this.position.getZ()).append("), V(").append(this.velocity.getX()).append(", ").append(this.velocity.getY()).append(", ").append(this.velocity.getZ()).append("), A(").append(this.acceleration.getX()).append(", ").append(this.acceleration.getY()).append(", ").append(this.acceleration.getZ()).append(")}").toString();
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private double[] d;

        private DTO(PVCoordinates pv) {
            this.d = new double[]{pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()};
        }

        private Object readResolve() {
            return new PVCoordinates(new Vector3D(this.d[0], this.d[1], this.d[2]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8]));
        }
    }
}

