/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.analysis.interpolation.HermiteInterpolator;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.util.FastMath;
import org.orekit.data.BodiesElements;
import org.orekit.data.DelaunayArguments;
import org.orekit.data.FieldBodiesElements;
import org.orekit.data.FundamentalNutationArguments;
import org.orekit.data.PoissonSeries;
import org.orekit.data.PoissonSeriesParser;
import org.orekit.data.PolynomialNutation;
import org.orekit.data.PolynomialParser;
import org.orekit.data.SimpleTimeStampedTableParser;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.PoleCorrection;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeFunction;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UTCScale;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.LoveNumbers;

public enum IERSConventions {
    IERS_1996{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/1996/nutation-arguments.txt";
        private static final String X_Y_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab5.4.txt";
        private static final String PSI_EPSILON_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab5.1.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab8.4.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/1996/tab8.3.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/1996/tab6.1.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/1996/tab6.2c.txt";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale) throws OrekitException {
            return new FundamentalNutationArguments(this, timeScale, IERSConventions.getStream(NUTATION_ARGUMENTS), NUTATION_ARGUMENTS);
        }

        @Override
        public TimeFunction<Double> getMeanObliquityFunction() throws OrekitException {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.40909280422232897, -2.2696552481142927E-4, -2.8604007185462624E-9, 8.789672038515888E-9);
            return new TimeFunction<Double>(){

                @Override
                public Double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date));
                }
            };
        }

        @Override
        public TimeFunction<double[]> getXYSpXY2Function() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            final PolynomialNutation xPolynomial = new PolynomialNutation(0.0, 0.00971717345516967, -2.068457570453835E-6, -9.631114663449597E-7, 6.787391535533504E-11);
            double fXCosOm = 2.908882086657216E-10;
            double fXSinOm = 9.890199094634534E-9;
            double fXSin2FDOm = 7.757018897752577E-10;
            final double sinEps0 = FastMath.sin((double)this.getMeanObliquityFunction().value(this.getNutationReferenceEpoch()));
            double deciMilliAS = 4.84813681109536E-10;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(12).withFirstDelaunay(1);
            PoissonSeriesParser xParser = baseParser.withSinCos(0, 7, 4.84813681109536E-10, -1, 4.84813681109536E-10).withSinCos(1, 8, 4.84813681109536E-10, 9, 4.84813681109536E-10);
            PoissonSeries xSum = xParser.parse(IERSConventions.getStream(X_Y_SERIES), X_Y_SERIES);
            final PolynomialNutation yPolynomial = new PolynomialNutation(-6.302577854423967E-10, 0.0, -1.0864635808570213E-4, 8.901179185171081E-9, 5.395976270749136E-9);
            double fYCosOm = -1.1199196033630281E-8;
            double fYCos2FDOm = -6.787391535533503E-10;
            PoissonSeriesParser yParser = baseParser.withSinCos(0, -1, 4.84813681109536E-10, 10, 4.84813681109536E-10).withSinCos(1, 12, 4.84813681109536E-10, 11, 4.84813681109536E-10);
            PoissonSeries ySum = yParser.parse(IERSConventions.getStream(X_Y_SERIES), X_Y_SERIES);
            final PoissonSeries.CompiledSeries xySum = PoissonSeries.compile(xSum, ySum);
            double fST = 1.8665326722717134E-8;
            double fST3 = -3.5192625111741217E-7;
            double fSSinOm = -1.2799081181291749E-8;
            double fSSin2Om = -2.908882086657216E-10;
            double fST2SinOm = 3.587621240210566E-9;
            double fST2Sin2FDOm = 2.908882086657216E-10;
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] xy = xySum.value(elements);
                    double omega = elements.getOmega();
                    double f = elements.getF();
                    double d = elements.getD();
                    double t = elements.getTC();
                    double cosOmega = FastMath.cos((double)omega);
                    double sinOmega = FastMath.sin((double)omega);
                    double sin2Omega = FastMath.sin((double)(2.0 * omega));
                    double cos2FDOm = FastMath.cos((double)(2.0 * (f - d + omega)));
                    double sin2FDOm = FastMath.sin((double)(2.0 * (f - d + omega)));
                    double x = xPolynomial.value(t) + sinEps0 * xy[0] + t * t * (2.908882086657216E-10 * cosOmega + 9.890199094634534E-9 * sinOmega + 7.757018897752577E-10 * cos2FDOm);
                    double y = yPolynomial.value(t) + xy[1] + t * t * (-1.1199196033630281E-8 * cosOmega + -6.787391535533503E-10 * cos2FDOm);
                    double sPxy2 = -1.2799081181291749E-8 * sinOmega + -2.908882086657216E-10 * sin2Omega + t * (1.8665326722717134E-8 + t * (3.587621240210566E-9 * sinOmega + 2.908882086657216E-10 * sin2FDOm + t * -3.5192625111741217E-7));
                    return new double[]{x, y, sPxy2};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getPrecessionFunction() throws OrekitException {
            final PolynomialNutation psiA = new PolynomialNutation(0.0, 0.02442868704399218, -5.200063062212772E-6, -5.560812922326378E-9);
            final PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction().value(this.getNutationReferenceEpoch()), 0.0, 2.4856397430485914E-7, -3.745670500252275E-8);
            final PolynomialNutation chiA = new PolynomialNutation(0.0, 5.1160448512764897E-5, -1.1541668417966057E-5, -5.454153912482279E-9);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double tc = this.evaluateTC(date);
                    return new double[]{psiA.value(tc), omegaA.value(tc), chiA.value(tc)};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getNutationFunction() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            double deciMilliAS = 4.84813681109536E-10;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(10).withFirstDelaunay(1);
            PoissonSeriesParser psiParser = baseParser.withSinCos(0, 7, 4.84813681109536E-10, -1, 4.84813681109536E-10).withSinCos(1, 8, 4.84813681109536E-10, -1, 4.84813681109536E-10);
            PoissonSeries psiSeries = psiParser.parse(IERSConventions.getStream(PSI_EPSILON_SERIES), PSI_EPSILON_SERIES);
            PoissonSeriesParser epsilonParser = baseParser.withSinCos(0, -1, 4.84813681109536E-10, 9, 4.84813681109536E-10).withSinCos(1, -1, 4.84813681109536E-10, 10, 4.84813681109536E-10);
            PoissonSeries epsilonSeries = epsilonParser.parse(IERSConventions.getStream(PSI_EPSILON_SERIES), PSI_EPSILON_SERIES);
            final PoissonSeries.CompiledSeries psiEpsilonSeries = PoissonSeries.compile(psiSeries, epsilonSeries);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] psiEpsilon = psiEpsilonSeries.value(elements);
                    return new double[]{psiEpsilon[0], psiEpsilon[1], IAU1994ResolutionC7.value(elements)};
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGMSTFunction(final TimeScale ut1) throws OrekitException {
            double radiansPerSecond = 7.27220521664304E-5;
            final AbsoluteDate gmstReference = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)TimeScalesFactory.getTAI());
            double gmst0 = 24110.54841;
            double gmst1 = 8640184.812866;
            double gmst2 = 0.093104;
            double gmst3 = -6.2E-6;
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    double dtai = date.durationFrom(gmstReference);
                    DerivativeStructure tut1 = new DerivativeStructure(1, 1, new double[]{dtai + ut1.offsetFromTAI(date), 1.0});
                    DerivativeStructure tt = tut1.divide(3.15576E9);
                    DerivativeStructure sd = tut1.add(43200.0).remainder(86400.0);
                    return tt.multiply(-6.2E-6).add(0.093104).multiply(tt).add(8640184.812866).multiply(tt).add(24110.54841).add(sd).multiply(7.27220521664304E-5);
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGASTFunction(TimeScale ut1, final EOPHistory eopHistory) throws OrekitException {
            final TimeFunction<Double> epsilonA = this.getMeanObliquityFunction();
            final TimeFunction<DerivativeStructure> gmst = this.getGMSTFunction(ut1);
            final TimeFunction<double[]> nutation = this.getNutationFunction();
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    double[] angles = (double[])nutation.value(date);
                    double deltaPsi = angles[0];
                    if (eopHistory != null) {
                        deltaPsi += eopHistory.getEquinoxNutationCorrection(date)[0];
                    }
                    double eqe = deltaPsi * FastMath.cos((double)((Double)epsilonA.value(date))) + angles[2];
                    return ((DerivativeStructure)gmst.value(date)).add(eqe);
                }
            };
        }

        @Override
        public TimeFunction<double[]> getEOPTidalCorrection() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(TimeScalesFactory.getTT());
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(17).withOptionalColumn(1).withGamma(7).withFirstDelaunay(2);
            PoissonSeries xSeries = xyParser.withSinCos(0, 14, 4.84813681109536E-9, 15, 4.84813681109536E-9).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            PoissonSeries ySeries = xyParser.withSinCos(0, 16, 4.84813681109536E-9, 17, 4.84813681109536E-9).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            double deciMilliS = 1.0E-4;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(17).withOptionalColumn(1).withGamma(7).withFirstDelaunay(2).withSinCos(0, 16, 1.0E-4, 17, 1.0E-4);
            PoissonSeries ut1Series = ut1Parser.parse(IERSConventions.getStream(TIDAL_CORRECTION_UT1_SERIES), TIDAL_CORRECTION_UT1_SERIES);
            final PoissonSeries.CompiledSeries correctionSeries = PoissonSeries.compile(xSeries, ySeries, ut1Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    FieldBodiesElements<DerivativeStructure> elements = arguments.evaluateDerivative(date);
                    DerivativeStructure[] correction = (DerivativeStructure[])correctionSeries.value(elements);
                    return new double[]{correction[0].getValue(), correction[1].getValue(), correction[2].getValue(), -correction[2].getPartialDerivative(new int[]{1}) * 86400.0};
                }
            };
        }

        @Override
        public LoveNumbers getLoveNumbers() throws OrekitException {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeFunction<double[]> getTideFrequencyDependenceFunction(TimeScale ut1) throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(ut1);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K20_FREQUENCY_DEPENDENCE), K20_FREQUENCY_DEPENDENCE);
            PoissonSeries c21Series = k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries s21Series = k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries c22Series = k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            PoissonSeries s22Series = k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            final PoissonSeries.CompiledSeries kSeries = PoissonSeries.compile(c20Series, c21Series, s21Series, c22Series, s22Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return kSeries.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public double getPermanentTide() throws OrekitException {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        @Override
        public TimeFunction<double[]> getSolidPoleTide(final EOPHistory eopHistory) {
            double globalFactor = -2.780449588210859E-4;
            double coupling = 0.00112;
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    PoleCorrection pole = eopHistory.getPoleCorrection(date);
                    return new double[]{-2.780449588210859E-4 * (pole.getXp() + 0.00112 * pole.getYp()), -2.780449588210859E-4 * (0.00112 * pole.getXp() - pole.getYp())};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getOceanPoleTide(EOPHistory eopHistory) throws OrekitException {
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return new double[]{0.0, 0.0};
                }
            };
        }
    }
    ,
    IERS_2003{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/2003/nutation-arguments.txt";
        private static final String X_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2a.txt";
        private static final String Y_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2b.txt";
        private static final String S_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.2c.txt";
        private static final String LUNI_SOLAR_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.3a-first-table.txt";
        private static final String PLANETARY_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.3b.txt";
        private static final String GST_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab5.4.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab8.2ab.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/2003/tab8.3ab.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/2003/tab6.1.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2003/tab6.3c.txt";
        private static final String ANNUAL_POLE = "/assets/org/orekit/IERS-conventions/2003/annual.pole";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale) throws OrekitException {
            return new FundamentalNutationArguments(this, timeScale, IERSConventions.getStream(NUTATION_ARGUMENTS), NUTATION_ARGUMENTS);
        }

        @Override
        public TimeFunction<Double> getMeanObliquityFunction() throws OrekitException {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.40909280422232897, -2.2708789178454132E-4, -2.8604007185462624E-9, 8.789672038515888E-9);
            return new TimeFunction<Double>(){

                @Override
                public Double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date));
                }
            };
        }

        @Override
        public TimeFunction<double[]> getXYSpXY2Function() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withPolynomialPart('t', PolynomialParser.Unit.MICRO_ARC_SECONDS).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries xSeries = parser.parse(IERSConventions.getStream(X_SERIES), X_SERIES);
            PoissonSeries ySeries = parser.parse(IERSConventions.getStream(Y_SERIES), Y_SERIES);
            PoissonSeries sSeries = parser.parse(IERSConventions.getStream(S_SERIES), S_SERIES);
            final PoissonSeries.CompiledSeries xys = PoissonSeries.compile(xSeries, ySeries, sSeries);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return xys.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public TimeFunction<double[]> getPrecessionFunction() throws OrekitException {
            final PolynomialNutation psiA = new PolynomialNutation(0.0, 0.024427234299796735, -5.200063062212772E-6, -5.560812922326378E-9);
            final PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction().value(this.getNutationReferenceEpoch()), -1.2236697311204688E-7, 2.4856397430485914E-7, -3.745670500252275E-8);
            final PolynomialNutation chiA = new PolynomialNutation(0.0, 5.1160448512764897E-5, -1.1541668417966057E-5, -5.454153912482279E-9);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double tc = this.evaluateTC(date);
                    return new double[]{psiA.value(tc), omegaA.value(tc), chiA.value(tc)};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getNutationFunction() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser luniSolarParser = new PoissonSeriesParser(14).withFirstDelaunay(1);
            PoissonSeriesParser luniSolarPsiParser = luniSolarParser.withSinCos(0, 7, 4.84813681109536E-9, 11, 4.84813681109536E-9).withSinCos(1, 8, 4.84813681109536E-9, 12, 4.84813681109536E-9);
            PoissonSeries psiLuniSolarSeries = luniSolarPsiParser.parse(IERSConventions.getStream(LUNI_SOLAR_SERIES), LUNI_SOLAR_SERIES);
            PoissonSeriesParser luniSolarEpsilonParser = luniSolarParser.withSinCos(0, 13, 4.84813681109536E-9, 9, 4.84813681109536E-9).withSinCos(1, 14, 4.84813681109536E-9, 10, 4.84813681109536E-9);
            PoissonSeries epsilonLuniSolarSeries = luniSolarEpsilonParser.parse(IERSConventions.getStream(LUNI_SOLAR_SERIES), LUNI_SOLAR_SERIES);
            PoissonSeriesParser planetaryParser = new PoissonSeriesParser(21).withFirstDelaunay(2).withFirstPlanetary(7);
            PoissonSeriesParser planetaryPsiParser = planetaryParser.withSinCos(0, 17, 4.84813681109536E-9, 18, 4.84813681109536E-9);
            PoissonSeries psiPlanetarySeries = planetaryPsiParser.parse(IERSConventions.getStream(PLANETARY_SERIES), PLANETARY_SERIES);
            PoissonSeriesParser planetaryEpsilonParser = planetaryParser.withSinCos(0, 19, 4.84813681109536E-9, 20, 4.84813681109536E-9);
            PoissonSeries epsilonPlanetarySeries = planetaryEpsilonParser.parse(IERSConventions.getStream(PLANETARY_SERIES), PLANETARY_SERIES);
            final PoissonSeries.CompiledSeries luniSolarSeries = PoissonSeries.compile(psiLuniSolarSeries, epsilonLuniSolarSeries);
            final PoissonSeries.CompiledSeries planetarySeries = PoissonSeries.compile(psiPlanetarySeries, epsilonPlanetarySeries);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] luniSolar = luniSolarSeries.value(elements);
                    double[] planetary = planetarySeries.value(elements);
                    return new double[]{luniSolar[0] + planetary[0], luniSolar[1] + planetary[1], IAU1994ResolutionC7.value(elements)};
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGMSTFunction(TimeScale ut1) throws OrekitException {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = parser.parse(IERSConventions.getStream(GST_SERIES), GST_SERIES).getPolynomial();
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    return era.value(date).add(minusEO.value(this.dsEvaluateTC(date)));
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGASTFunction(TimeScale ut1, final EOPHistory eopHistory) throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            final TimeFunction<Double> epsilon = this.getMeanObliquityFunction();
            double milliAS = 4.84813681109536E-9;
            PoissonSeriesParser luniSolarPsiParser = new PoissonSeriesParser(14).withFirstDelaunay(1).withSinCos(0, 7, 4.84813681109536E-9, 11, 4.84813681109536E-9).withSinCos(1, 8, 4.84813681109536E-9, 12, 4.84813681109536E-9);
            PoissonSeries psiLuniSolarSeries = luniSolarPsiParser.parse(IERSConventions.getStream(LUNI_SOLAR_SERIES), LUNI_SOLAR_SERIES);
            PoissonSeriesParser planetaryPsiParser = new PoissonSeriesParser(21).withFirstDelaunay(2).withFirstPlanetary(7).withSinCos(0, 17, 4.84813681109536E-9, 18, 4.84813681109536E-9);
            PoissonSeries psiPlanetarySeries = planetaryPsiParser.parse(IERSConventions.getStream(PLANETARY_SERIES), PLANETARY_SERIES);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser gstParser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            PoissonSeries gstSeries = gstParser.parse(IERSConventions.getStream(GST_SERIES), GST_SERIES);
            final PoissonSeries.CompiledSeries psiGstSeries = PoissonSeries.compile(psiLuniSolarSeries, psiPlanetarySeries, gstSeries);
            final TimeFunction<DerivativeStructure> era = this.getEarthOrientationAngleFunction(ut1);
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] angles = psiGstSeries.value(elements);
                    double ddPsi = eopHistory == null ? 0.0 : eopHistory.getEquinoxNutationCorrection(date)[0];
                    double deltaPsi = angles[0] + angles[1] + ddPsi;
                    double epsilonA = (Double)epsilon.value(date);
                    return ((DerivativeStructure)era.value(date)).add(deltaPsi * FastMath.cos((double)epsilonA) + angles[2]);
                }
            };
        }

        @Override
        public TimeFunction<double[]> getEOPTidalCorrection() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(TimeScalesFactory.getTT());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(13).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            PoissonSeries xSeries = xyParser.withSinCos(0, 10, 4.84813681109536E-12, 11, 4.84813681109536E-12).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            PoissonSeries ySeries = xyParser.withSinCos(0, 12, 4.84813681109536E-12, 13, 4.84813681109536E-12).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            double microS = 1.0E-6;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(11).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3).withSinCos(0, 10, 1.0E-6, 11, 1.0E-6);
            PoissonSeries ut1Series = ut1Parser.parse(IERSConventions.getStream(TIDAL_CORRECTION_UT1_SERIES), TIDAL_CORRECTION_UT1_SERIES);
            final PoissonSeries.CompiledSeries correctionSeries = PoissonSeries.compile(xSeries, ySeries, ut1Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    FieldBodiesElements<DerivativeStructure> elements = arguments.evaluateDerivative(date);
                    DerivativeStructure[] correction = (DerivativeStructure[])correctionSeries.value(elements);
                    return new double[]{correction[0].getValue(), correction[1].getValue(), correction[2].getValue(), -correction[2].getPartialDerivative(new int[]{1}) * 86400.0};
                }
            };
        }

        @Override
        public LoveNumbers getLoveNumbers() throws OrekitException {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeFunction<double[]> getTideFrequencyDependenceFunction(TimeScale ut1) throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(ut1);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K20_FREQUENCY_DEPENDENCE), K20_FREQUENCY_DEPENDENCE);
            PoissonSeries c21Series = k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries s21Series = k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries c22Series = k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            PoissonSeries s22Series = k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            final PoissonSeries.CompiledSeries kSeries = PoissonSeries.compile(c20Series, c21Series, s21Series, c22Series, s22Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return kSeries.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public double getPermanentTide() throws OrekitException {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        @Override
        public TimeFunction<double[]> getSolidPoleTide(final EOPHistory eopHistory) throws OrekitException {
            final UTCScale utc = TimeScalesFactory.getUTC();
            SimpleTimeStampedTableParser.RowConverter<MeanPole> converter = new SimpleTimeStampedTableParser.RowConverter<MeanPole>(){

                @Override
                public MeanPole convert(double[] rawFields) throws OrekitException {
                    return new MeanPole(new AbsoluteDate((int)rawFields[0], 1, 1, utc), rawFields[1] * 4.84813681109536E-6, rawFields[2] * 4.84813681109536E-6);
                }
            };
            SimpleTimeStampedTableParser<MeanPole> parser = new SimpleTimeStampedTableParser<MeanPole>(3, converter);
            List<MeanPole> annualPoleList = parser.parse(IERSConventions.getStream(ANNUAL_POLE), ANNUAL_POLE);
            final AbsoluteDate firstAnnualPoleDate = annualPoleList.get(0).getDate();
            final AbsoluteDate lastAnnualPoleDate = annualPoleList.get(annualPoleList.size() - 1).getDate();
            final ImmutableTimeStampedCache<MeanPole> annualCache = new ImmutableTimeStampedCache<MeanPole>(2, annualPoleList);
            double xp0 = 2.617993877991494E-7;
            double xp0Dot = 1.275113935536653E-16;
            double yp0 = 1.7307848415610435E-6;
            double yp0Dot = 6.068313307674435E-16;
            double globalFactor = -2.749509867273795E-4;
            double ratio = 0.00115;
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    if (date.compareTo(firstAnnualPoleDate) <= 0) {
                        return new double[]{0.0, 0.0};
                    }
                    double meanPoleX = 0.0;
                    double meanPoleY = 0.0;
                    if (date.compareTo(lastAnnualPoleDate) <= 0) {
                        try {
                            List neighbors = annualCache.getNeighbors(date);
                            HermiteInterpolator interpolator = new HermiteInterpolator();
                            for (MeanPole neighbor : neighbors) {
                                interpolator.addSamplePoint(neighbor.getDate().durationFrom(date), (double[][])new double[][]{{neighbor.getX(), neighbor.getY()}});
                            }
                            double[] interpolated = interpolator.value(0.0);
                            meanPoleX = interpolated[0];
                            meanPoleY = interpolated[1];
                        }
                        catch (TimeStampedCacheException tsce) {
                            throw OrekitException.createInternalError(tsce);
                        }
                    } else {
                        double t = date.durationFrom(AbsoluteDate.J2000_EPOCH);
                        meanPoleX = 2.617993877991494E-7 + t * 1.275113935536653E-16;
                        meanPoleY = 1.7307848415610435E-6 + t * 6.068313307674435E-16;
                    }
                    PoleCorrection correction = eopHistory.getPoleCorrection(date);
                    double m1 = correction.getXp() - meanPoleX;
                    double m2 = meanPoleY - correction.getYp();
                    return new double[]{-2.749509867273795E-4 * (m1 - 0.00115 * m2), -2.749509867273795E-4 * (m2 + 0.00115 * m1)};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getOceanPoleTide(EOPHistory eopHistory) throws OrekitException {
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return new double[]{0.0, 0.0};
                }
            };
        }
    }
    ,
    IERS_2010{
        private static final String NUTATION_ARGUMENTS = "/assets/org/orekit/IERS-conventions/2010/nutation-arguments.txt";
        private static final String X_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2a.txt";
        private static final String Y_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2b.txt";
        private static final String S_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2d.txt";
        private static final String PSI_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.3a.txt";
        private static final String EPSILON_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.3b.txt";
        private static final String GST_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab5.2e.txt";
        private static final String TIDAL_CORRECTION_XP_YP_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab8.2ab.txt";
        private static final String TIDAL_CORRECTION_UT1_SERIES = "/assets/org/orekit/IERS-conventions/2010/tab8.3ab.txt";
        private static final String LOVE_NUMBERS = "/assets/org/orekit/IERS-conventions/2010/tab6.3.txt";
        private static final String K20_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5b.txt";
        private static final String K21_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5a.txt";
        private static final String K22_FREQUENCY_DEPENDENCE = "/assets/org/orekit/IERS-conventions/2010/tab6.5c.txt";

        @Override
        public FundamentalNutationArguments getNutationArguments(TimeScale timeScale) throws OrekitException {
            return new FundamentalNutationArguments(this, timeScale, IERSConventions.getStream(NUTATION_ARGUMENTS), NUTATION_ARGUMENTS);
        }

        @Override
        public TimeFunction<Double> getMeanObliquityFunction() throws OrekitException {
            final PolynomialNutation epsilonA = new PolynomialNutation(0.4090926006005829, -2.2707106390167E-4, -8.876938501115605E-10, 9.712757287348442E-9, -2.792526803190927E-12, -2.104091376015386E-13);
            return new TimeFunction<Double>(){

                @Override
                public Double value(AbsoluteDate date) {
                    return epsilonA.value(this.evaluateTC(date));
                }
            };
        }

        @Override
        public TimeFunction<double[]> getXYSpXY2Function() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withPolynomialPart('t', PolynomialParser.Unit.MICRO_ARC_SECONDS).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries xSeries = parser.parse(IERSConventions.getStream(X_SERIES), X_SERIES);
            PoissonSeries ySeries = parser.parse(IERSConventions.getStream(Y_SERIES), Y_SERIES);
            PoissonSeries sSeries = parser.parse(IERSConventions.getStream(S_SERIES), S_SERIES);
            final PoissonSeries.CompiledSeries xys = PoissonSeries.compile(xSeries, ySeries, sSeries);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return xys.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public LoveNumbers getLoveNumbers() throws OrekitException {
            return this.loadLoveNumbers(LOVE_NUMBERS);
        }

        @Override
        public TimeFunction<double[]> getTideFrequencyDependenceFunction(TimeScale ut1) throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(ut1);
            PoissonSeriesParser k20Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            PoissonSeriesParser k21Parser = new PoissonSeriesParser(18).withOptionalColumn(1).withDoodson(4, 3).withFirstDelaunay(10);
            PoissonSeriesParser k22Parser = new PoissonSeriesParser(16).withOptionalColumn(1).withDoodson(4, 2).withFirstDelaunay(10);
            double pico = 1.0E-12;
            PoissonSeries c20Series = k20Parser.withSinCos(0, 18, -1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K20_FREQUENCY_DEPENDENCE), K20_FREQUENCY_DEPENDENCE);
            PoissonSeries c21Series = k21Parser.withSinCos(0, 17, 1.0E-12, 18, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries s21Series = k21Parser.withSinCos(0, 18, -1.0E-12, 17, 1.0E-12).parse(IERSConventions.getStream(K21_FREQUENCY_DEPENDENCE), K21_FREQUENCY_DEPENDENCE);
            PoissonSeries c22Series = k22Parser.withSinCos(0, -1, 1.0E-12, 16, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            PoissonSeries s22Series = k22Parser.withSinCos(0, 16, -1.0E-12, -1, 1.0E-12).parse(IERSConventions.getStream(K22_FREQUENCY_DEPENDENCE), K22_FREQUENCY_DEPENDENCE);
            final PoissonSeries.CompiledSeries kSeries = PoissonSeries.compile(c20Series, c21Series, s21Series, c22Series, s22Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    return kSeries.value(arguments.evaluateAll(date));
                }
            };
        }

        @Override
        public double getPermanentTide() throws OrekitException {
            return -1.39141288E-8 * this.getLoveNumbers().getReal(2, 0);
        }

        private double[] computePoleWobble(AbsoluteDate date, EOPHistory eopHistory) {
            int i;
            double[] yPolynomial;
            double[] xPolynomial;
            double f0 = 4.84813681109536E-9;
            double f1 = 1.5362818500441607E-16;
            double f2 = 4.868183417129822E-24;
            double f3 = 1.5426342361680932E-31;
            AbsoluteDate changeDate = new AbsoluteDate(2010, 1, 1, (TimeScale)TimeScalesFactory.getTT());
            if (date.compareTo(changeDate) <= 0) {
                xPolynomial = new double[]{2.713696098642517E-7, 2.802638979035562E-16, 8.96378612596114E-25, 1.0835462874844687E-33};
                yPolynomial = new double[]{1.6791327919756337E-6, 2.74932999883903E-16, -5.223073988238586E-25, -1.4007118864406287E-34};
            } else {
                xPolynomial = new double[]{1.1399424083928521E-7, 1.1697403634421242E-15};
                yPolynomial = new double[]{1.7399526682708251E-6, -9.658603991227639E-17};
            }
            double meanPoleX = 0.0;
            double meanPoleY = 0.0;
            double t = date.durationFrom(AbsoluteDate.J2000_EPOCH);
            for (i = xPolynomial.length - 1; i >= 0; --i) {
                meanPoleX = meanPoleX * t + xPolynomial[i];
            }
            for (i = yPolynomial.length - 1; i >= 0; --i) {
                meanPoleY = meanPoleY * t + yPolynomial[i];
            }
            PoleCorrection correction = eopHistory.getPoleCorrection(date);
            double m1 = correction.getXp() - meanPoleX;
            double m2 = meanPoleY - correction.getYp();
            return new double[]{m1, m2};
        }

        @Override
        public TimeFunction<double[]> getSolidPoleTide(final EOPHistory eopHistory) throws OrekitException {
            double globalFactor = -2.749509867273795E-4;
            double ratio = 0.00115;
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double[] wobbleM = this.computePoleWobble(date, eopHistory);
                    return new double[]{-2.749509867273795E-4 * (wobbleM[0] + 0.00115 * wobbleM[1]), -2.749509867273795E-4 * (wobbleM[1] - 0.00115 * wobbleM[0])};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getOceanPoleTide(final EOPHistory eopHistory) throws OrekitException {
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double[] wobbleM = this.computePoleWobble(date, eopHistory);
                    return new double[]{-2.1778E-10 * (wobbleM[0] - 0.01724 * wobbleM[1]) / 4.84813681109536E-6, -1.7232E-10 * (wobbleM[1] - 0.03365 * wobbleM[0]) / 4.84813681109536E-6};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getPrecessionFunction() throws OrekitException {
            final PolynomialNutation psiA = new PolynomialNutation(0.0, 0.024427247666109923, -5.23117307131589E-6, -5.529057626213704E-9, 6.440798234908296E-10, -4.610578107351687E-13);
            final PolynomialNutation omegaA = new PolynomialNutation(this.getMeanObliquityFunction().value(this.getNutationReferenceEpoch()), -1.2485891543294988E-7, 2.4852664365141367E-7, -3.745200230981599E-8, -2.264079890781533E-12, 1.6178232538625214E-12);
            final PolynomialNutation chiA = new PolynomialNutation(0.0, 5.117888597705749E-5, -1.1545494567537374E-5, -5.875796370943243E-9, 8.273975725919673E-10, -2.7149566142134015E-13);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    double tc = this.evaluateTC(date);
                    return new double[]{psiA.value(tc), omegaA.value(tc), chiA.value(tc)};
                }
            };
        }

        @Override
        public TimeFunction<double[]> getNutationFunction() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeries psiSeries = parser.parse(IERSConventions.getStream(PSI_SERIES), PSI_SERIES);
            PoissonSeries epsilonSeries = parser.parse(IERSConventions.getStream(EPSILON_SERIES), EPSILON_SERIES);
            final PoissonSeries.CompiledSeries psiEpsilonSeries = PoissonSeries.compile(psiSeries, epsilonSeries);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] psiEpsilon = psiEpsilonSeries.value(elements);
                    return new double[]{psiEpsilon[0], psiEpsilon[1], IAU1994ResolutionC7.value(elements)};
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGMSTFunction(TimeScale ut1) throws OrekitException {
            final StellarAngleCapitaine era = new StellarAngleCapitaine(ut1);
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser parser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12).withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            final PolynomialNutation minusEO = parser.parse(IERSConventions.getStream(GST_SERIES), GST_SERIES).getPolynomial();
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    return era.value(date).add(minusEO.value(this.dsEvaluateTC(date)));
                }
            };
        }

        @Override
        public TimeFunction<DerivativeStructure> getGASTFunction(TimeScale ut1, final EOPHistory eopHistory) throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(null);
            final TimeFunction<Double> epsilon = this.getMeanObliquityFunction();
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser baseParser = new PoissonSeriesParser(17).withFirstDelaunay(4).withFirstPlanetary(9).withSinCos(0, 2, 4.84813681109536E-12, 3, 4.84813681109536E-12);
            PoissonSeriesParser gstParser = baseParser.withPolynomialPart('t', PolynomialParser.Unit.ARC_SECONDS);
            PoissonSeries psiSeries = baseParser.parse(IERSConventions.getStream(PSI_SERIES), PSI_SERIES);
            PoissonSeries gstSeries = gstParser.parse(IERSConventions.getStream(GST_SERIES), GST_SERIES);
            final PoissonSeries.CompiledSeries psiGstSeries = PoissonSeries.compile(psiSeries, gstSeries);
            final TimeFunction<DerivativeStructure> era = this.getEarthOrientationAngleFunction(ut1);
            return new TimeFunction<DerivativeStructure>(){

                @Override
                public DerivativeStructure value(AbsoluteDate date) {
                    BodiesElements elements = arguments.evaluateAll(date);
                    double[] angles = psiGstSeries.value(elements);
                    double ddPsi = eopHistory == null ? 0.0 : eopHistory.getEquinoxNutationCorrection(date)[0];
                    double deltaPsi = angles[0] + ddPsi;
                    double epsilonA = (Double)epsilon.value(date);
                    return ((DerivativeStructure)era.value(date)).add(deltaPsi * FastMath.cos((double)epsilonA) + angles[1]);
                }
            };
        }

        @Override
        public TimeFunction<double[]> getEOPTidalCorrection() throws OrekitException {
            final FundamentalNutationArguments arguments = this.getNutationArguments(TimeScalesFactory.getTT());
            double microAS = 4.84813681109536E-12;
            PoissonSeriesParser xyParser = new PoissonSeriesParser(13).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3);
            PoissonSeries xSeries = xyParser.withSinCos(0, 10, 4.84813681109536E-12, 11, 4.84813681109536E-12).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            PoissonSeries ySeries = xyParser.withSinCos(0, 12, 4.84813681109536E-12, 13, 4.84813681109536E-12).parse(IERSConventions.getStream(TIDAL_CORRECTION_XP_YP_SERIES), TIDAL_CORRECTION_XP_YP_SERIES);
            double microS = 1.0E-6;
            PoissonSeriesParser ut1Parser = new PoissonSeriesParser(11).withOptionalColumn(1).withGamma(2).withFirstDelaunay(3).withSinCos(0, 10, 1.0E-6, 11, 1.0E-6);
            PoissonSeries ut1Series = ut1Parser.parse(IERSConventions.getStream(TIDAL_CORRECTION_UT1_SERIES), TIDAL_CORRECTION_UT1_SERIES);
            final PoissonSeries.CompiledSeries correctionSeries = PoissonSeries.compile(xSeries, ySeries, ut1Series);
            return new TimeFunction<double[]>(){

                @Override
                public double[] value(AbsoluteDate date) {
                    FieldBodiesElements<DerivativeStructure> elements = arguments.evaluateDerivative(date);
                    DerivativeStructure[] correction = (DerivativeStructure[])correctionSeries.value(elements);
                    return new double[]{correction[0].getValue(), correction[1].getValue(), correction[2].getValue(), -correction[2].getPartialDerivative(new int[]{1}) * 86400.0};
                }
            };
        }
    };

    private static final String IERS_BASE = "/assets/org/orekit/IERS-conventions/";

    public AbsoluteDate getNutationReferenceEpoch() {
        return AbsoluteDate.J2000_EPOCH;
    }

    public double evaluateTC(AbsoluteDate date) {
        return date.durationFrom(this.getNutationReferenceEpoch()) / 3.15576E9;
    }

    public DerivativeStructure dsEvaluateTC(AbsoluteDate date) {
        return new DerivativeStructure(1, 1, new double[]{this.evaluateTC(date), 3.168808781402895E-10});
    }

    public abstract FundamentalNutationArguments getNutationArguments(TimeScale var1) throws OrekitException;

    public abstract TimeFunction<Double> getMeanObliquityFunction() throws OrekitException;

    public abstract TimeFunction<double[]> getXYSpXY2Function() throws OrekitException;

    public TimeFunction<DerivativeStructure> getEarthOrientationAngleFunction(TimeScale ut1) {
        return new StellarAngleCapitaine(ut1);
    }

    public abstract TimeFunction<double[]> getPrecessionFunction() throws OrekitException;

    public abstract TimeFunction<double[]> getNutationFunction() throws OrekitException;

    public abstract TimeFunction<DerivativeStructure> getGMSTFunction(TimeScale var1) throws OrekitException;

    public abstract TimeFunction<DerivativeStructure> getGASTFunction(TimeScale var1, EOPHistory var2) throws OrekitException;

    public abstract TimeFunction<double[]> getEOPTidalCorrection() throws OrekitException;

    public abstract LoveNumbers getLoveNumbers() throws OrekitException;

    public abstract TimeFunction<double[]> getTideFrequencyDependenceFunction(TimeScale var1) throws OrekitException;

    public abstract double getPermanentTide() throws OrekitException;

    public abstract TimeFunction<double[]> getSolidPoleTide(EOPHistory var1) throws OrekitException;

    public abstract TimeFunction<double[]> getOceanPoleTide(EOPHistory var1) throws OrekitException;

    public NutationCorrectionConverter getNutationCorrectionConverter() throws OrekitException {
        final TimeFunction<double[]> precessionFunction = this.getPrecessionFunction();
        final TimeFunction<Double> epsilonAFunction = this.getMeanObliquityFunction();
        AbsoluteDate date0 = this.getNutationReferenceEpoch();
        final double cosE0 = FastMath.cos((double)epsilonAFunction.value(date0));
        return new NutationCorrectionConverter(){

            @Override
            public double[] toNonRotating(AbsoluteDate date, double ddPsi, double ddEpsilon) throws OrekitException {
                double[] angles = (double[])precessionFunction.value(date);
                double sinEA = FastMath.sin((double)((Double)epsilonAFunction.value(date)));
                double c = angles[0] * cosE0 - angles[2];
                return new double[]{sinEA * ddPsi + c * ddEpsilon, ddEpsilon - c * sinEA * ddPsi};
            }

            @Override
            public double[] toEquinox(AbsoluteDate date, double dX, double dY) throws OrekitException {
                double[] angles = (double[])precessionFunction.value(date);
                double sinEA = FastMath.sin((double)((Double)epsilonAFunction.value(date)));
                double c = angles[0] * cosE0 - angles[2];
                double opC2 = 1.0 + c * c;
                return new double[]{(dX - c * dY) / (sinEA * opC2), (dY + c * dX) / opC2};
            }
        };
    }

    protected LoveNumbers loadLoveNumbers(String nameLove) throws OrekitException {
        InputStream stream = null;
        BufferedReader reader = null;
        try {
            double[][] real = new double[4][];
            double[][] imaginary = new double[4][];
            double[][] plus = new double[4][];
            for (int i = 0; i < real.length; ++i) {
                real[i] = new double[i + 1];
                imaginary[i] = new double[i + 1];
                plus[i] = new double[i + 1];
            }
            stream = IERSConventions.class.getResourceAsStream(nameLove);
            if (stream == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, nameLove);
            }
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            String line = reader.readLine();
            int lineNumber = 1;
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
                    String[] fields = line.split("\\p{Space}+");
                    if (fields.length != 5) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, nameLove, line);
                    }
                    int n = Integer.parseInt(fields[0]);
                    int m = Integer.parseInt(fields[1]);
                    if (n < 2 || n > 3 || m < 0 || m > n) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, lineNumber, nameLove, line);
                    }
                    real[n][m] = Double.parseDouble(fields[2]);
                    imaginary[n][m] = Double.parseDouble(fields[3]);
                    plus[n][m] = Double.parseDouble(fields[4]);
                }
                ++lineNumber;
                line = reader.readLine();
            }
            LoveNumbers loveNumbers = new LoveNumbers(real, imaginary, plus);
            return loveNumbers;
        }
        catch (IOException ioe) {
            throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, nameLove);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    private static InputStream getStream(String name) {
        return IERSConventions.class.getResourceAsStream(name);
    }

    private static class MeanPole
    implements TimeStamped,
    Serializable {
        private static final long serialVersionUID = 20131028L;
        private final AbsoluteDate date;
        private double x;
        private double y;

        public MeanPole(AbsoluteDate date, double x, double y) {
            this.date = date;
            this.x = x;
            this.y = y;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    private static class StellarAngleCapitaine
    implements TimeFunction<DerivativeStructure> {
        private static final AbsoluteDate REFERENCE_DATE = new AbsoluteDate(DateComponents.J2000_EPOCH, TimeComponents.H12, (TimeScale)TimeScalesFactory.getTAI());
        private static final double ERA_0 = 4.894961212823756;
        private static final double ERA_1A = 7.27220521664304E-5;
        private static final double ERA_1B = 1.99099300639395E-7;
        private static final double ERA_1AB = 7.292115146706979E-5;
        private final TimeScale ut1;

        public StellarAngleCapitaine(TimeScale ut1) {
            this.ut1 = ut1;
        }

        @Override
        public DerivativeStructure value(AbsoluteDate date) {
            int secondsInDay = 86400;
            double dt = date.durationFrom(REFERENCE_DATE);
            long days = (long)dt / 86400L;
            double dtA = 86400L * days;
            double dtB = dt - dtA + this.ut1.offsetFromTAI(date);
            return new DerivativeStructure(1, 1, new double[]{4.894961212823756 + 7.27220521664304E-5 * dtB + 1.99099300639395E-7 * (dtA + dtB), 7.292115146706979E-5});
        }
    }

    private static class IAU1994ResolutionC7 {
        private static final double EQE1 = 1.2799081181291749E-8;
        private static final double EQE2 = 3.0543261909900767E-10;
        private static final AbsoluteDate MODEL_START = new AbsoluteDate(1997, 2, 27, 0, 0, 30.0, (TimeScale)TimeScalesFactory.getTAI());

        private IAU1994ResolutionC7() {
        }

        public static double value(DelaunayArguments arguments) {
            if (arguments.getDate().compareTo(MODEL_START) >= 0) {
                double om = arguments.getOmega();
                return 1.2799081181291749E-8 * FastMath.sin((double)om) + 3.0543261909900767E-10 * FastMath.sin((double)(om + om));
            }
            return 0.0;
        }
    }

    public static interface NutationCorrectionConverter {
        public double[] toNonRotating(AbsoluteDate var1, double var2, double var4) throws OrekitException;

        public double[] toEquinox(AbsoluteDate var1, double var2, double var4) throws OrekitException;
    }
}

