/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.orekit.errors.OrekitException;
import org.orekit.errors.TimeStampedCacheException;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TAIScale;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCTAIOffset;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.TimeStampedCache;

public class UTCScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private transient TimeStampedCache<UTCTAIOffset> cache;

    UTCScale(SortedMap<DateComponents, Integer> entries) throws OrekitException {
        List<UTCTAIOffset> data = new Generator(entries).getOffsets();
        this.cache = new ImmutableTimeStampedCache<UTCTAIOffset>(2, data);
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        if (this.cache.getEarliest().getDate().compareTo(date) > 0) {
            return 0.0;
        }
        if (this.cache.getLatest().getDate().compareTo(date) < 0) {
            return -this.cache.getLatest().getOffset(date);
        }
        try {
            return -this.cache.getNeighbors(date).get(0).getOffset(date);
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    @Override
    public double offsetToTAI(DateComponents date, TimeComponents time) {
        if (this.cache.getEarliest().getMJD() > date.getMJD()) {
            return 0.0;
        }
        if (this.cache.getLatest().getMJD() <= date.getMJD()) {
            return this.cache.getLatest().getOffset(date, time);
        }
        try {
            List<UTCTAIOffset> neighbors = this.cache.getNeighbors(new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI()));
            if (neighbors.get(1).getMJD() <= date.getMJD()) {
                return neighbors.get(1).getOffset(date, time);
            }
            return neighbors.get(0).getOffset(date, time);
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    @Override
    public String getName() {
        return "UTC";
    }

    public String toString() {
        return this.getName();
    }

    public AbsoluteDate getFirstKnownLeapSecond() {
        return this.cache.getEarliest().getDate();
    }

    public AbsoluteDate getLastKnownLeapSecond() {
        return this.cache.getLatest().getDate();
    }

    public boolean insideLeap(AbsoluteDate date) {
        if (this.cache.getEarliest().getDate().compareTo(date) > 0) {
            return false;
        }
        if (this.cache.getLatest().getDate().compareTo(date) < 0) {
            return date.compareTo(this.cache.getLatest().getValidityStart()) < 0;
        }
        try {
            return date.compareTo(this.cache.getNeighbors(date).get(0).getValidityStart()) < 0;
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    public double getLeap(AbsoluteDate date) {
        if (this.cache.getEarliest().getDate().compareTo(date) > 0) {
            return 0.0;
        }
        if (this.cache.getLatest().getDate().compareTo(date) < 0) {
            return this.cache.getLatest().getLeap();
        }
        try {
            return this.cache.getNeighbors(date).get(0).getLeap();
        }
        catch (TimeStampedCacheException tce) {
            throw OrekitException.createInternalError(tce);
        }
    }

    private Object writeReplace() {
        return new DataTransferObject();
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20131209L;

        private DataTransferObject() {
        }

        private Object readResolve() {
            try {
                return TimeScalesFactory.getUTC();
            }
            catch (OrekitException oe) {
                throw OrekitException.createInternalError(oe);
            }
        }
    }

    private static class Generator {
        private final List<UTCTAIOffset> offsets = new ArrayList<UTCTAIOffset>();

        public Generator(SortedMap<DateComponents, Integer> entries) {
            this.addOffsetModel(new DateComponents(1961, 1, 1), 37300, 1.422818, 0.001296);
            this.addOffsetModel(new DateComponents(1961, 8, 1), 37300, 1.372818, 0.001296);
            this.addOffsetModel(new DateComponents(1962, 1, 1), 37665, 1.845858, 0.0011232);
            this.addOffsetModel(new DateComponents(1963, 11, 1), 37665, 1.945858, 0.0011232);
            this.addOffsetModel(new DateComponents(1964, 1, 1), 38761, 3.24013, 0.001296);
            this.addOffsetModel(new DateComponents(1964, 4, 1), 38761, 3.34013, 0.001296);
            this.addOffsetModel(new DateComponents(1964, 9, 1), 38761, 3.44013, 0.001296);
            this.addOffsetModel(new DateComponents(1965, 1, 1), 38761, 3.54013, 0.001296);
            this.addOffsetModel(new DateComponents(1965, 3, 1), 38761, 3.64013, 0.001296);
            this.addOffsetModel(new DateComponents(1965, 7, 1), 38761, 3.74013, 0.001296);
            this.addOffsetModel(new DateComponents(1965, 9, 1), 38761, 3.84013, 0.001296);
            this.addOffsetModel(new DateComponents(1966, 1, 1), 39126, 4.31317, 0.002592);
            this.addOffsetModel(new DateComponents(1968, 2, 1), 39126, 4.21317, 0.002592);
            for (Map.Entry<DateComponents, Integer> entry : entries.entrySet()) {
                this.addOffsetModel(entry.getKey(), 0, entry.getValue().intValue(), 0.0);
            }
        }

        public List<UTCTAIOffset> getOffsets() {
            return this.offsets;
        }

        private void addOffsetModel(DateComponents date, int mjdRef, double offset, double slope) {
            TAIScale tai = TimeScalesFactory.getTAI();
            UTCTAIOffset previous = this.offsets.isEmpty() ? null : this.offsets.get(this.offsets.size() - 1);
            double previousOffset = previous == null ? 0.0 : previous.getOffset(date, TimeComponents.H00);
            AbsoluteDate leapStart = new AbsoluteDate(date, (TimeScale)tai).shiftedBy(previousOffset);
            double startOffset = offset + slope * (double)(date.getMJD() - mjdRef);
            AbsoluteDate leapEnd = new AbsoluteDate(date, (TimeScale)tai).shiftedBy(startOffset);
            double normalizedSlope = slope / 86400.0;
            double leap = leapEnd.durationFrom(leapStart) / (1.0 + normalizedSlope);
            if (previous != null) {
                previous.setValidityEnd(leapStart);
            }
            this.offsets.add(new UTCTAIOffset(leapStart, date.getMJD(), leap, offset, mjdRef, normalizedSlope));
        }
    }
}

