/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.TreeMap;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;

public class LnsCoefficients {
    private final double[][] lns;
    private final double[][] dlns;

    public LnsCoefficients(int nMax, int sMax, double[][] Qns, TreeMap<CoefficientsFactory.NSKey, Double> Vns, double roa) {
        this.lns = new double[nMax + 1][sMax + 1];
        this.dlns = new double[nMax + 1][sMax + 1];
        double[] roaPow = new double[nMax + 1];
        roaPow[0] = 1.0;
        for (int i = 1; i <= nMax; ++i) {
            roaPow[i] = roa * roaPow[i - 1];
        }
        for (int s = 0; s <= sMax; ++s) {
            for (int n = s; n <= nMax; ++n) {
                if ((n - s) % 2 == 0) {
                    double coef = roaPow[n] * Vns.get(new CoefficientsFactory.NSKey(n, s));
                    this.lns[n][s] = coef * Qns[n][s];
                    if (n == s) {
                        this.dlns[n][s] = 0.0;
                        continue;
                    }
                    this.dlns[n][s] = coef * Qns[n][s + 1];
                    continue;
                }
                this.lns[n][s] = 0.0;
                this.dlns[n][s] = 0.0;
            }
        }
    }

    public double getLns(int n, int s) {
        return this.lns[n][s];
    }

    public double getdLnsdGamma(int n, int s) {
        return this.dlns[n][s];
    }
}

