/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class OrekitStepNormalizer
implements OrekitStepHandler {
    private double h;
    private OrekitFixedStepHandler handler;
    private AbsoluteDate lastDate;
    private SpacecraftState lastState;
    private boolean forward;

    public OrekitStepNormalizer(double h, OrekitFixedStepHandler handler) {
        this.h = FastMath.abs((double)h);
        this.handler = handler;
        this.lastDate = null;
        this.lastState = null;
        this.forward = true;
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    @Override
    public void init(SpacecraftState s0, AbsoluteDate t) throws PropagationException {
        this.lastDate = null;
        this.lastState = null;
        this.forward = true;
        this.handler.init(s0, t);
    }

    @Override
    public void handleStep(OrekitStepInterpolator interpolator, boolean isLast) throws PropagationException {
        try {
            AbsoluteDate nextTime;
            if (this.lastState == null) {
                this.lastDate = interpolator.getPreviousDate();
                interpolator.setInterpolatedDate(this.lastDate);
                this.lastState = interpolator.getInterpolatedState();
                boolean bl = this.forward = interpolator.getCurrentDate().compareTo(this.lastDate) >= 0;
                if (!this.forward) {
                    this.h = -this.h;
                }
            }
            boolean nextInStep = this.forward ^ (nextTime = this.lastDate.shiftedBy(this.h)).compareTo(interpolator.getCurrentDate()) > 0;
            while (nextInStep) {
                this.handler.handleStep(this.lastState, false);
                this.lastDate = nextTime;
                interpolator.setInterpolatedDate(this.lastDate);
                this.lastState = interpolator.getInterpolatedState();
                nextTime = nextTime.shiftedBy(this.h);
                nextInStep = this.forward ^ nextTime.compareTo(interpolator.getCurrentDate()) > 0;
            }
            if (isLast) {
                this.handler.handleStep(this.lastState, true);
            }
        }
        catch (OrekitException oe) {
            for (Throwable t = oe; t != null; t = t.getCause()) {
                if (!(t instanceof PropagationException)) continue;
                throw (PropagationException)t;
            }
            throw new PropagationException(oe);
        }
    }
}

