/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.FieldRotation;
import org.apache.commons.math3.geometry.euclidean.threed.FieldVector3D;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AdditionalEquations;
import org.orekit.propagation.numerical.JacobiansMapper;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.propagation.numerical.ParameterConfiguration;

public class PartialDerivativesEquations
implements AdditionalEquations {
    private NumericalPropagator propagator;
    private final List<ForceModel> derivativesProviders;
    private List<ParameterConfiguration> selectedParameters;
    private String name;
    private int stateDim;
    private int paramDim;
    private double hPos;
    private boolean dirty = false;
    private transient double[][] dAccdPos;
    private transient double[][] dAccdVel;
    private transient double[] dAccdM;
    private transient double[] dAccdParam;

    public PartialDerivativesEquations(String name, NumericalPropagator propagator) throws OrekitException {
        this.name = name;
        this.derivativesProviders = new ArrayList<ForceModel>();
        this.dirty = true;
        this.propagator = propagator;
        this.selectedParameters = new ArrayList<ParameterConfiguration>();
        this.stateDim = -1;
        this.paramDim = -1;
        this.hPos = Double.NaN;
        propagator.addAdditionalEquations(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getAvailableParameters() {
        ArrayList<String> available = new ArrayList<String>();
        available.addAll(this.propagator.getNewtonianAttractionForceModel().getParametersNames());
        for (ForceModel model : this.propagator.getForceModels()) {
            available.addAll(model.getParametersNames());
        }
        return available;
    }

    public void selectParameters(String ... parameters) {
        this.selectedParameters.clear();
        for (String param : parameters) {
            this.selectedParameters.add(new ParameterConfiguration(param, Double.NaN));
        }
        this.dirty = true;
    }

    public void selectParamAndStep(String parameter, double hP) {
        this.selectedParameters.add(new ParameterConfiguration(parameter, hP));
        this.dirty = true;
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s0, int stateDimension, int paramDimension) throws OrekitException {
        double[][] dYdY0 = new double[stateDimension][stateDimension];
        double[][] dYdP = new double[stateDimension][paramDimension];
        for (int i = 0; i < stateDimension; ++i) {
            dYdY0[i][i] = 1.0;
        }
        return this.setInitialJacobians(s0, dYdY0, dYdP);
    }

    public SpacecraftState setInitialJacobians(SpacecraftState s1, double[][] dY1dY0, double[][] dY1dP) throws OrekitException {
        this.stateDim = dY1dY0.length;
        if (this.stateDim < 6 || this.stateDim > 7 || this.stateDim != dY1dY0[0].length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NEITHER_6X6_NOR_7X7, this.stateDim, dY1dY0[0].length);
        }
        if (dY1dP != null && this.stateDim != dY1dP.length) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_AND_PARAMETERS_JACOBIANS_ROWS_MISMATCH, this.stateDim, dY1dP.length);
        }
        this.paramDim = dY1dP == null ? 0 : dY1dP[0].length;
        JacobiansMapper mapper = this.getMapper();
        double[] p = new double[mapper.getAdditionalStateDimension()];
        mapper.setInitialJacobians(s1, dY1dY0, dY1dP, p);
        return s1.addAdditionalState(this.name, p);
    }

    public JacobiansMapper getMapper() throws OrekitException {
        if (this.stateDim < 0) {
            throw new OrekitException((Localizable)OrekitMessages.STATE_JACOBIAN_NOT_INITIALIZED, new Object[0]);
        }
        return new JacobiansMapper(this.name, this.stateDim, this.paramDim, this.propagator.getOrbitType(), this.propagator.getPositionAngleType());
    }

    @Override
    public double[] computeDerivatives(SpacecraftState s, double[] pDot) throws OrekitException {
        int dim = 3;
        if (this.dirty) {
            if (Double.isNaN(this.hPos)) {
                this.hPos = FastMath.sqrt((double)Precision.EPSILON) * s.getPVCoordinates().getPosition().getNorm();
            }
            this.derivativesProviders.clear();
            this.derivativesProviders.addAll(this.propagator.getForceModels());
            this.derivativesProviders.add(this.propagator.getNewtonianAttractionForceModel());
            for (ParameterConfiguration param : this.selectedParameters) {
                String parameterName = param.getParameterName();
                boolean found = false;
                for (ForceModel provider : this.derivativesProviders) {
                    if (!provider.isSupported(parameterName)) continue;
                    param.setProvider(provider);
                    found = true;
                }
                if (found) continue;
                TreeSet<String> set = new TreeSet<String>();
                for (ForceModel provider : this.derivativesProviders) {
                    for (String forceModelParameter : provider.getParametersNames()) {
                        set.add(forceModelParameter);
                    }
                }
                StringBuilder builder = new StringBuilder();
                for (String forceModelParameter : set) {
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(forceModelParameter);
                }
                throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, parameterName, builder.toString());
            }
            if (this.selectedParameters.size() != this.paramDim) {
                throw new OrekitException((Localizable)OrekitMessages.INITIAL_MATRIX_AND_PARAMETERS_NUMBER_MISMATCH, this.paramDim, this.selectedParameters.size());
            }
            this.dAccdParam = new double[3];
            this.dAccdPos = new double[3][3];
            this.dAccdVel = new double[3][3];
            this.dAccdM = this.stateDim > 6 ? new double[3] : null;
            this.dirty = false;
        }
        for (double[] row : this.dAccdPos) {
            Arrays.fill(row, 0.0);
        }
        for (double[] row : this.dAccdVel) {
            Arrays.fill(row, 0.0);
        }
        if (this.dAccdM != null) {
            Arrays.fill(this.dAccdM, 0.0);
        }
        int nbVars = this.dAccdM == null ? 6 : 7;
        Vector3D position = s.getPVCoordinates().getPosition();
        FieldVector3D dsP = new FieldVector3D((RealFieldElement)new DerivativeStructure(nbVars, 1, 0, position.getX()), (RealFieldElement)new DerivativeStructure(nbVars, 1, 1, position.getY()), (RealFieldElement)new DerivativeStructure(nbVars, 1, 2, position.getZ()));
        Vector3D velocity = s.getPVCoordinates().getVelocity();
        FieldVector3D dsV = new FieldVector3D((RealFieldElement)new DerivativeStructure(nbVars, 1, 3, velocity.getX()), (RealFieldElement)new DerivativeStructure(nbVars, 1, 4, velocity.getY()), (RealFieldElement)new DerivativeStructure(nbVars, 1, 5, velocity.getZ()));
        DerivativeStructure dsM = this.dAccdM == null ? new DerivativeStructure(nbVars, 1, s.getMass()) : new DerivativeStructure(nbVars, 1, 6, s.getMass());
        Rotation rotation = s.getAttitude().getRotation();
        FieldRotation dsR = new FieldRotation((RealFieldElement)new DerivativeStructure(nbVars, 1, rotation.getQ0()), (RealFieldElement)new DerivativeStructure(nbVars, 1, rotation.getQ1()), (RealFieldElement)new DerivativeStructure(nbVars, 1, rotation.getQ2()), (RealFieldElement)new DerivativeStructure(nbVars, 1, rotation.getQ3()), false);
        for (ForceModel derivativesProvider : this.derivativesProviders) {
            FieldVector3D<DerivativeStructure> acceleration = derivativesProvider.accelerationDerivatives(s.getDate(), s.getFrame(), (FieldVector3D<DerivativeStructure>)dsP, (FieldVector3D<DerivativeStructure>)dsV, (FieldRotation<DerivativeStructure>)dsR, dsM);
            this.addToRow((DerivativeStructure)acceleration.getX(), 0);
            this.addToRow((DerivativeStructure)acceleration.getY(), 1);
            this.addToRow((DerivativeStructure)acceleration.getZ(), 2);
        }
        double[] p = s.getAdditionalState(this.getName());
        System.arraycopy(p, 3 * this.stateDim, pDot, 0, 3 * this.stateDim);
        for (int i = 0; i < 3; ++i) {
            double[] dAdPi = this.dAccdPos[i];
            double[] dAdVi = this.dAccdVel[i];
            for (int j = 0; j < this.stateDim; ++j) {
                pDot[(3 + i) * this.stateDim + j] = dAdPi[0] * p[j] + dAdPi[1] * p[j + this.stateDim] + dAdPi[2] * p[j + 2 * this.stateDim] + dAdVi[0] * p[j + 3 * this.stateDim] + dAdVi[1] * p[j + 4 * this.stateDim] + dAdVi[2] * p[j + 5 * this.stateDim] + (this.dAccdM == null ? 0.0 : this.dAccdM[i] * p[j + 6 * this.stateDim]);
            }
        }
        if (this.dAccdM != null) {
            Arrays.fill(pDot, 6 * this.stateDim, 7 * this.stateDim, 0.0);
        }
        for (int k = 0; k < this.paramDim; ++k) {
            ParameterConfiguration param = this.selectedParameters.get(k);
            ForceModel provider = param.getProvider();
            FieldVector3D<DerivativeStructure> accDer = provider.accelerationDerivatives(s, param.getParameterName());
            this.dAccdParam[0] = ((DerivativeStructure)accDer.getX()).getPartialDerivative(new int[]{1});
            this.dAccdParam[1] = ((DerivativeStructure)accDer.getY()).getPartialDerivative(new int[]{1});
            this.dAccdParam[2] = ((DerivativeStructure)accDer.getZ()).getPartialDerivative(new int[]{1});
            int columnTop = this.stateDim * this.stateDim + k;
            pDot[columnTop] = p[columnTop + 3 * this.paramDim];
            pDot[columnTop + this.paramDim] = p[columnTop + 4 * this.paramDim];
            pDot[columnTop + 2 * this.paramDim] = p[columnTop + 5 * this.paramDim];
            for (int i = 0; i < 3; ++i) {
                double[] dAdPi = this.dAccdPos[i];
                double[] dAdVi = this.dAccdVel[i];
                pDot[columnTop + (3 + i) * this.paramDim] = this.dAccdParam[i] + dAdPi[0] * p[columnTop] + dAdPi[1] * p[columnTop + this.paramDim] + dAdPi[2] * p[columnTop + 2 * this.paramDim] + dAdVi[0] * p[columnTop + 3 * this.paramDim] + dAdVi[1] * p[columnTop + 4 * this.paramDim] + dAdVi[2] * p[columnTop + 5 * this.paramDim] + (this.dAccdM == null ? 0.0 : this.dAccdM[i] * p[columnTop + 6 * this.paramDim]);
            }
            if (this.dAccdM == null) continue;
            pDot[columnTop + 6 * this.paramDim] = 0.0;
        }
        return null;
    }

    private void addToRow(DerivativeStructure accelerationComponent, int index) {
        if (this.dAccdM == null) {
            double[] dArray = this.dAccdPos[index];
            dArray[0] = dArray[0] + accelerationComponent.getPartialDerivative(new int[]{1, 0, 0, 0, 0, 0});
            double[] dArray2 = this.dAccdPos[index];
            dArray2[1] = dArray2[1] + accelerationComponent.getPartialDerivative(new int[]{0, 1, 0, 0, 0, 0});
            double[] dArray3 = this.dAccdPos[index];
            dArray3[2] = dArray3[2] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 1, 0, 0, 0});
            double[] dArray4 = this.dAccdVel[index];
            dArray4[0] = dArray4[0] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 1, 0, 0});
            double[] dArray5 = this.dAccdVel[index];
            dArray5[1] = dArray5[1] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 0, 1, 0});
            double[] dArray6 = this.dAccdVel[index];
            dArray6[2] = dArray6[2] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 0, 0, 1});
        } else {
            double[] dArray = this.dAccdPos[index];
            dArray[0] = dArray[0] + accelerationComponent.getPartialDerivative(new int[]{1, 0, 0, 0, 0, 0, 0});
            double[] dArray7 = this.dAccdPos[index];
            dArray7[1] = dArray7[1] + accelerationComponent.getPartialDerivative(new int[]{0, 1, 0, 0, 0, 0, 0});
            double[] dArray8 = this.dAccdPos[index];
            dArray8[2] = dArray8[2] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 1, 0, 0, 0, 0});
            double[] dArray9 = this.dAccdVel[index];
            dArray9[0] = dArray9[0] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 1, 0, 0, 0});
            double[] dArray10 = this.dAccdVel[index];
            dArray10[1] = dArray10[1] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 0, 1, 0, 0});
            double[] dArray11 = this.dAccdVel[index];
            dArray11[2] = dArray11[2] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 0, 0, 1, 0});
            int n = index;
            this.dAccdM[n] = this.dAccdM[n] + accelerationComponent.getPartialDerivative(new int[]{0, 0, 0, 0, 0, 0, 1});
        }
    }
}

