/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.ode.AbstractIntegrator;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.PropagationException;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class NumericalPropagator
extends AbstractIntegratedPropagator {
    private NewtonianAttraction newtonianAttraction;
    private final List<ForceModel> forceModels = new ArrayList<ForceModel>();

    public NumericalPropagator(AbstractIntegrator integrator) {
        super(integrator, true);
        this.initMapper();
        this.setAttitudeProvider(DEFAULT_LAW);
        this.setMu(Double.NaN);
        this.setSlaveMode();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.TRUE);
    }

    @Override
    public void setMu(double mu) {
        super.setMu(mu);
        this.newtonianAttraction = new NewtonianAttraction(mu);
    }

    public void addForceModel(ForceModel model) {
        this.forceModels.add(model);
    }

    public void removeForceModels() {
        this.forceModels.clear();
    }

    public List<ForceModel> getForceModels() {
        return this.forceModels;
    }

    public NewtonianAttraction getNewtonianAttractionForceModel() {
        return this.newtonianAttraction;
    }

    @Override
    public void setOrbitType(OrbitType orbitType) {
        super.setOrbitType(orbitType);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public void setPositionAngleType(PositionAngle positionAngleType) {
        super.setPositionAngleType(positionAngleType);
    }

    @Override
    public PositionAngle getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public void setInitialState(SpacecraftState initialState) throws PropagationException {
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        super.resetInitialState(state);
        if (this.newtonianAttraction == null) {
            this.setMu(state.getMu());
        }
        this.setStartDate(null);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        return new OsculatingMapper(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(AbstractIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, Orbit orbit, OrbitType type) throws PropagationException {
        TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
        double r2 = pv.getPosition().getNormSq();
        double v = pv.getVelocity().getNorm();
        double dV = orbit.getMu() * dP / (v * r2);
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[6] = 1.0E-6;
        if (type == OrbitType.CARTESIAN) {
            absTol[0] = dP;
            absTol[1] = dP;
            absTol[2] = dP;
            absTol[3] = dV;
            absTol[4] = dV;
            absTol[5] = dV;
        } else {
            double[][] jacobian = new double[6][6];
            Orbit converted = type.convertType(orbit);
            converted.getJacobianWrtCartesian(PositionAngle.TRUE, jacobian);
            for (int i = 0; i < 6; ++i) {
                double[] row = jacobian[i];
                absTol[i] = FastMath.abs((double)row[0]) * dP + FastMath.abs((double)row[1]) * dP + FastMath.abs((double)row[2]) * dP + FastMath.abs((double)row[3]) * dV + FastMath.abs((double)row[4]) * dV + FastMath.abs((double)row[5]) * dV;
                if (!Double.isNaN(absTol[i])) continue;
                throw new PropagationException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{type});
            }
        }
        Arrays.fill(relTol, dP / FastMath.sqrt((double)r2));
        return new double[][]{absTol, relTol};
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations,
    TimeDerivativesEquations {
        private final double[] yDot = new double[7];
        private Orbit orbit;
        private double[][] jacobian = new double[6][6];

        public Main(AbstractIntegrator integrator) {
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                EventDetector[] modelDetectors = forceModel.getEventsDetectors();
                if (modelDetectors == null) continue;
                for (EventDetector detector : modelDetectors) {
                    NumericalPropagator.this.setUpEventDetector(integrator, detector);
                }
            }
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) throws OrekitException {
            this.orbit = state.getOrbit();
            Arrays.fill(this.yDot, 0.0);
            this.orbit.getJacobianWrtCartesian(NumericalPropagator.this.getPositionAngleType(), this.jacobian);
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.addContribution(state, this);
            }
            NumericalPropagator.this.newtonianAttraction.addContribution(state, this);
            return (double[])this.yDot.clone();
        }

        @Override
        public void addKeplerContribution(double mu) {
            this.orbit.addKeplerContribution(NumericalPropagator.this.getPositionAngleType(), mu, this.yDot);
        }

        @Override
        public void addXYZAcceleration(double x, double y, double z) {
            int i = 0;
            while (i < 6) {
                double[] jRow = this.jacobian[i];
                int n = i++;
                this.yDot[n] = this.yDot[n] + (jRow[3] * x + jRow[4] * y + jRow[5] * z);
            }
        }

        @Override
        public void addAcceleration(Vector3D gamma, Frame frame) throws OrekitException {
            Transform t = frame.getTransformTo(this.orbit.getFrame(), this.orbit.getDate());
            Vector3D gammInRefFrame = t.transformVector(gamma);
            this.addXYZAcceleration(gammInRefFrame.getX(), gammInRefFrame.getY(), gammInRefFrame.getZ());
        }

        @Override
        public void addMassDerivative(double q) {
            if (q > 0.0) {
                throw OrekitException.createIllegalArgumentException(OrekitMessages.POSITIVE_FLOW_RATE, q);
            }
            this.yDot[6] = this.yDot[6] + q;
        }
    }

    private static class OsculatingMapper
    extends StateMapper
    implements Serializable {
        private static final long serialVersionUID = 20130621L;

        public OsculatingMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(double t, double[] y, boolean meanOnly) throws OrekitException {
            double mass = y[6];
            if (mass <= 0.0) {
                throw new PropagationException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            AbsoluteDate date = this.mapDoubleToDate(t);
            Orbit orbit = this.getOrbitType().mapArrayToOrbit(y, this.getPositionAngleType(), date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new SpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y) {
            this.getOrbitType().mapOrbitToArray(state.getOrbit(), this.getPositionAngleType(), y);
            y[6] = state.getMass();
        }

        private Object writeReplace() throws NotSerializableException {
            return new DataTransferObject(this.getReferenceDate(), this.getMu(), this.getOrbitType(), this.getPositionAngleType(), this.getAttitudeProvider(), this.getFrame());
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20130621L;
            private final AbsoluteDate referenceDate;
            private final double mu;
            private final OrbitType orbitType;
            private final PositionAngle positionAngleType;
            private final AttitudeProvider attitudeProvider;
            private final Frame frame;

            public DataTransferObject(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
                this.referenceDate = referenceDate;
                this.mu = mu;
                this.orbitType = orbitType;
                this.positionAngleType = positionAngleType;
                this.attitudeProvider = attitudeProvider;
                this.frame = frame;
            }

            private Object readResolve() {
                return new OsculatingMapper(this.referenceDate, this.mu, this.orbitType, this.positionAngleType, this.attitudeProvider, this.frame);
            }
        }
    }
}

