/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import java.io.Serializable;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketingNthOrderBrentSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class EventState<T extends EventDetector>
implements Serializable {
    private static final long serialVersionUID = 4489391420715269318L;
    private T detector;
    private AbsoluteDate lastT;
    private double lastG;
    private AbsoluteDate t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private AbsoluteDate pendingEventTime;
    private AbsoluteDate previousEventTime;
    private boolean forward;
    private boolean increasing;
    private EventHandler.Action nextAction;

    public EventState(T detector) {
        this.detector = detector;
        this.t0 = null;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = null;
        this.previousEventTime = null;
        this.increasing = true;
        this.nextAction = EventHandler.Action.CONTINUE;
    }

    public T getEventDetector() {
        return this.detector;
    }

    public void init(SpacecraftState s0, AbsoluteDate t) {
        this.detector.init(s0, t);
        this.lastT = AbsoluteDate.PAST_INFINITY;
        this.lastG = Double.NaN;
    }

    private double g(SpacecraftState s) throws OrekitException {
        if (!s.getDate().equals(this.lastT)) {
            this.lastT = s.getDate();
            this.lastG = this.detector.g(s);
        }
        return this.lastG;
    }

    public void reinitializeBegin(SpacecraftState state0, boolean isForward) throws OrekitException {
        this.t0 = state0.getDate();
        this.g0 = this.g(state0);
        if (this.g0 == 0.0) {
            this.g0 = this.g(state0.shiftedBy((isForward ? 0.5 : -0.5) * this.detector.getThreshold()));
        }
        this.g0Positive = this.g0 >= 0.0;
    }

    public boolean evaluateStep(final OrekitStepInterpolator interpolator) throws OrekitException, TooManyEvaluationsException, NoBracketingException {
        try {
            AbsoluteDate t1;
            double dt;
            double convergence = this.detector.getThreshold();
            int maxIterationcount = this.detector.getMaxIterationCount();
            if (this.forward ^ interpolator.isForward()) {
                this.forward = !this.forward;
                this.pendingEvent = false;
                this.pendingEventTime = null;
                this.previousEventTime = null;
            }
            if (FastMath.abs((double)(dt = (t1 = interpolator.getCurrentDate()).durationFrom(this.t0))) < convergence) {
                return false;
            }
            int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt) / this.detector.getMaxCheckInterval()))));
            double h = dt / (double)n;
            UnivariateFunction f = new UnivariateFunction(){

                public double value(double t) throws LocalWrapperException {
                    try {
                        interpolator.setInterpolatedDate(EventState.this.t0.shiftedBy(t));
                        return EventState.this.g(interpolator.getInterpolatedState());
                    }
                    catch (OrekitException oe) {
                        throw new LocalWrapperException(oe);
                    }
                }
            };
            BracketingNthOrderBrentSolver solver = new BracketingNthOrderBrentSolver(convergence, 5);
            AbsoluteDate ta = this.t0;
            double ga = this.g0;
            for (int i = 0; i < n; ++i) {
                AbsoluteDate tb = this.t0.shiftedBy((double)(i + 1) * h);
                interpolator.setInterpolatedDate(tb);
                double gb = this.g(interpolator.getInterpolatedState());
                if (this.g0Positive ^ gb >= 0.0) {
                    this.increasing = gb >= ga;
                    double dtA = ta.durationFrom(this.t0);
                    double dtB = tb.durationFrom(this.t0);
                    double dtRoot = this.forward ? solver.solve(maxIterationcount, f, dtA, dtB, AllowedSolution.RIGHT_SIDE) : solver.solve(maxIterationcount, f, dtB, dtA, AllowedSolution.LEFT_SIDE);
                    AbsoluteDate root = this.t0.shiftedBy(dtRoot);
                    if (this.previousEventTime != null && FastMath.abs((double)root.durationFrom(ta)) <= convergence && FastMath.abs((double)root.durationFrom(this.previousEventTime)) <= convergence) {
                        while (this.g0Positive ^ (ga = f.value((ta = this.forward ? ta.shiftedBy(convergence) : ta.shiftedBy(-convergence)).durationFrom(this.t0))) >= 0.0 && this.forward ^ ta.compareTo(tb) >= 0) {
                        }
                        --i;
                        continue;
                    }
                    if (this.previousEventTime == null || FastMath.abs((double)this.previousEventTime.durationFrom(root)) > convergence) {
                        this.pendingEventTime = root;
                        this.pendingEvent = true;
                        return true;
                    }
                    ta = tb;
                    ga = gb;
                    continue;
                }
                ta = tb;
                ga = gb;
            }
            this.pendingEvent = false;
            this.pendingEventTime = null;
            return false;
        }
        catch (LocalWrapperException lwe) {
            throw lwe.getWrappedException();
        }
    }

    public AbsoluteDate getEventTime() {
        return this.pendingEventTime;
    }

    public void stepAccepted(SpacecraftState state) throws OrekitException {
        this.t0 = state.getDate();
        this.g0 = this.g(state);
        if (this.pendingEvent) {
            this.previousEventTime = state.getDate();
            this.g0Positive = this.increasing;
            this.nextAction = this.detector.eventOccurred(state, !(this.increasing ^ this.forward));
        } else {
            this.g0Positive = this.g0 >= 0.0;
            this.nextAction = EventHandler.Action.CONTINUE;
        }
    }

    public boolean stop() {
        return this.nextAction == EventHandler.Action.STOP;
    }

    public SpacecraftState reset(SpacecraftState oldState) throws OrekitException {
        if (!this.pendingEvent) {
            return null;
        }
        SpacecraftState newState = this.nextAction != EventHandler.Action.RESET_STATE ? null : this.detector.resetState(oldState);
        this.pendingEvent = false;
        this.pendingEventTime = null;
        return newState;
    }

    private static class LocalWrapperException
    extends RuntimeException {
        private static final long serialVersionUID = 2734331164409224983L;
        private final OrekitException wrappedException;

        public LocalWrapperException(OrekitException wrapped) {
            this.wrappedException = wrapped;
        }

        public OrekitException getWrappedException() {
            return this.wrappedException;
        }
    }
}

