/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScalesFactory;

abstract class SDP4
extends TLEPropagator {
    protected double omgadf;
    protected double xn;
    protected double xll;
    protected double em;
    protected double xinc;

    protected SDP4(TLE initialTLE, AttitudeProvider attitudeProvider, double mass) throws OrekitException {
        super(initialTLE, attitudeProvider, mass);
    }

    @Override
    protected void sxpInitialize() throws OrekitException {
        this.luniSolarTermsComputation();
    }

    @Override
    protected void sxpPropagate(double tSince) {
        this.omgadf = this.tle.getPerigeeArgument() + this.omgdot * tSince;
        double xnoddf = this.tle.getRaan() + this.xnodot * tSince;
        double tSinceSq = tSince * tSince;
        this.xnode = xnoddf + this.xnodcf * tSinceSq;
        this.xn = this.xn0dp;
        this.xll = this.tle.getMeanAnomaly() + this.xmdot * tSince;
        this.deepSecularEffects(tSince);
        double tempa = 1.0 - this.c1 * tSince;
        this.a = FastMath.pow((double)(0.07436691613317341 / this.xn), (double)0.6666666666666666) * tempa * tempa;
        this.em -= this.tle.getBStar() * this.c4 * tSince;
        this.xll += this.xn0dp * this.t2cof * tSinceSq;
        this.deepPeriodicEffects(tSince);
        this.xl = this.xll + this.omgadf + this.xnode;
        this.cosi0 = FastMath.cos((double)this.xinc);
        this.sini0 = FastMath.sin((double)this.xinc);
        this.e = this.em;
        this.i = this.xinc;
        this.omega = this.omgadf;
    }

    protected static double thetaG(AbsoluteDate date) throws OrekitException {
        double omega_E = 1.00273790934;
        double jd = (date.durationFrom(AbsoluteDate.JULIAN_EPOCH) + date.timeScalesOffset(TimeScalesFactory.getUTC(), TimeScalesFactory.getTT())) / 86400.0;
        double UT = (jd + 0.5) % 1.0;
        double seconds_per_day = 86400.0;
        double jd_2000 = 2451545.0;
        double t_cen = (jd - UT - 2451545.0) / 36525.0;
        double GMST = 24110.54841 + t_cen * (8640184.812866 + t_cen * (0.093104 - t_cen * 6.2E-6));
        if ((GMST = (GMST + 86636.555366976 * UT) % 86400.0) < 0.0) {
            GMST += 86400.0;
        }
        return Math.PI * 2 * GMST / 86400.0;
    }

    protected abstract void luniSolarTermsComputation() throws OrekitException;

    protected abstract void deepSecularEffects(double var1);

    protected abstract void deepPeriodicEffects(double var1);
}

