/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.exception.util.ExceptionContextProvider;
import org.apache.commons.math3.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AbstractPropagator;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.EventState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractAnalyticalPropagator
extends AbstractPropagator {
    private final BasicStepInterpolator interpolator;
    private PVCoordinatesProvider pvProvider;
    private AbsoluteDate lastPropagationStart;
    private AbsoluteDate lastPropagationEnd;
    private boolean statesInitialized;
    private boolean isLastStep;
    private final Collection<EventState<?>> eventsStates;

    protected AbstractAnalyticalPropagator(AttitudeProvider attitudeProvider) {
        this.setAttitudeProvider(attitudeProvider);
        this.interpolator = new BasicStepInterpolator();
        this.pvProvider = new LocalPVProvider();
        this.lastPropagationStart = AbsoluteDate.PAST_INFINITY;
        this.lastPropagationEnd = AbsoluteDate.FUTURE_INFINITY;
        this.statesInitialized = false;
        this.eventsStates = new ArrayList();
    }

    @Override
    public BoundedPropagator getGeneratedEphemeris() {
        return new BoundedPropagatorView(this.lastPropagationStart, this.lastPropagationEnd);
    }

    @Override
    public <T extends EventDetector> void addEventDetector(T detector) {
        this.eventsStates.add(new EventState<T>(detector));
    }

    @Override
    public Collection<EventDetector> getEventsDetectors() {
        ArrayList list = new ArrayList();
        for (EventState<?> state : this.eventsStates) {
            list.add(state.getEventDetector());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void clearEventsDetectors() {
        this.eventsStates.clear();
    }

    @Override
    public SpacecraftState propagate(AbsoluteDate start, AbsoluteDate target) throws PropagationException {
        try {
            this.lastPropagationStart = start;
            double dt = target.durationFrom(start);
            double epsilon = FastMath.ulp((double)dt);
            this.interpolator.storeDate(start);
            SpacecraftState state = this.interpolator.getInterpolatedState();
            double stepSize = this.getMode() == 1 ? (Double.isNaN(this.getFixedStepSize()) ? FastMath.copySign((double)(state.getKeplerianPeriod() / 100.0), (double)dt) : FastMath.copySign((double)this.getFixedStepSize(), (double)dt)) : dt;
            for (EventState<?> es : this.eventsStates) {
                es.init(state, target);
            }
            if (this.getStepHandler() != null) {
                this.getStepHandler().init(state, target);
            }
            this.statesInitialized = false;
            this.isLastStep = false;
            do {
                this.interpolator.shift();
                AbsoluteDate t = this.interpolator.getCurrentDate().shiftedBy(stepSize);
                if (dt == 0.0 || dt > 0.0 ^ t.compareTo(target) <= 0) {
                    this.interpolator.storeDate(target);
                } else {
                    this.interpolator.storeDate(t);
                }
                state = this.acceptStep(target, epsilon);
            } while (!this.isLastStep);
            this.lastPropagationEnd = state.getDate();
            this.setStartDate(state.getDate());
            return state;
        }
        catch (PropagationException pe) {
            throw pe;
        }
        catch (OrekitException oe) {
            throw PropagationException.unwrap(oe);
        }
        catch (TooManyEvaluationsException tmee) {
            throw PropagationException.unwrap((ExceptionContextProvider)tmee);
        }
        catch (NoBracketingException nbe) {
            throw PropagationException.unwrap((ExceptionContextProvider)nbe);
        }
    }

    protected SpacecraftState acceptStep(AbsoluteDate target, double epsilon) throws OrekitException, TooManyEvaluationsException, NoBracketingException {
        AbsoluteDate previousT = this.interpolator.getGlobalPreviousDate();
        AbsoluteDate currentT = this.interpolator.getGlobalCurrentDate();
        if (!this.statesInitialized) {
            if (!this.eventsStates.isEmpty()) {
                AbsoluteDate t0 = this.interpolator.getPreviousDate();
                this.interpolator.setInterpolatedDate(t0);
                SpacecraftState y = this.interpolator.getInterpolatedState();
                for (EventState<?> state : this.eventsStates) {
                    state.reinitializeBegin(y, this.interpolator.isForward());
                }
            }
            this.statesInitialized = true;
        }
        ArrayList<EventState> occurringEvents = new ArrayList<EventState>();
        for (EventState<?> state : this.eventsStates) {
            if (!state.evaluateStep(this.interpolator)) continue;
            occurringEvents.add(state);
        }
        final int orderingSign = this.interpolator.isForward() ? 1 : -1;
        Comparator sorter = new Comparator<EventState<?>>(){

            @Override
            public int compare(EventState<?> es0, EventState<?> es1) {
                return orderingSign * es0.getEventTime().compareTo(es1.getEventTime());
            }
        };
        while (!occurringEvents.isEmpty()) {
            Collections.sort(occurringEvents, sorter);
            Iterator iterator = occurringEvents.iterator();
            EventState currentEvent = (EventState)iterator.next();
            iterator.remove();
            AbsoluteDate eventT = currentEvent.getEventTime();
            this.interpolator.setSoftPreviousDate(previousT);
            this.interpolator.setSoftCurrentDate(eventT);
            this.interpolator.setInterpolatedDate(eventT);
            SpacecraftState eventY = this.interpolator.getInterpolatedState();
            currentEvent.stepAccepted(eventY);
            this.isLastStep = currentEvent.stop();
            if (this.getStepHandler() != null) {
                this.getStepHandler().handleStep(this.interpolator, this.isLastStep);
            }
            if (this.isLastStep) {
                return eventY;
            }
            SpacecraftState resetState = currentEvent.reset(eventY);
            if (resetState != null) {
                this.resetInitialState(resetState);
                return resetState;
            }
            previousT = eventT;
            this.interpolator.setSoftPreviousDate(eventT);
            this.interpolator.setSoftCurrentDate(currentT);
            if (!currentEvent.evaluateStep(this.interpolator)) continue;
            occurringEvents.add(currentEvent);
        }
        double remaining = target.durationFrom(currentT);
        if (this.interpolator.isForward()) {
            this.isLastStep = remaining < epsilon;
        } else {
            boolean bl = this.isLastStep = remaining > -epsilon;
        }
        if (this.isLastStep) {
            currentT = target;
        }
        this.interpolator.setInterpolatedDate(currentT);
        SpacecraftState currentY = this.interpolator.getInterpolatedState();
        for (EventState<?> state : this.eventsStates) {
            state.stepAccepted(currentY);
            this.isLastStep = this.isLastStep || state.stop();
        }
        if (this.getStepHandler() != null) {
            this.getStepHandler().handleStep(this.interpolator, this.isLastStep);
        }
        return currentY;
    }

    protected abstract double getMass(AbsoluteDate var1) throws PropagationException;

    public PVCoordinatesProvider getPvProvider() {
        return this.pvProvider;
    }

    protected abstract Orbit propagateOrbit(AbsoluteDate var1) throws PropagationException;

    protected SpacecraftState basicPropagate(AbsoluteDate date) throws PropagationException {
        try {
            Orbit orbit = this.propagateOrbit(date);
            Attitude attitude = this.getAttitudeProvider().getAttitude(this.pvProvider, date, orbit.getFrame());
            return new SpacecraftState(orbit, attitude, this.getMass(date));
        }
        catch (OrekitException oe) {
            throw new PropagationException(oe);
        }
    }

    private class BasicStepInterpolator
    implements OrekitStepInterpolator {
        private AbsoluteDate globalPreviousDate = AbsoluteDate.PAST_INFINITY;
        private AbsoluteDate globalCurrentDate = AbsoluteDate.PAST_INFINITY;
        private AbsoluteDate softPreviousDate = AbsoluteDate.PAST_INFINITY;
        private AbsoluteDate softCurrentDate = AbsoluteDate.PAST_INFINITY;
        private SpacecraftState interpolatedState;
        private boolean forward;

        public void setSoftPreviousDate(AbsoluteDate softPreviousDate) {
            this.softPreviousDate = softPreviousDate;
        }

        public void setSoftCurrentDate(AbsoluteDate softCurrentDate) {
            this.softCurrentDate = softCurrentDate;
        }

        public AbsoluteDate getGlobalPreviousDate() {
            return this.globalPreviousDate;
        }

        public AbsoluteDate getGlobalCurrentDate() {
            return this.globalCurrentDate;
        }

        @Override
        public AbsoluteDate getCurrentDate() {
            return this.softCurrentDate;
        }

        @Override
        public AbsoluteDate getInterpolatedDate() {
            return this.interpolatedState.getDate();
        }

        @Override
        public SpacecraftState getInterpolatedState() throws OrekitException {
            return this.interpolatedState;
        }

        @Override
        public AbsoluteDate getPreviousDate() {
            return this.softPreviousDate;
        }

        @Override
        public boolean isForward() {
            return this.forward;
        }

        @Override
        public void setInterpolatedDate(AbsoluteDate date) throws PropagationException {
            SpacecraftState basicState = AbstractAnalyticalPropagator.this.basicPropagate(date);
            this.interpolatedState = AbstractAnalyticalPropagator.this.updateAdditionalStates(basicState);
        }

        public void shift() {
            this.softPreviousDate = this.globalPreviousDate = this.globalCurrentDate;
            this.softCurrentDate = this.globalCurrentDate;
        }

        public void storeDate(AbsoluteDate date) throws PropagationException {
            this.softCurrentDate = this.globalCurrentDate = date;
            this.forward = this.globalCurrentDate.compareTo(this.globalPreviousDate) >= 0;
            this.setInterpolatedDate(this.globalCurrentDate);
        }
    }

    private class BoundedPropagatorView
    extends AbstractAnalyticalPropagator
    implements BoundedPropagator {
        private final AbsoluteDate minDate;
        private final AbsoluteDate maxDate;

        public BoundedPropagatorView(AbsoluteDate startDate, AbsoluteDate endDate) {
            super(AbstractAnalyticalPropagator.this.getAttitudeProvider());
            if (startDate.compareTo(endDate) <= 0) {
                this.minDate = startDate;
                this.maxDate = endDate;
            } else {
                this.minDate = endDate;
                this.maxDate = startDate;
            }
        }

        @Override
        public AbsoluteDate getMinDate() {
            return this.minDate;
        }

        @Override
        public AbsoluteDate getMaxDate() {
            return this.maxDate;
        }

        @Override
        protected Orbit propagateOrbit(AbsoluteDate target) throws PropagationException {
            return AbstractAnalyticalPropagator.this.propagateOrbit(target);
        }

        @Override
        public double getMass(AbsoluteDate date) throws PropagationException {
            return AbstractAnalyticalPropagator.this.getMass(date);
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
            return this.propagate(date).getPVCoordinates(frame);
        }

        @Override
        public void resetInitialState(SpacecraftState state) throws PropagationException {
            AbstractAnalyticalPropagator.this.resetInitialState(state);
        }

        @Override
        public SpacecraftState getInitialState() throws PropagationException {
            return AbstractAnalyticalPropagator.this.getInitialState();
        }
    }

    private class LocalPVProvider
    implements PVCoordinatesProvider {
        private LocalPVProvider() {
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
            return AbstractAnalyticalPropagator.this.propagateOrbit(date).getPVCoordinates(frame);
        }
    }
}

