/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepNormalizer;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractPropagator
implements Propagator {
    private int mode = 0;
    private double fixedStepSize = Double.NaN;
    private OrekitStepHandler stepHandler = null;
    private AbsoluteDate startDate;
    private AttitudeProvider attitudeProvider;
    private final List<AdditionalStateProvider> additionalStateProviders = new ArrayList<AdditionalStateProvider>();
    private SpacecraftState initialState;

    protected AbstractPropagator() {
    }

    protected void setStartDate(AbsoluteDate startDate) {
        this.startDate = startDate;
    }

    protected AbsoluteDate getStartDate() {
        return this.startDate;
    }

    @Override
    public AttitudeProvider getAttitudeProvider() {
        return this.attitudeProvider;
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attitudeProvider = attitudeProvider;
    }

    @Override
    public SpacecraftState getInitialState() throws PropagationException {
        return this.initialState;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public Frame getFrame() {
        return this.initialState.getFrame();
    }

    @Override
    public void resetInitialState(SpacecraftState state) throws PropagationException {
        this.initialState = state;
        this.setStartDate(state.getDate());
    }

    @Override
    public void setSlaveMode() {
        this.mode = 0;
        this.stepHandler = null;
        this.fixedStepSize = Double.NaN;
    }

    @Override
    public void setMasterMode(double h, OrekitFixedStepHandler handler) {
        this.setMasterMode(new OrekitStepNormalizer(h, handler));
        this.fixedStepSize = h;
    }

    @Override
    public void setMasterMode(OrekitStepHandler handler) {
        this.mode = 1;
        this.stepHandler = handler;
        this.fixedStepSize = Double.NaN;
    }

    @Override
    public void setEphemerisMode() {
        this.mode = 2;
        this.stepHandler = null;
        this.fixedStepSize = Double.NaN;
    }

    @Override
    public void addAdditionalStateProvider(AdditionalStateProvider additionalStateProvider) throws OrekitException {
        if (this.isAdditionalStateManaged(additionalStateProvider.getName())) {
            throw new OrekitException((Localizable)OrekitMessages.ADDITIONAL_STATE_NAME_ALREADY_IN_USE, additionalStateProvider.getName());
        }
        this.additionalStateProviders.add(additionalStateProvider);
    }

    @Override
    public List<AdditionalStateProvider> getAdditionalStateProviders() {
        return Collections.unmodifiableList(this.additionalStateProviders);
    }

    protected SpacecraftState updateAdditionalStates(SpacecraftState original) throws PropagationException {
        SpacecraftState updated = original;
        if (this.initialState != null) {
            for (Map.Entry entry : this.initialState.getAdditionalStates().entrySet()) {
                if (this.isAdditionalStateManaged((String)entry.getKey())) continue;
                updated = updated.addAdditionalState((String)entry.getKey(), (double[])entry.getValue());
            }
        }
        for (AdditionalStateProvider additionalStateProvider : this.additionalStateProviders) {
            updated = updated.addAdditionalState(additionalStateProvider.getName(), additionalStateProvider.getAdditionalState(updated));
        }
        return updated;
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        for (AdditionalStateProvider provider : this.additionalStateProviders) {
            if (!provider.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] managed = new String[this.additionalStateProviders.size()];
        for (int i = 0; i < managed.length; ++i) {
            managed[i] = this.additionalStateProviders.get(i).getName();
        }
        return managed;
    }

    protected double getFixedStepSize() {
        return this.fixedStepSize;
    }

    protected OrekitStepHandler getStepHandler() {
        return this.stepHandler;
    }

    @Override
    public abstract BoundedPropagator getGeneratedEphemeris();

    @Override
    public abstract <T extends EventDetector> void addEventDetector(T var1);

    @Override
    public abstract Collection<EventDetector> getEventsDetectors();

    @Override
    public abstract void clearEventsDetectors();

    @Override
    public SpacecraftState propagate(AbsoluteDate target) throws PropagationException {
        if (this.startDate == null) {
            this.startDate = this.getInitialState().getDate();
        }
        return this.propagate(this.startDate, target);
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) throws OrekitException {
        return this.propagate(date).getPVCoordinates(frame);
    }
}

