/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.frames.Frame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public enum OrbitType {
    CARTESIAN{

        @Override
        public Orbit convertType(Orbit orbit) {
            return orbit.getType() == this ? orbit : new CartesianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            Vector3D p = pv.getPosition();
            Vector3D v = pv.getVelocity();
            stateVector[0] = p.getX();
            stateVector[1] = p.getY();
            stateVector[2] = p.getZ();
            stateVector[3] = v.getX();
            stateVector[4] = v.getY();
            stateVector[5] = v.getZ();
        }

        @Override
        public Orbit mapArrayToOrbit(double[] stateVector, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            Vector3D p = new Vector3D(stateVector[0], stateVector[1], stateVector[2]);
            double r2 = p.getNormSq();
            Vector3D v = new Vector3D(stateVector[3], stateVector[4], stateVector[5]);
            Vector3D a = new Vector3D(-mu / (r2 * FastMath.sqrt((double)r2)), p);
            return new CartesianOrbit(new PVCoordinates(p, v, a), frame, date, mu);
        }
    }
    ,
    CIRCULAR{

        @Override
        public Orbit convertType(Orbit orbit) {
            return orbit.getType() == this ? orbit : new CircularOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector) {
            CircularOrbit circularOrbit = (CircularOrbit)CIRCULAR.convertType(orbit);
            stateVector[0] = circularOrbit.getA();
            stateVector[1] = circularOrbit.getCircularEx();
            stateVector[2] = circularOrbit.getCircularEy();
            stateVector[3] = circularOrbit.getI();
            stateVector[4] = circularOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = circularOrbit.getAlpha(type);
        }

        @Override
        public Orbit mapArrayToOrbit(double[] stateVector, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            return new CircularOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
        }
    }
    ,
    EQUINOCTIAL{

        @Override
        public Orbit convertType(Orbit orbit) {
            return orbit.getType() == this ? orbit : new EquinoctialOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector) {
            EquinoctialOrbit equinoctialOrbit = (EquinoctialOrbit)EQUINOCTIAL.convertType(orbit);
            stateVector[0] = equinoctialOrbit.getA();
            stateVector[1] = equinoctialOrbit.getEquinoctialEx();
            stateVector[2] = equinoctialOrbit.getEquinoctialEy();
            stateVector[3] = equinoctialOrbit.getHx();
            stateVector[4] = equinoctialOrbit.getHy();
            stateVector[5] = equinoctialOrbit.getL(type);
        }

        @Override
        public Orbit mapArrayToOrbit(double[] stateVector, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            return new EquinoctialOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
        }
    }
    ,
    KEPLERIAN{

        @Override
        public Orbit convertType(Orbit orbit) {
            return orbit.getType() == this ? orbit : new KeplerianOrbit(orbit);
        }

        @Override
        public void mapOrbitToArray(Orbit orbit, PositionAngle type, double[] stateVector) {
            KeplerianOrbit keplerianOrbit = (KeplerianOrbit)KEPLERIAN.convertType(orbit);
            stateVector[0] = keplerianOrbit.getA();
            stateVector[1] = keplerianOrbit.getE();
            stateVector[2] = keplerianOrbit.getI();
            stateVector[3] = keplerianOrbit.getPerigeeArgument();
            stateVector[4] = keplerianOrbit.getRightAscensionOfAscendingNode();
            stateVector[5] = keplerianOrbit.getAnomaly(type);
        }

        @Override
        public Orbit mapArrayToOrbit(double[] stateVector, PositionAngle type, AbsoluteDate date, double mu, Frame frame) {
            return new KeplerianOrbit(stateVector[0], stateVector[1], stateVector[2], stateVector[3], stateVector[4], stateVector[5], type, frame, date, mu);
        }
    };


    public abstract Orbit convertType(Orbit var1);

    public abstract void mapOrbitToArray(Orbit var1, PositionAngle var2, double[] var3);

    public abstract Orbit mapArrayToOrbit(double[] var1, PositionAngle var2, AbsoluteDate var3, double var4, Frame var6);
}

