/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.exception.ConvergenceException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.apache.commons.math3.util.FastMath;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.EquinoctialOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.CartesianDerivativesFilter;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class CartesianOrbit
extends Orbit {
    private static final long serialVersionUID = 20140723L;
    private transient EquinoctialOrbit equinoctial;

    public CartesianOrbit(TimeStampedPVCoordinates pvaCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        super(pvaCoordinates, frame, mu);
        this.equinoctial = null;
    }

    public CartesianOrbit(PVCoordinates pvaCoordinates, Frame frame, AbsoluteDate date, double mu) throws IllegalArgumentException {
        this(new TimeStampedPVCoordinates(date, pvaCoordinates), frame, mu);
    }

    public CartesianOrbit(Orbit op) {
        super(op.getPVCoordinates(), op.getFrame(), op.getMu());
        this.equinoctial = op instanceof EquinoctialOrbit ? (EquinoctialOrbit)op : (op instanceof CartesianOrbit ? ((CartesianOrbit)op).equinoctial : null);
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CARTESIAN;
    }

    private void initEquinoctial() {
        if (this.equinoctial == null) {
            this.equinoctial = new EquinoctialOrbit(this.getPVCoordinates(), this.getFrame(), this.getDate(), this.getMu());
        }
    }

    @Override
    public double getA() {
        double r = this.getPVCoordinates().getPosition().getNorm();
        double V2 = this.getPVCoordinates().getVelocity().getNormSq();
        return r / (2.0 - r * V2 / this.getMu());
    }

    @Override
    public double getE() {
        Vector3D pvP = this.getPVCoordinates().getPosition();
        Vector3D pvV = this.getPVCoordinates().getVelocity();
        double rV2OnMu = pvP.getNorm() * pvV.getNormSq() / this.getMu();
        double eSE = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)(this.getMu() * this.getA()));
        double eCE = rV2OnMu - 1.0;
        return FastMath.sqrt((double)(eCE * eCE + eSE * eSE));
    }

    @Override
    public double getI() {
        return Vector3D.angle((Vector3D)Vector3D.PLUS_K, (Vector3D)this.getPVCoordinates().getMomentum());
    }

    @Override
    public double getEquinoctialEx() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEx();
    }

    @Override
    public double getEquinoctialEy() {
        this.initEquinoctial();
        return this.equinoctial.getEquinoctialEy();
    }

    @Override
    public double getHx() {
        Vector3D w = this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return -w.getY() / (1.0 + w.getZ());
    }

    @Override
    public double getHy() {
        Vector3D w = this.getPVCoordinates().getMomentum().normalize();
        if (w.getX() * w.getX() + w.getY() * w.getY() == 0.0 && w.getZ() < 0.0) {
            return Double.NaN;
        }
        return w.getX() / (1.0 + w.getZ());
    }

    @Override
    public double getLv() {
        this.initEquinoctial();
        return this.equinoctial.getLv();
    }

    @Override
    public double getLE() {
        this.initEquinoctial();
        return this.equinoctial.getLE();
    }

    @Override
    public double getLM() {
        this.initEquinoctial();
        return this.equinoctial.getLM();
    }

    @Override
    protected TimeStampedPVCoordinates initPVCoordinates() {
        return this.getPVCoordinates();
    }

    @Override
    public CartesianOrbit shiftedBy(double dt) {
        PVCoordinates shiftedPV = this.getA() < 0.0 ? this.shiftPVHyperbolic(dt) : this.shiftPVElliptic(dt);
        return new CartesianOrbit(shiftedPV, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
    }

    @Override
    public CartesianOrbit interpolate(AbsoluteDate date, Collection<Orbit> sample) {
        ArrayList<TimeStampedPVCoordinates> datedPV = new ArrayList<TimeStampedPVCoordinates>(sample.size());
        for (Orbit o : sample) {
            datedPV.add(new TimeStampedPVCoordinates(o.getDate(), o.getPVCoordinates().getPosition(), o.getPVCoordinates().getVelocity(), o.getPVCoordinates().getAcceleration()));
        }
        TimeStampedPVCoordinates interpolated = TimeStampedPVCoordinates.interpolate(date, CartesianDerivativesFilter.USE_PVA, datedPV);
        return new CartesianOrbit(interpolated, this.getFrame(), date, this.getMu());
    }

    private PVCoordinates shiftPVElliptic(double dt) {
        Vector3D pvP = this.getPVCoordinates().getPosition();
        Vector3D pvV = this.getPVCoordinates().getVelocity();
        double r = pvP.getNorm();
        double rV2OnMu = r * pvV.getNormSq() / this.getMu();
        double a = this.getA();
        double eSE = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)(this.getMu() * a));
        double eCE = rV2OnMu - 1.0;
        double e2 = eCE * eCE + eSE * eSE;
        Vector3D u = pvP.normalize();
        Vector3D v = Vector3D.crossProduct((Vector3D)this.getPVCoordinates().getMomentum(), (Vector3D)u).normalize();
        double ex = (eCE - e2) * a / r;
        double ey = -FastMath.sqrt((double)(1.0 - e2)) * eSE * a / r;
        double beta = 1.0 / (1.0 + FastMath.sqrt((double)(1.0 - e2)));
        double thetaE0 = FastMath.atan2((double)(ey + eSE * beta * ex), (double)(r / a + ex - eSE * beta * ey));
        double thetaM0 = thetaE0 - ex * FastMath.sin((double)thetaE0) + ey * FastMath.cos((double)thetaE0);
        double thetaM1 = thetaM0 + this.getKeplerianMeanMotion() * dt;
        double thetaE1 = this.meanToEccentric(thetaM1, ex, ey);
        double cTE = FastMath.cos((double)thetaE1);
        double sTE = FastMath.sin((double)thetaE1);
        double exey = ex * ey;
        double exCeyS = ex * cTE + ey * sTE;
        double x = a * ((1.0 - beta * ey * ey) * cTE + beta * exey * sTE - ex);
        double y = a * ((1.0 - beta * ex * ex) * sTE + beta * exey * cTE - ey);
        double factor = FastMath.sqrt((double)(this.getMu() / a)) / (1.0 - exCeyS);
        double xDot = factor * (-sTE + beta * ey * exCeyS);
        double yDot = factor * (cTE - beta * ex * exCeyS);
        Vector3D shiftedP = new Vector3D(x, u, y, v);
        double r2 = x * x + y * y;
        Vector3D shiftedV = new Vector3D(xDot, u, yDot, v);
        Vector3D shiftedA = new Vector3D(-this.getMu() / (r2 * FastMath.sqrt((double)r2)), shiftedP);
        return new PVCoordinates(shiftedP, shiftedV, shiftedA);
    }

    private PVCoordinates shiftPVHyperbolic(double dt) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D pvP = pv.getPosition();
        Vector3D pvV = pv.getVelocity();
        Vector3D pvM = pv.getMomentum();
        double r = pvP.getNorm();
        double rV2OnMu = r * pvV.getNormSq() / this.getMu();
        double a = this.getA();
        double muA = this.getMu() * a;
        double e = FastMath.sqrt((double)(1.0 - Vector3D.dotProduct((Vector3D)pvM, (Vector3D)pvM) / muA));
        double sqrt = FastMath.sqrt((double)((e + 1.0) / (e - 1.0)));
        double eSH = Vector3D.dotProduct((Vector3D)pvP, (Vector3D)pvV) / FastMath.sqrt((double)(-muA));
        double eCH = rV2OnMu - 1.0;
        double H0 = FastMath.log((double)((eCH + eSH) / (eCH - eSH))) / 2.0;
        double M0 = e * FastMath.sinh((double)H0) - H0;
        double v0 = 2.0 * FastMath.atan((double)(sqrt * FastMath.tanh((double)(H0 / 2.0))));
        Vector3D p = new Rotation(pvM, -v0).applyTo(pvP).normalize();
        Vector3D q = Vector3D.crossProduct((Vector3D)pvM, (Vector3D)p).normalize();
        double M1 = M0 + this.getKeplerianMeanMotion() * dt;
        double H1 = this.meanToHyperbolicEccentric(M1, e);
        double cH = FastMath.cosh((double)H1);
        double sH = FastMath.sinh((double)H1);
        double sE2m1 = FastMath.sqrt((double)((e - 1.0) * (e + 1.0)));
        double x = a * (cH - e);
        double y = -a * sE2m1 * sH;
        double factor = FastMath.sqrt((double)(this.getMu() / -a)) / (e * cH - 1.0);
        double xDot = -factor * sH;
        double yDot = factor * sE2m1 * cH;
        Vector3D shiftedP = new Vector3D(x, p, y, q);
        double r2 = x * x + y * y;
        Vector3D shiftedV = new Vector3D(xDot, p, yDot, q);
        Vector3D shiftedA = new Vector3D(-this.getMu() / (r2 * FastMath.sqrt((double)r2)), shiftedP);
        return new PVCoordinates(shiftedP, shiftedV, shiftedA);
    }

    private double meanToEccentric(double thetaM, double ex, double ey) {
        double thetaE = thetaM;
        double thetaEMthetaM = 0.0;
        int iter = 0;
        do {
            double cosThetaE = FastMath.cos((double)thetaE);
            double sinThetaE = FastMath.sin((double)thetaE);
            double f2 = ex * sinThetaE - ey * cosThetaE;
            double f1 = 1.0 - ex * cosThetaE - ey * sinThetaE;
            double f0 = thetaEMthetaM - f2;
            double f12 = 2.0 * f1;
            double shift = f0 * f12 / (f1 * f12 - f0 * f2);
            thetaE = thetaM + (thetaEMthetaM -= shift);
            if (!(FastMath.abs((double)shift) <= 1.0E-12)) continue;
            return thetaE;
        } while (++iter < 50);
        throw new ConvergenceException();
    }

    private double meanToHyperbolicEccentric(double M, double ecc) {
        double H = ecc < 1.6 ? (-Math.PI < M && M < 0.0 || M > Math.PI ? M - ecc : M + ecc) : (ecc < 3.6 && FastMath.abs((double)M) > Math.PI ? M - FastMath.copySign((double)ecc, (double)M) : M / (ecc - 1.0));
        int iter = 0;
        do {
            double f3 = ecc * FastMath.cosh((double)H);
            double f2 = ecc * FastMath.sinh((double)H);
            double f1 = f3 - 1.0;
            double f0 = f2 - H - M;
            double f12 = 2.0 * f1;
            double d = f0 / f12;
            double fdf = f1 - d * f2;
            double ds = f0 / fdf;
            double shift = f0 / (fdf + ds * ds * f3 / 6.0);
            H -= shift;
            if (!(FastMath.abs((double)shift) <= 1.0E-12)) continue;
            return H;
        } while (++iter < 50);
        throw new ConvergenceException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_HYPERBOLIC_ECCENTRIC_ANOMALY, new Object[]{iter});
    }

    @Override
    public void getJacobianWrtCartesian(PositionAngle type, double[][] jacobian) {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                jacobian[i][j] = 0.0;
            }
            jacobian[i][i] = 1.0;
        }
    }

    @Override
    protected double[][] computeJacobianMeanWrtCartesian() {
        return null;
    }

    @Override
    protected double[][] computeJacobianEccentricWrtCartesian() {
        return null;
    }

    @Override
    protected double[][] computeJacobianTrueWrtCartesian() {
        return null;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, double gm, double[] pDot) {
        TimeStampedPVCoordinates pv = this.getPVCoordinates();
        Vector3D velocity = pv.getVelocity();
        pDot[0] = pDot[0] + velocity.getX();
        pDot[1] = pDot[1] + velocity.getY();
        pDot[2] = pDot[2] + velocity.getZ();
        Vector3D position = pv.getPosition();
        double r2 = position.getNormSq();
        double coeff = -gm / (r2 * FastMath.sqrt((double)r2));
        pDot[3] = pDot[3] + coeff * position.getX();
        pDot[4] = pDot[4] + coeff * position.getY();
        pDot[5] = pDot[5] + coeff * position.getZ();
    }

    public String toString() {
        return "cartesian parameters: " + this.getPVCoordinates().toString();
    }

    private Object writeReplace() {
        return new DTO(this);
    }

    private static class DTO
    implements Serializable {
        private static final long serialVersionUID = 20140723L;
        private double[] d;
        private final Frame frame;

        private DTO(CartesianOrbit orbit) {
            TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
            double epoch = FastMath.floor((double)pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH));
            double offset = pv.getDate().durationFrom(AbsoluteDate.J2000_EPOCH.shiftedBy(epoch));
            this.d = new double[]{epoch, offset, orbit.getMu(), pv.getPosition().getX(), pv.getPosition().getY(), pv.getPosition().getZ(), pv.getVelocity().getX(), pv.getVelocity().getY(), pv.getVelocity().getZ(), pv.getAcceleration().getX(), pv.getAcceleration().getY(), pv.getAcceleration().getZ()};
            this.frame = orbit.getFrame();
        }

        private Object readResolve() {
            return new CartesianOrbit(new TimeStampedPVCoordinates(AbsoluteDate.J2000_EPOCH.shiftedBy(this.d[0]).shiftedBy(this.d[1]), new Vector3D(this.d[3], this.d[4], this.d[5]), new Vector3D(this.d[6], this.d[7], this.d[8]), new Vector3D(this.d[9], this.d[10], this.d[11])), this.frame, this.d[2]);
        }
    }
}

