/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Arrays;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.BivariateGridInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.InsufficientDataException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.models.earth.TroposphericDelayModel;
import org.orekit.utils.InterpolationTableLoader;

public class SaastamoinenModel
implements TroposphericDelayModel {
    private static final long serialVersionUID = -5702086204232977550L;
    private double t0;
    private double p0;
    private double r0;

    public SaastamoinenModel(double t0, double p0, double r0) {
        this.t0 = t0;
        this.p0 = p0;
        this.r0 = r0;
    }

    public static SaastamoinenModel getStandardModel() {
        return new SaastamoinenModel(291.16, 1013.25, 0.5);
    }

    @Override
    public double calculatePathDelay(double elevation, double height) {
        double T = this.t0 - 0.0065 * height;
        double P = this.p0 * FastMath.pow((double)(1.0 - 2.26E-5 * height), (double)5.225);
        double R = this.r0 * FastMath.exp((double)(-6.396E-4 * height));
        double B = Functions.INSTANCE.b.value(height / 1000.0);
        double e = R * FastMath.exp((double)Functions.INSTANCE.e.value(T));
        double zInDegree = FastMath.abs((double)(90.0 - elevation));
        double z = FastMath.toRadians((double)zInDegree);
        double deltaR = this.getDeltaR(height, zInDegree);
        double tan = FastMath.tan((double)z);
        double delta = 0.002277 / Math.cos(z) * (P + (1255.0 / T + 0.05) * e - B * tan * tan) + deltaR;
        return delta;
    }

    @Override
    public double calculateSignalDelay(double elevation, double height) {
        return this.calculatePathDelay(elevation, height) / 2.99792458E8;
    }

    private double getDeltaR(double height, double zenith) {
        double h = FastMath.min((double)Math.max(0.0, height), (double)5000.0);
        double z = FastMath.min((double)Math.abs(zenith), (double)90.0);
        return Functions.INSTANCE.deltaR.value(h, z);
    }

    private static class Functions {
        private static final Functions INSTANCE = new Functions();
        private final UnivariateFunction b;
        private final PolynomialFunction e;
        private final BivariateFunction deltaR;

        private Functions() {
            double[] xValForB = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};
            double[] yValForB = new double[]{1.156, 1.079, 1.006, 0.938, 0.874, 0.813, 0.757, 0.654, 0.563};
            this.b = new LinearInterpolator().interpolate(xValForB, yValForB);
            this.e = new PolynomialFunction(new double[]{-37.2465, 0.213166, -2.56908E-4});
            InterpolationTableLoader loader = new InterpolationTableLoader();
            BivariateFunction func = null;
            try {
                DataProvidersManager.getInstance().feed("^saastamoinen-correction\\.txt$", loader);
                if (!loader.stillAcceptsData()) {
                    func = new BilinearInterpolator().interpolate(loader.getAbscissaGrid(), loader.getOrdinateGrid(), loader.getValuesSamples());
                }
            }
            catch (OrekitException ex) {
                // empty catch block
            }
            if (func != null) {
                this.deltaR = func;
            } else {
                double[] xValForR = new double[]{0.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};
                double[] yValForR = new double[]{0.0, 60.0, 66.0, 70.0, 73.0, 75.0, 76.0, 77.0, 78.0, 78.5, 79.0, 79.5, 79.75, 80.0, 90.0};
                double[][] fval = new double[][]{{0.0, 0.003, 0.006, 0.012, 0.02, 0.031, 0.039, 0.05, 0.065, 0.075, 0.087, 0.102, 0.111, 0.121, 0.121}, {0.0, 0.003, 0.006, 0.011, 0.018, 0.028, 0.035, 0.045, 0.059, 0.068, 0.079, 0.093, 0.101, 0.11, 0.11}, {0.0, 0.002, 0.005, 0.01, 0.017, 0.025, 0.032, 0.041, 0.054, 0.062, 0.072, 0.085, 0.092, 0.1, 0.1}, {0.0, 0.002, 0.005, 0.009, 0.015, 0.023, 0.029, 0.037, 0.049, 0.056, 0.065, 0.077, 0.083, 0.091, 0.091}, {0.0, 0.002, 0.004, 0.008, 0.013, 0.021, 0.026, 0.033, 0.044, 0.051, 0.059, 0.07, 0.076, 0.083, 0.083}, {0.0, 0.002, 0.003, 0.006, 0.011, 0.017, 0.021, 0.027, 0.036, 0.042, 0.049, 0.058, 0.063, 0.068, 0.068}, {0.0, 0.001, 0.003, 0.005, 0.009, 0.014, 0.017, 0.022, 0.03, 0.034, 0.04, 0.047, 0.052, 0.056, 0.056}, {0.0, 0.001, 0.002, 0.004, 0.007, 0.011, 0.014, 0.018, 0.024, 0.028, 0.033, 0.039, 0.043, 0.047, 0.047}};
                this.deltaR = new BilinearInterpolator().interpolate(xValForR, yValForR, fval);
            }
        }

        private static class BilinearInterpolator
        implements BivariateGridInterpolator {
            private BilinearInterpolator() {
            }

            public BivariateFunction interpolate(double[] xval, double[] yval, double[][] fval) throws NoDataException, DimensionMismatchException, NonMonotonicSequenceException, NumberIsTooSmallException {
                if (xval == null || yval == null || fval == null || fval[0] == null) {
                    throw new IllegalArgumentException("Input arguments must all be non-null");
                }
                if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
                    throw new NoDataException();
                }
                MathArrays.checkOrder((double[])xval);
                MathArrays.checkOrder((double[])yval);
                return new BilinearInterpolatingFunction(xval, yval, fval);
            }
        }

        private static class BilinearInterpolatingFunction
        implements BivariateFunction {
            private static final int MIN_NUM_POINTS = 2;
            private final double[] xval;
            private final double[] yval;
            private final double[][] fval;

            public BilinearInterpolatingFunction(double[] x, double[] y, double[][] f) throws DimensionMismatchException, IllegalArgumentException, NoDataException, NonMonotonicSequenceException {
                if (x == null || y == null || f == null || f[0] == null) {
                    throw new IllegalArgumentException("All arguments must be non-null");
                }
                int xLen = x.length;
                int yLen = y.length;
                if (xLen == 0 || yLen == 0 || f.length == 0 || f[0].length == 0) {
                    throw new NoDataException();
                }
                if (xLen < 2 || yLen < 2 || f.length < 2 || f[0].length < 2) {
                    throw new InsufficientDataException();
                }
                if (xLen != f.length) {
                    throw new DimensionMismatchException(xLen, f.length);
                }
                if (yLen != f[0].length) {
                    throw new DimensionMismatchException(yLen, f[0].length);
                }
                MathArrays.checkOrder((double[])x);
                MathArrays.checkOrder((double[])y);
                this.xval = (double[])x.clone();
                this.yval = (double[])y.clone();
                this.fval = (double[][])f.clone();
            }

            public double value(double x, double y) {
                boolean offset = true;
                int count = 2;
                int i = this.searchIndex(x, this.xval, 1, 2);
                int j = this.searchIndex(y, this.yval, 1, 2);
                double x1 = this.xval[i];
                double x2 = this.xval[i + 1];
                double y1 = this.yval[j];
                double y2 = this.yval[j + 1];
                double fQ11 = this.fval[i][j];
                double fQ21 = this.fval[i + 1][j];
                double fQ12 = this.fval[i][j + 1];
                double fQ22 = this.fval[i + 1][j + 1];
                double f = (fQ11 * (x2 - x) * (y2 - y) + fQ21 * (x - x1) * (y2 - y) + fQ12 * (x2 - x) * (y - y1) + fQ22 * (x - x1) * (y - y1)) / ((x2 - x1) * (y2 - y1));
                return f;
            }

            private int searchIndex(double c, double[] val, int offset, int count) {
                int r = Arrays.binarySearch(val, c);
                if (r == -1 || r == -val.length - 1) {
                    throw new OutOfRangeException((Number)c, (Number)val[0], (Number)val[val.length - 1]);
                }
                r = r < 0 ? -r - offset - 1 : (r -= offset);
                if (r < 0) {
                    r = 0;
                }
                if (r + count >= val.length) {
                    r = val.length - count;
                }
                return r;
            }
        }
    }
}

