/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.orekit.data.DataLoader;
import org.orekit.models.earth.GeoMagneticField;

public class GeoMagneticModelLoader
implements DataLoader {
    private List<GeoMagneticField> models = new LinkedList<GeoMagneticField>();

    public Collection<GeoMagneticField> getModels() {
        return this.models;
    }

    @Override
    public boolean stillAcceptsData() {
        return this.models == null || this.models.isEmpty();
    }

    @Override
    public void loadData(InputStream input, String name) throws IOException, ParseException {
        GeoMagneticField model;
        StreamTokenizer str = new StreamTokenizer(new InputStreamReader(input, "UTF-8"));
        while ((model = this.readModel(str)) != null) {
            this.models.add(model);
        }
    }

    private GeoMagneticField readModel(StreamTokenizer stream) throws IOException {
        int m;
        int n;
        int ttype = stream.nextToken();
        if (ttype == -1) {
            return null;
        }
        String modelName = stream.sval;
        stream.nextToken();
        double epoch = stream.nval;
        stream.nextToken();
        int nMax = (int)stream.nval;
        stream.nextToken();
        int nMaxSecVar = (int)stream.nval;
        stream.nextToken();
        stream.nextToken();
        double startYear = stream.nval;
        stream.nextToken();
        double endYear = stream.nval;
        GeoMagneticField model = new GeoMagneticField(modelName, epoch, nMax, nMaxSecVar, startYear, endYear);
        stream.nextToken();
        double altmin = stream.nval;
        stream.nextToken();
        double altmax = stream.nval;
        stream.nextToken();
        stream.nextToken();
        boolean done = false;
        do {
            stream.nextToken();
            n = (int)stream.nval;
            stream.nextToken();
            m = (int)stream.nval;
            stream.nextToken();
            double gnm = stream.nval;
            stream.nextToken();
            double hnm = stream.nval;
            stream.nextToken();
            double dgnm = stream.nval;
            stream.nextToken();
            double dhnm = stream.nval;
            model.setMainFieldCoefficients(n, m, gnm, hnm);
            if (n <= nMaxSecVar && m <= nMaxSecVar) {
                model.setSecularVariationCoefficients(n, m, dgnm, dhnm);
            }
            stream.nextToken();
            stream.nextToken();
        } while (!(done = n == nMax && m == nMax));
        return model;
    }
}

