/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import org.apache.commons.math3.exception.util.Localizable;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.TroposphericDelayModel;
import org.orekit.utils.InterpolationTableLoader;

public class FixedTroposphericDelay
implements TroposphericDelayModel {
    private static final long serialVersionUID = -92320711761929077L;
    private static FixedTroposphericDelay defaultModel;
    private final double[] xArr;
    private final double[] yArr;
    private final double[][] fArr;
    private transient BivariateFunction delayFunction;

    public FixedTroposphericDelay(double[] xArr, double[] yArr, double[][] fArr) {
        this.xArr = (double[])xArr.clone();
        this.yArr = (double[])yArr.clone();
        this.fArr = (double[][])fArr.clone();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(xArr, yArr, fArr);
    }

    public FixedTroposphericDelay(String supportedName) throws OrekitException {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        DataProvidersManager.getInstance().feed(supportedName, loader);
        if (loader.stillAcceptsData()) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_RESOURCE, supportedName);
        }
        this.xArr = loader.getAbscissaGrid();
        this.yArr = loader.getOrdinateGrid();
        this.fArr = loader.getValuesSamples();
        this.delayFunction = new PiecewiseBicubicSplineInterpolator().interpolate(this.xArr, this.yArr, this.fArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FixedTroposphericDelay getDefaultModel() throws OrekitException {
        Class<FixedTroposphericDelay> clazz = FixedTroposphericDelay.class;
        synchronized (FixedTroposphericDelay.class) {
            if (defaultModel == null) {
                defaultModel = new FixedTroposphericDelay("^tropospheric-delay\\.txt$");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultModel;
        }
    }

    @Override
    public double calculatePathDelay(double elevation, double height) {
        double h = Math.min(Math.max(0.0, height), 5000.0);
        double ele = Math.min(180.0, Math.max(0.0, elevation));
        double e = ele > 90.0 ? 180.0 - ele : ele;
        return this.delayFunction.value(h, e);
    }

    @Override
    public double calculateSignalDelay(double elevation, double height) {
        return this.calculatePathDelay(elevation, height) / 2.99792458E8;
    }

    private Object readResolve() {
        return new FixedTroposphericDelay(this.xArr, this.yArr, this.fArr);
    }
}

